/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.support;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import org.springframework.util.Assert;

public class VaultMount {
    private final String type;
    private final String description;
    private final Map<String, Object> config;

    private VaultMount(@JsonProperty(value="type") String type, @JsonProperty(value="description") String description, @JsonProperty(value="config") Map<String, Object> config) {
        this.type = type;
        this.description = description;
        this.config = config;
    }

    public static VaultMount create(String type) {
        return VaultMount.builder().type(type).build();
    }

    public static VaultMountBuilder builder() {
        return new VaultMountBuilder();
    }

    public String getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public Map<String, Object> getConfig() {
        return this.config;
    }

    public static class VaultMountBuilder {
        private String type;
        private String description;
        private Map<String, Object> config;

        VaultMountBuilder() {
        }

        public VaultMountBuilder type(String type) {
            Assert.hasText((String)type, (String)"Type must not be empty or null");
            this.type = type;
            return this;
        }

        public VaultMountBuilder description(String description) {
            this.description = description;
            return this;
        }

        public VaultMountBuilder config(Map<String, Object> config) {
            this.config = config;
            return this;
        }

        public VaultMount build() {
            Assert.hasText((String)this.type, (String)"Type must not be empty or null");
            return new VaultMount(this.type, this.description, this.config);
        }
    }
}

