/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.support;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.springframework.util.Assert;

public class VaultTransitKeyCreationRequest {
    private final Boolean derived;
    @JsonProperty(value="type")
    private final String type;
    @JsonProperty(value="convergent_encryption")
    private final Boolean convergentEncryption;
    private final Boolean exportable;

    private VaultTransitKeyCreationRequest(Boolean derived, String type, Boolean convergentEncryption, Boolean exportable) {
        this.derived = derived;
        this.type = type;
        this.convergentEncryption = convergentEncryption;
        this.exportable = exportable;
    }

    public static VaultTransitKeyCreationRequestBuilder builder() {
        return new VaultTransitKeyCreationRequestBuilder();
    }

    public Boolean getDerived() {
        return this.derived;
    }

    public Boolean getConvergentEncryption() {
        return this.convergentEncryption;
    }

    public String getType() {
        return this.type;
    }

    public Boolean getExportable() {
        return this.exportable;
    }

    public static class VaultTransitKeyCreationRequestBuilder {
        private Boolean derived;
        private String type = "aes256-gcm96";
        private Boolean convergentEncryption;
        private Boolean exportable;

        VaultTransitKeyCreationRequestBuilder() {
        }

        public VaultTransitKeyCreationRequestBuilder type(String type) {
            Assert.hasText((String)type, (String)"Type must not be empty");
            this.type = type;
            return this;
        }

        public VaultTransitKeyCreationRequestBuilder derived(boolean derived) {
            this.derived = derived;
            return this;
        }

        public VaultTransitKeyCreationRequestBuilder convergentEncryption(boolean convergentEncryption) {
            this.convergentEncryption = convergentEncryption;
            return this;
        }

        public VaultTransitKeyCreationRequestBuilder exportable(boolean exportable) {
            this.exportable = exportable;
            return this;
        }

        public VaultTransitKeyCreationRequest build() {
            Assert.hasText((String)this.type, (String)"Type must not be empty");
            return new VaultTransitKeyCreationRequest(this.derived, this.type, this.convergentEncryption, this.exportable);
        }
    }
}

