/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.authentication;

import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.http.HttpEntity;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.Trigger;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.vault.VaultException;
import org.springframework.vault.authentication.ClientAuthentication;
import org.springframework.vault.authentication.LifecycleAwareSessionManagerSupport;
import org.springframework.vault.authentication.LoginToken;
import org.springframework.vault.authentication.LoginTokenAdapter;
import org.springframework.vault.authentication.LoginTokenUtil;
import org.springframework.vault.authentication.SessionManager;
import org.springframework.vault.authentication.VaultTokenLookupException;
import org.springframework.vault.client.VaultHttpHeaders;
import org.springframework.vault.client.VaultResponses;
import org.springframework.vault.support.VaultResponse;
import org.springframework.vault.support.VaultToken;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestOperations;

public class LifecycleAwareSessionManager
extends LifecycleAwareSessionManagerSupport
implements SessionManager,
DisposableBean {
    private final ClientAuthentication clientAuthentication;
    private final RestOperations restOperations;
    private final Object lock = new Object();
    private volatile Optional<TokenWrapper> token = Optional.empty();

    public LifecycleAwareSessionManager(ClientAuthentication clientAuthentication, TaskScheduler taskScheduler, RestOperations restOperations) {
        super(taskScheduler);
        Assert.notNull((Object)clientAuthentication, (String)"ClientAuthentication must not be null");
        Assert.notNull((Object)taskScheduler, (String)"TaskScheduler must not be null");
        Assert.notNull((Object)restOperations, (String)"RestOperations must not be null");
        this.clientAuthentication = clientAuthentication;
        this.restOperations = restOperations;
    }

    public LifecycleAwareSessionManager(ClientAuthentication clientAuthentication, TaskScheduler taskScheduler, RestOperations restOperations, LifecycleAwareSessionManagerSupport.RefreshTrigger refreshTrigger) {
        super(taskScheduler, refreshTrigger);
        Assert.notNull((Object)clientAuthentication, (String)"ClientAuthentication must not be null");
        Assert.notNull((Object)taskScheduler, (String)"TaskScheduler must not be null");
        Assert.notNull((Object)restOperations, (String)"RestOperations must not be null");
        Assert.notNull((Object)refreshTrigger, (String)"RefreshTrigger must not be null");
        this.clientAuthentication = clientAuthentication;
        this.restOperations = restOperations;
    }

    public void destroy() {
        Optional<TokenWrapper> token = this.token;
        this.token = Optional.empty();
        token.filter(TokenWrapper::isRevocable).map(TokenWrapper::getToken).ifPresent(this::revoke);
    }

    protected void revoke(VaultToken token) {
        try {
            this.restOperations.postForObject("auth/token/revoke-self", (Object)new HttpEntity((MultiValueMap)VaultHttpHeaders.from(token)), Map.class, new Object[0]);
        }
        catch (HttpStatusCodeException e) {
            this.logger.warn((Object)String.format("Cannot revoke VaultToken: %s", VaultResponses.getError(e.getResponseBodyAsString())));
        }
    }

    protected boolean renewToken() {
        this.logger.info((Object)"Renewing token");
        Optional<TokenWrapper> token = this.token;
        if (!token.isPresent()) {
            this.getSessionToken();
            return false;
        }
        TokenWrapper wrapper = token.get();
        try {
            VaultResponse vaultResponse = (VaultResponse)this.restOperations.postForObject("auth/token/renew-self", (Object)new HttpEntity((MultiValueMap)VaultHttpHeaders.from(token.get().getToken())), VaultResponse.class, new Object[0]);
            LoginToken renewed = LoginTokenUtil.from(vaultResponse.getRequiredAuth());
            Duration validTtlThreshold = this.getRefreshTrigger().getValidTtlThreshold(renewed);
            if (renewed.getLeaseDuration().compareTo(validTtlThreshold) <= 0) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.info((Object)String.format("Token TTL (%s) exceeded validity TTL threshold (%s). Dropping token.", renewed.getLeaseDuration(), validTtlThreshold));
                } else {
                    this.logger.info((Object)"Token TTL exceeded validity TTL threshold. Dropping token.");
                }
                this.token = Optional.empty();
                return false;
            }
            this.token = Optional.of(new TokenWrapper(renewed, wrapper.revocable));
            return true;
        }
        catch (HttpStatusCodeException e) {
            this.logger.debug((Object)String.format("Cannot renew token, resetting token and performing re-login: %s", VaultResponses.getError(e.getResponseBodyAsString())));
            this.token = Optional.empty();
            if (e.getStatusCode().is4xxClientError()) {
                return false;
            }
            throw new VaultException(String.format("Cannot renew token: %s", VaultResponses.getError(e.getResponseBodyAsString())));
        }
        catch (RuntimeException e) {
            this.logger.debug((Object)String.format("Cannot renew token, resetting token and performing re-login: %s", e.toString()));
            this.token = Optional.empty();
            throw new VaultException("Cannot renew token", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VaultToken getSessionToken() {
        if (!this.token.isPresent()) {
            Object object = this.lock;
            synchronized (object) {
                if (!this.token.isPresent()) {
                    VaultToken token = this.clientAuthentication.login();
                    TokenWrapper wrapper = new TokenWrapper(token, token instanceof LoginToken);
                    if (this.isTokenSelfLookupEnabled() && !ClassUtils.isAssignableValue(LoginToken.class, (Object)token)) {
                        try {
                            token = LoginTokenAdapter.augmentWithSelfLookup(this.restOperations, token);
                            wrapper = new TokenWrapper(token, false);
                        }
                        catch (VaultTokenLookupException e) {
                            this.logger.warn((Object)String.format("Cannot enhance VaultToken to a LoginToken: %s", e.getMessage()));
                        }
                    }
                    this.token = Optional.of(wrapper);
                    if (this.isTokenRenewable()) {
                        this.scheduleRenewal();
                    }
                }
            }
        }
        return this.token.map(TokenWrapper::getToken).orElseThrow(() -> new IllegalStateException("Cannot obtain VaultToken"));
    }

    protected VaultToken login() {
        return this.clientAuthentication.login();
    }

    protected boolean isTokenRenewable() {
        return this.token.map(TokenWrapper::getToken).filter(LoginToken.class::isInstance).filter(it -> {
            LoginToken loginToken = (LoginToken)it;
            return !loginToken.getLeaseDuration().isZero() && loginToken.isRenewable();
        }).isPresent();
    }

    private void scheduleRenewal() {
        this.logger.info((Object)"Scheduling Token renewal");
        Runnable task = () -> {
            try {
                if (this.token.isPresent() && this.isTokenRenewable() && this.renewToken()) {
                    this.scheduleRenewal();
                }
            }
            catch (Exception e) {
                this.logger.error((Object)"Cannot renew VaultToken", (Throwable)e);
            }
        };
        Optional<TokenWrapper> token = this.token;
        token.ifPresent(tokenWrapper -> this.getTaskScheduler().schedule(task, (Trigger)this.createTrigger((TokenWrapper)tokenWrapper)));
    }

    private LifecycleAwareSessionManagerSupport.OneShotTrigger createTrigger(TokenWrapper tokenWrapper) {
        return new LifecycleAwareSessionManagerSupport.OneShotTrigger(this.getRefreshTrigger().nextExecutionTime((LoginToken)tokenWrapper.getToken()));
    }

    static class TokenWrapper {
        private final VaultToken token;
        private final boolean revocable;

        @ConstructorProperties(value={"token", "revocable"})
        public TokenWrapper(VaultToken token, boolean revocable) {
            this.token = token;
            this.revocable = revocable;
        }

        public VaultToken getToken() {
            return this.token;
        }

        public boolean isRevocable() {
            return this.revocable;
        }
    }
}

