/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.config;

import io.netty.channel.ChannelOption;
import io.netty.handler.ssl.SslContextBuilder;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.concurrent.atomic.AtomicLong;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.vault.config.ClientHttpRequestFactoryFactory;
import org.springframework.vault.support.ClientOptions;
import org.springframework.vault.support.SslConfiguration;
import reactor.ipc.netty.http.client.HttpClientOptions;
import reactor.ipc.netty.resources.PoolResources;

public class ClientHttpConnectorFactory {
    private static final AtomicLong POOL_COUNTER = new AtomicLong();

    public static ClientHttpConnector create(ClientOptions options, SslConfiguration sslConfiguration) {
        return new ReactorClientHttpConnector(builder -> {
            if (ClientHttpRequestFactoryFactory.hasSslConfiguration(sslConfiguration)) {
                ((HttpClientOptions.Builder)builder.sslSupport(sslContextBuilder -> ClientHttpConnectorFactory.configureSsl(sslConfiguration, sslContextBuilder))).poolResources(PoolResources.elastic((String)("vault-http-" + POOL_COUNTER.incrementAndGet())));
            }
            builder.sslHandshakeTimeout(options.getConnectionTimeout());
            builder.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)Math.toIntExact(options.getConnectionTimeout().toMillis()));
        });
    }

    private static void configureSsl(SslConfiguration sslConfiguration, SslContextBuilder sslContextBuilder) {
        try {
            if (sslConfiguration.getTrustStoreConfiguration().isPresent()) {
                sslContextBuilder.trustManager(ClientHttpRequestFactoryFactory.createTrustManagerFactory(sslConfiguration.getTrustStoreConfiguration()));
            }
            if (sslConfiguration.getKeyStoreConfiguration().isPresent()) {
                sslContextBuilder.keyManager(ClientHttpRequestFactoryFactory.createKeyManagerFactory(sslConfiguration.getKeyStoreConfiguration()));
            }
        }
        catch (IOException | GeneralSecurityException e) {
            throw new IllegalStateException(e);
        }
    }
}

