/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.authentication;

import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpEntity;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.vault.VaultException;
import org.springframework.vault.authentication.AppIdAuthentication;
import org.springframework.vault.authentication.AuthenticationSteps;
import org.springframework.vault.authentication.LoginTokenUtil;
import org.springframework.vault.authentication.VaultTokenSupplier;
import org.springframework.vault.support.VaultResponse;
import org.springframework.vault.support.VaultToken;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

public class AuthenticationStepsOperator
implements VaultTokenSupplier {
    private static final Log logger = LogFactory.getLog(AppIdAuthentication.class);
    private final AuthenticationSteps chain;
    private final WebClient webClient;

    public AuthenticationStepsOperator(AuthenticationSteps steps, WebClient webClient) {
        Assert.notNull((Object)steps, (String)"AuthenticationSteps must not be null");
        Assert.notNull((Object)webClient, (String)"WebClient must not be null");
        this.chain = steps;
        this.webClient = webClient;
    }

    @Override
    public Mono<VaultToken> getVaultToken() throws VaultException {
        Mono state = Mono.just((Object)Undefinded.INSTANCE);
        for (AuthenticationSteps.Node<?> o : this.chain.steps) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Executing %s with current state %s", o, state));
            }
            if (o instanceof AuthenticationSteps.HttpRequestNode) {
                state = state.flatMap(stateObject -> this.doHttpRequest((AuthenticationSteps.HttpRequestNode)o, stateObject));
            }
            if (o instanceof AuthenticationSteps.MapStep) {
                state = state.map(stateObject -> AuthenticationStepsOperator.doMapStep((AuthenticationSteps.MapStep)o, stateObject));
            }
            if (o instanceof AuthenticationSteps.OnNextStep) {
                state = state.doOnNext(stateObject -> AuthenticationStepsOperator.doOnNext((AuthenticationSteps.OnNextStep)o, stateObject));
            }
            if (o instanceof AuthenticationSteps.SupplierStep) {
                state = state.map(stateObject -> AuthenticationStepsOperator.doSupplierStep((AuthenticationSteps.SupplierStep)o));
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)String.format("Executed %s with current state %s", o, state));
        }
        return state.map(stateObject -> {
            if (stateObject instanceof VaultToken) {
                return (VaultToken)stateObject;
            }
            if (stateObject instanceof VaultResponse) {
                VaultResponse response = (VaultResponse)stateObject;
                Assert.state((response.getAuth() != null ? 1 : 0) != 0, (String)"Auth field must not be null");
                return LoginTokenUtil.from(response.getAuth());
            }
            throw new IllegalStateException(String.format("Cannot retrieve VaultToken from authentication chain. Got instead %s", stateObject));
        }).onErrorMap(t -> new VaultException("Cannot retrieve VaultToken from authentication chain", (Throwable)t));
    }

    private static Object doSupplierStep(AuthenticationSteps.SupplierStep<Object> supplierStep) {
        return supplierStep.get();
    }

    private static Object doMapStep(AuthenticationSteps.MapStep<Object, Object> o, Object state) {
        return o.apply(state);
    }

    private static Object doOnNext(AuthenticationSteps.OnNextStep<Object> o, Object state) {
        return o.apply(state);
    }

    private Mono<Object> doHttpRequest(AuthenticationSteps.HttpRequestNode<Object> step, Object state) {
        AuthenticationSteps.HttpRequest<Object> definition = step.getDefinition();
        HttpEntity<?> entity = AuthenticationStepsOperator.getEntity(definition.getEntity(), state);
        WebClient.RequestBodySpec spec = definition.getUri() == null ? (WebClient.RequestBodySpec)this.webClient.method(definition.getMethod()).uri(definition.getUriTemplate(), (Object[])definition.getUrlVariables()) : (WebClient.RequestBodySpec)this.webClient.method(definition.getMethod()).uri(definition.getUri());
        for (Map.Entry header : entity.getHeaders().entrySet()) {
            spec = (WebClient.RequestBodySpec)spec.header((String)header.getKey(), new String[]{(String)((List)header.getValue()).get(0)});
        }
        if (entity.getBody() != null && !entity.getBody().equals(Undefinded.INSTANCE)) {
            return spec.syncBody(entity.getBody()).retrieve().bodyToMono(definition.getResponseType());
        }
        return spec.retrieve().bodyToMono(definition.getResponseType());
    }

    private static HttpEntity<?> getEntity(HttpEntity<?> entity, Object state) {
        if (entity == null) {
            return state == null ? HttpEntity.EMPTY : new HttpEntity(state);
        }
        if (entity.getBody() == null && state != null) {
            return new HttpEntity(state, (MultiValueMap)entity.getHeaders());
        }
        return entity;
    }

    static class Undefinded {
        static final Undefinded INSTANCE = new Undefinded();

        private Undefinded() {
        }
    }
}

