/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.config;

import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import java.io.IOException;
import java.io.InputStream;
import java.net.ProxySelector;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import okhttp3.OkHttpClient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.HttpClient;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.SchemePortResolver;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.apache.http.impl.conn.DefaultSchemePortResolver;
import org.apache.http.impl.conn.SystemDefaultRoutePlanner;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.client.Netty4ClientHttpRequestFactory;
import org.springframework.http.client.OkHttp3ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.vault.support.ClientOptions;
import org.springframework.vault.support.SslConfiguration;

public class ClientHttpRequestFactoryFactory {
    private static final Log logger = LogFactory.getLog(ClientHttpRequestFactoryFactory.class);
    private static final boolean HTTP_COMPONENTS_PRESENT = ClientHttpRequestFactoryFactory.isPresent("org.apache.http.client.HttpClient");
    private static final boolean OKHTTP3_PRESENT = ClientHttpRequestFactoryFactory.isPresent("okhttp3.OkHttpClient");
    private static final boolean NETTY_PRESENT = ClientHttpRequestFactoryFactory.isPresent("io.netty.channel.nio.NioEventLoopGroup", "io.netty.handler.ssl.SslContext", "io.netty.handler.codec.http.HttpClientCodec");

    private static boolean isPresent(String ... classNames) {
        for (String className : classNames) {
            if (ClassUtils.isPresent((String)className, (ClassLoader)ClientHttpRequestFactoryFactory.class.getClassLoader())) continue;
            return false;
        }
        return true;
    }

    public static ClientHttpRequestFactory create(ClientOptions options, SslConfiguration sslConfiguration) {
        Assert.notNull((Object)options, (String)"ClientOptions must not be null");
        Assert.notNull((Object)sslConfiguration, (String)"SslConfiguration must not be null");
        try {
            if (HTTP_COMPONENTS_PRESENT) {
                return HttpComponents.usingHttpComponents(options, sslConfiguration);
            }
            if (OKHTTP3_PRESENT) {
                return OkHttp3.usingOkHttp3(options, sslConfiguration);
            }
            if (NETTY_PRESENT) {
                return Netty.usingNetty(options, sslConfiguration);
            }
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException(e);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        if (ClientHttpRequestFactoryFactory.hasSslConfiguration(sslConfiguration)) {
            logger.warn((Object)"VaultProperties has SSL configured but the SSL configuration must be applied outside the Vault Client to use the JDK HTTP client");
        }
        return new SimpleClientHttpRequestFactory();
    }

    static SSLContext getSSLContext(SslConfiguration sslConfiguration) throws GeneralSecurityException, IOException {
        KeyManager[] keyManagers = sslConfiguration.getKeyStoreConfiguration().isPresent() ? ClientHttpRequestFactoryFactory.createKeyManagerFactory(sslConfiguration.getKeyStoreConfiguration()).getKeyManagers() : null;
        TrustManager[] trustManagers = sslConfiguration.getTrustStoreConfiguration().isPresent() ? ClientHttpRequestFactoryFactory.createTrustManagerFactory(sslConfiguration.getTrustStoreConfiguration()).getTrustManagers() : null;
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(keyManagers, trustManagers, null);
        return sslContext;
    }

    static KeyManagerFactory createKeyManagerFactory(SslConfiguration.KeyStoreConfiguration keyStoreConfiguration) throws GeneralSecurityException, IOException {
        KeyStore keyStore = KeyStore.getInstance(StringUtils.hasText((String)keyStoreConfiguration.getStoreType()) ? keyStoreConfiguration.getStoreType() : KeyStore.getDefaultType());
        ClientHttpRequestFactoryFactory.loadKeyStore(keyStoreConfiguration, keyStore);
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keyStore, keyStoreConfiguration.getStorePassword() == null ? new char[]{} : keyStoreConfiguration.getStorePassword());
        return keyManagerFactory;
    }

    static TrustManagerFactory createTrustManagerFactory(SslConfiguration.KeyStoreConfiguration keyStoreConfiguration) throws GeneralSecurityException, IOException {
        KeyStore trustStore = KeyStore.getInstance(StringUtils.hasText((String)keyStoreConfiguration.getStoreType()) ? keyStoreConfiguration.getStoreType() : KeyStore.getDefaultType());
        ClientHttpRequestFactoryFactory.loadKeyStore(keyStoreConfiguration, trustStore);
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(trustStore);
        return trustManagerFactory;
    }

    private static void loadKeyStore(SslConfiguration.KeyStoreConfiguration keyStoreConfiguration, KeyStore keyStore) throws IOException, NoSuchAlgorithmException, CertificateException {
        try (InputStream inputStream = null;){
            inputStream = keyStoreConfiguration.getResource().getInputStream();
            keyStore.load(inputStream, keyStoreConfiguration.getStorePassword());
        }
    }

    static boolean hasSslConfiguration(SslConfiguration sslConfiguration) {
        return sslConfiguration.getTrustStoreConfiguration().isPresent() || sslConfiguration.getKeyStoreConfiguration().isPresent();
    }

    static class Netty {
        Netty() {
        }

        static ClientHttpRequestFactory usingNetty(ClientOptions options, SslConfiguration sslConfiguration) throws GeneralSecurityException, IOException {
            Netty4ClientHttpRequestFactory requestFactory = new Netty4ClientHttpRequestFactory();
            if (ClientHttpRequestFactoryFactory.hasSslConfiguration(sslConfiguration)) {
                SslContextBuilder sslContextBuilder = SslContextBuilder.forClient();
                if (sslConfiguration.getTrustStoreConfiguration().isPresent()) {
                    sslContextBuilder.trustManager(ClientHttpRequestFactoryFactory.createTrustManagerFactory(sslConfiguration.getTrustStoreConfiguration()));
                }
                if (sslConfiguration.getKeyStoreConfiguration().isPresent()) {
                    sslContextBuilder.keyManager(ClientHttpRequestFactoryFactory.createKeyManagerFactory(sslConfiguration.getKeyStoreConfiguration()));
                }
                requestFactory.setSslContext(sslContextBuilder.sslProvider(SslProvider.JDK).build());
            }
            requestFactory.setConnectTimeout(Math.toIntExact(options.getConnectionTimeout().toMillis()));
            requestFactory.setReadTimeout(Math.toIntExact(options.getReadTimeout().toMillis()));
            return requestFactory;
        }
    }

    static class OkHttp3 {
        OkHttp3() {
        }

        static ClientHttpRequestFactory usingOkHttp3(ClientOptions options, SslConfiguration sslConfiguration) throws GeneralSecurityException, IOException {
            OkHttpClient.Builder builder = new OkHttpClient.Builder();
            if (ClientHttpRequestFactoryFactory.hasSslConfiguration(sslConfiguration)) {
                builder.sslSocketFactory(ClientHttpRequestFactoryFactory.getSSLContext(sslConfiguration).getSocketFactory());
            }
            builder.connectTimeout(options.getConnectionTimeout().toMillis(), TimeUnit.MILLISECONDS).readTimeout(options.getReadTimeout().toMillis(), TimeUnit.MILLISECONDS);
            return new OkHttp3ClientHttpRequestFactory(builder.build());
        }
    }

    static class HttpComponents {
        HttpComponents() {
        }

        static ClientHttpRequestFactory usingHttpComponents(ClientOptions options, SslConfiguration sslConfiguration) throws GeneralSecurityException, IOException {
            HttpClientBuilder httpClientBuilder = HttpClients.custom();
            httpClientBuilder.setRoutePlanner((HttpRoutePlanner)new SystemDefaultRoutePlanner((SchemePortResolver)DefaultSchemePortResolver.INSTANCE, ProxySelector.getDefault()));
            if (ClientHttpRequestFactoryFactory.hasSslConfiguration(sslConfiguration)) {
                SSLContext sslContext = ClientHttpRequestFactoryFactory.getSSLContext(sslConfiguration);
                SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(sslContext);
                httpClientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslSocketFactory);
                httpClientBuilder.setSSLContext(sslContext);
            }
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(Math.toIntExact(options.getConnectionTimeout().toMillis())).setSocketTimeout(Math.toIntExact(options.getReadTimeout().toMillis())).setAuthenticationEnabled(true).build();
            httpClientBuilder.setDefaultRequestConfig(requestConfig);
            httpClientBuilder.setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy());
            return new HttpComponentsClientHttpRequestFactory((HttpClient)httpClientBuilder.build());
        }
    }
}

