/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.config;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.lang.Nullable;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.util.Assert;
import org.springframework.vault.authentication.ClientAuthentication;
import org.springframework.vault.authentication.LifecycleAwareSessionManager;
import org.springframework.vault.authentication.SessionManager;
import org.springframework.vault.client.SimpleVaultEndpointProvider;
import org.springframework.vault.client.VaultClients;
import org.springframework.vault.client.VaultEndpoint;
import org.springframework.vault.client.VaultEndpointProvider;
import org.springframework.vault.config.ClientHttpRequestFactoryFactory;
import org.springframework.vault.core.VaultTemplate;
import org.springframework.vault.core.lease.SecretLeaseContainer;
import org.springframework.vault.support.ClientOptions;
import org.springframework.vault.support.SslConfiguration;
import org.springframework.web.client.RestOperations;

@Configuration
public abstract class AbstractVaultConfiguration
implements ApplicationContextAware {
    @Nullable
    private ApplicationContext applicationContext;

    public abstract VaultEndpoint vaultEndpoint();

    public VaultEndpointProvider vaultEndpointProvider() {
        return SimpleVaultEndpointProvider.of(this.vaultEndpoint());
    }

    public abstract ClientAuthentication clientAuthentication();

    @Bean
    public VaultTemplate vaultTemplate() {
        return new VaultTemplate(this.vaultEndpointProvider(), this.clientHttpRequestFactoryWrapper().getClientHttpRequestFactory(), this.sessionManager());
    }

    @Bean
    public SessionManager sessionManager() {
        ClientAuthentication clientAuthentication = this.clientAuthentication();
        Assert.notNull((Object)clientAuthentication, (String)"ClientAuthentication must not be null");
        return new LifecycleAwareSessionManager(clientAuthentication, (TaskScheduler)this.threadPoolTaskScheduler(), this.restOperations());
    }

    @Bean
    public SecretLeaseContainer secretLeaseContainer() throws Exception {
        SecretLeaseContainer secretLeaseContainer = new SecretLeaseContainer(this.vaultTemplate(), (TaskScheduler)this.threadPoolTaskScheduler());
        secretLeaseContainer.afterPropertiesSet();
        secretLeaseContainer.start();
        return secretLeaseContainer;
    }

    @Bean
    public ThreadPoolTaskScheduler threadPoolTaskScheduler() {
        ThreadPoolTaskScheduler threadPoolTaskScheduler = new ThreadPoolTaskScheduler();
        threadPoolTaskScheduler.setThreadNamePrefix("spring-vault-ThreadPoolTaskScheduler-");
        threadPoolTaskScheduler.setDaemon(true);
        return threadPoolTaskScheduler;
    }

    public RestOperations restOperations() {
        return VaultClients.createRestTemplate(this.vaultEndpointProvider(), this.clientHttpRequestFactoryWrapper().getClientHttpRequestFactory());
    }

    @Bean
    public ClientFactoryWrapper clientHttpRequestFactoryWrapper() {
        return new ClientFactoryWrapper(ClientHttpRequestFactoryFactory.create(this.clientOptions(), this.sslConfiguration()));
    }

    public ClientOptions clientOptions() {
        return new ClientOptions();
    }

    public SslConfiguration sslConfiguration() {
        return SslConfiguration.unconfigured();
    }

    protected Environment getEnvironment() {
        Assert.state((this.applicationContext != null ? 1 : 0) != 0, (String)"ApplicationContext must be set before accessing getEnvironment()");
        return this.applicationContext.getEnvironment();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public static class ClientFactoryWrapper
    implements InitializingBean,
    DisposableBean {
        private final ClientHttpRequestFactory clientHttpRequestFactory;

        public ClientFactoryWrapper(ClientHttpRequestFactory clientHttpRequestFactory) {
            this.clientHttpRequestFactory = clientHttpRequestFactory;
        }

        public void destroy() throws Exception {
            if (this.clientHttpRequestFactory instanceof DisposableBean) {
                ((DisposableBean)this.clientHttpRequestFactory).destroy();
            }
        }

        public void afterPropertiesSet() throws Exception {
            if (this.clientHttpRequestFactory instanceof InitializingBean) {
                ((InitializingBean)this.clientHttpRequestFactory).afterPropertiesSet();
            }
        }

        public ClientHttpRequestFactory getClientHttpRequestFactory() {
            return this.clientHttpRequestFactory;
        }
    }
}

