/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.support;

import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.util.Arrays;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.Resource;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class SslConfiguration {
    private static final String DEFAULT_KEYSTORE_TYPE = KeyStore.getDefaultType();
    private final KeyStoreConfiguration keyStoreConfiguration;
    private final KeyStoreConfiguration trustStoreConfiguration;

    @Deprecated
    public SslConfiguration(Resource keyStore, @Nullable String keyStorePassword, Resource trustStore, @Nullable String trustStorePassword) {
        this(new KeyStoreConfiguration(keyStore, SslConfiguration.charsOrNull(keyStorePassword), DEFAULT_KEYSTORE_TYPE), new KeyStoreConfiguration(trustStore, SslConfiguration.charsOrNull(trustStorePassword), DEFAULT_KEYSTORE_TYPE));
    }

    public SslConfiguration(KeyStoreConfiguration keyStoreConfiguration, KeyStoreConfiguration trustStoreConfiguration) {
        Assert.notNull((Object)keyStoreConfiguration, (String)"KeyStore configuration must not be null");
        Assert.notNull((Object)trustStoreConfiguration, (String)"TrustStore configuration must not be null");
        this.keyStoreConfiguration = keyStoreConfiguration;
        this.trustStoreConfiguration = trustStoreConfiguration;
    }

    @Deprecated
    public static SslConfiguration forTrustStore(Resource trustStore, @Nullable String trustStorePassword) {
        return SslConfiguration.forTrustStore(trustStore, SslConfiguration.charsOrNull(trustStorePassword));
    }

    public static SslConfiguration forTrustStore(Resource trustStore, @Nullable char[] trustStorePassword) {
        Assert.notNull((Object)trustStore, (String)"TrustStore must not be null");
        Assert.isTrue((boolean)trustStore.exists(), () -> String.format("TrustStore %s does not exist", trustStore));
        return new SslConfiguration(KeyStoreConfiguration.UNCONFIGURED, new KeyStoreConfiguration(trustStore, trustStorePassword, DEFAULT_KEYSTORE_TYPE));
    }

    @Deprecated
    public static SslConfiguration forKeyStore(Resource keyStore, @Nullable String keyStorePassword) {
        return SslConfiguration.forKeyStore(keyStore, SslConfiguration.charsOrNull(keyStorePassword));
    }

    public static SslConfiguration forKeyStore(@Nullable Resource keyStore, @Nullable char[] keyStorePassword) {
        Assert.notNull((Object)keyStore, (String)"KeyStore must not be null");
        Assert.isTrue((boolean)keyStore.exists(), () -> String.format("KeyStore %s does not exist", keyStore));
        return new SslConfiguration(new KeyStoreConfiguration(keyStore, keyStorePassword, DEFAULT_KEYSTORE_TYPE), KeyStoreConfiguration.UNCONFIGURED);
    }

    @Deprecated
    public SslConfiguration create(Resource keyStore, @Nullable String keyStorePassword, Resource trustStore, @Nullable String trustStorePassword) {
        return this.create(keyStore, SslConfiguration.charsOrNull(keyStorePassword), trustStore, SslConfiguration.charsOrNull(trustStorePassword));
    }

    public SslConfiguration create(Resource keyStore, @Nullable char[] keyStorePassword, Resource trustStore, @Nullable char[] trustStorePassword) {
        Assert.notNull((Object)keyStore, (String)"KeyStore must not be null");
        Assert.isTrue((boolean)keyStore.exists(), () -> String.format("KeyStore %s does not exist", trustStore));
        Assert.notNull((Object)trustStore, (String)"TrustStore must not be null");
        Assert.isTrue((boolean)trustStore.exists(), (String)String.format("TrustStore %s does not exist", trustStore));
        return new SslConfiguration(new KeyStoreConfiguration(keyStore, keyStorePassword, DEFAULT_KEYSTORE_TYPE), new KeyStoreConfiguration(trustStore, trustStorePassword, DEFAULT_KEYSTORE_TYPE));
    }

    public static SslConfiguration unconfigured() {
        return new SslConfiguration(KeyStoreConfiguration.unconfigured(), KeyStoreConfiguration.unconfigured());
    }

    public Resource getKeyStore() {
        return this.keyStoreConfiguration.getResource();
    }

    @Deprecated
    @Nullable
    public String getKeyStorePassword() {
        return SslConfiguration.stringOrNull(this.keyStoreConfiguration.getStorePassword());
    }

    public KeyStoreConfiguration getKeyStoreConfiguration() {
        return this.keyStoreConfiguration;
    }

    public SslConfiguration withKeyStore(KeyStoreConfiguration configuration) {
        return new SslConfiguration(configuration, this.trustStoreConfiguration);
    }

    public Resource getTrustStore() {
        return this.trustStoreConfiguration.getResource();
    }

    @Deprecated
    @Nullable
    public String getTrustStorePassword() {
        return SslConfiguration.stringOrNull(this.trustStoreConfiguration.getStorePassword());
    }

    public KeyStoreConfiguration getTrustStoreConfiguration() {
        return this.trustStoreConfiguration;
    }

    public SslConfiguration withTrustStore(KeyStoreConfiguration configuration) {
        return new SslConfiguration(this.keyStoreConfiguration, configuration);
    }

    @Nullable
    private static String stringOrNull(@Nullable char[] storePassword) {
        return storePassword != null ? new String(storePassword) : null;
    }

    @Nullable
    private static char[] charsOrNull(@Nullable String trustStorePassword) {
        return trustStorePassword != null ? trustStorePassword.toCharArray() : null;
    }

    static class AbsentResource
    extends AbstractResource {
        static final AbsentResource INSTANCE = new AbsentResource();

        private AbsentResource() {
        }

        public String getDescription() {
            return ((Object)((Object)this)).getClass().getSimpleName();
        }

        public InputStream getInputStream() throws IOException {
            throw new UnsupportedOperationException("Empty resource");
        }
    }

    public static class KeyStoreConfiguration {
        private static final KeyStoreConfiguration UNCONFIGURED = new KeyStoreConfiguration((Resource)AbsentResource.INSTANCE, null, SslConfiguration.access$100());
        private final Resource resource;
        @Nullable
        private final char[] storePassword;
        private final String storeType;

        public KeyStoreConfiguration(Resource resource, @Nullable char[] storePassword, String storeType) {
            Assert.notNull((Object)resource, (String)"Resource must not be null");
            Assert.isTrue((resource instanceof AbsentResource || resource.exists() ? 1 : 0) != 0, () -> String.format("Resource %s does not exist", resource));
            Assert.notNull((Object)storeType, (String)"Keystore type must not be null");
            this.resource = resource;
            this.storeType = storeType;
            this.storePassword = (char[])(storePassword == null ? null : Arrays.copyOf(storePassword, storePassword.length));
        }

        public static KeyStoreConfiguration of(Resource resource) {
            return new KeyStoreConfiguration(resource, null, DEFAULT_KEYSTORE_TYPE);
        }

        public static KeyStoreConfiguration of(Resource resource, char[] storePassword) {
            return new KeyStoreConfiguration(resource, storePassword, DEFAULT_KEYSTORE_TYPE);
        }

        public static KeyStoreConfiguration unconfigured() {
            return UNCONFIGURED;
        }

        public boolean isPresent() {
            return !(this.resource instanceof AbsentResource);
        }

        public Resource getResource() {
            return this.resource;
        }

        @Nullable
        public char[] getStorePassword() {
            return this.storePassword;
        }

        public String getStoreType() {
            return this.storeType;
        }
    }
}

