/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.core;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.vault.VaultException;
import org.springframework.vault.authentication.VaultTokenSupplier;
import org.springframework.vault.client.ReactiveVaultClients;
import org.springframework.vault.client.SimpleVaultEndpointProvider;
import org.springframework.vault.client.VaultEndpoint;
import org.springframework.vault.client.VaultEndpointProvider;
import org.springframework.vault.client.VaultResponses;
import org.springframework.vault.core.ReactiveVaultOperations;
import org.springframework.vault.support.VaultResponse;
import org.springframework.vault.support.VaultResponseSupport;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.reactive.function.BodyExtractors;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveVaultTemplate
implements ReactiveVaultOperations {
    private final WebClient statelessClient;
    private final WebClient sessionClient;
    private final VaultTokenSupplier vaultTokenSupplier;

    public ReactiveVaultTemplate(VaultEndpoint vaultEndpoint, ClientHttpConnector connector, VaultTokenSupplier vaultTokenSupplier) {
        this(SimpleVaultEndpointProvider.of(vaultEndpoint), connector, vaultTokenSupplier);
    }

    public ReactiveVaultTemplate(VaultEndpointProvider endpointProvider, ClientHttpConnector connector, VaultTokenSupplier vaultTokenSupplier) {
        Assert.notNull((Object)endpointProvider, (String)"VaultEndpointProvider must not be null");
        Assert.notNull((Object)connector, (String)"ClientHttpConnector must not be null");
        Assert.notNull((Object)vaultTokenSupplier, (String)"AuthenticationSupplier must not be null");
        this.vaultTokenSupplier = vaultTokenSupplier;
        this.statelessClient = this.doCreateWebClient(endpointProvider, connector);
        this.sessionClient = this.doCreateSessionWebClient(endpointProvider, connector);
    }

    protected WebClient doCreateWebClient(VaultEndpointProvider endpointProvider, ClientHttpConnector connector) {
        Assert.notNull((Object)endpointProvider, (String)"VaultEndpointProvider must not be null");
        Assert.notNull((Object)connector, (String)"ClientHttpConnector must not be null");
        return ReactiveVaultClients.createWebClient(endpointProvider, connector);
    }

    protected WebClient doCreateSessionWebClient(VaultEndpointProvider endpointProvider, ClientHttpConnector connector) {
        Assert.notNull((Object)endpointProvider, (String)"VaultEndpointProvider must not be null");
        Assert.notNull((Object)connector, (String)"ClientHttpConnector must not be null");
        ExchangeFilterFunction filter = ExchangeFilterFunction.ofRequestProcessor(request -> this.vaultTokenSupplier.getVaultToken().map(token -> ClientRequest.from((ClientRequest)request).headers(headers -> headers.set("X-Vault-Token", token.getToken())).build()));
        return this.doCreateWebClient(endpointProvider, connector).mutate().filter(filter).build();
    }

    @Override
    public Mono<VaultResponse> read(String path) {
        Assert.hasText((String)path, (String)"Path must not be empty");
        return this.doRead(path, VaultResponse.class);
    }

    @Override
    public <T> Mono<VaultResponseSupport<T>> read(String path, Class<T> responseType) {
        return this.doWithSession(webClient -> {
            ParameterizedTypeReference ref = VaultResponses.getTypeReference(responseType);
            return webClient.get().uri(path, new Object[0]).exchange().flatMap(ReactiveVaultTemplate.mapResponse(ref, path));
        });
    }

    @Override
    public Flux<String> list(String path) {
        Assert.hasText((String)path, (String)"Path must not be empty");
        Mono<VaultListResponse> read = this.doRead(String.format("%s?list=true", path.endsWith("/") ? path : path + "/"), VaultListResponse.class);
        return read.filter(response -> response.getData() != null && ((Map)response.getData()).containsKey("keys")).flatMapIterable(response -> (List)((Map)response.getRequiredData()).get("keys"));
    }

    @Override
    public Mono<VaultResponse> write(String path, @Nullable Object body) {
        Assert.hasText((String)path, (String)"Path must not be empty");
        return this.doWithSession(webClient -> {
            WebClient.RequestBodySpec uri = (WebClient.RequestBodySpec)webClient.post().uri(path, new Object[0]);
            Mono exchange = body != null ? uri.syncBody(body).exchange() : uri.exchange();
            return exchange.flatMap(ReactiveVaultTemplate.mapResponse(VaultResponse.class, path));
        });
    }

    @Override
    public Mono<Void> delete(String path) {
        Assert.hasText((String)path, (String)"Path must not be empty");
        return this.doWithSession(webClient -> webClient.delete().uri(path, new Object[0]).exchange().flatMap(ReactiveVaultTemplate.mapResponse(String.class, path)).then());
    }

    @Override
    public <V, T extends Publisher<V>> T doWithVault(Function<WebClient, ? extends T> clientCallback) throws VaultException, WebClientException {
        Assert.notNull(clientCallback, (String)"Client callback must not be null");
        try {
            return (T)((Publisher)clientCallback.apply(this.statelessClient));
        }
        catch (HttpStatusCodeException e) {
            throw VaultResponses.buildException(e);
        }
    }

    @Override
    public <V, T extends Publisher<V>> T doWithSession(Function<WebClient, ? extends T> sessionCallback) throws VaultException, WebClientException {
        Assert.notNull(sessionCallback, (String)"Session callback must not be null");
        try {
            return (T)((Publisher)sessionCallback.apply(this.sessionClient));
        }
        catch (HttpStatusCodeException e) {
            throw VaultResponses.buildException(e);
        }
    }

    private <T> Mono<T> doRead(String path, Class<T> responseType) {
        return this.doWithSession(client -> client.get().uri(path, new Object[0]).exchange().flatMap(ReactiveVaultTemplate.mapResponse(responseType, path)));
    }

    private static <T> Function<ClientResponse, Mono<? extends T>> mapResponse(Class<T> bodyType, String path) {
        return response -> ReactiveVaultTemplate.isSuccess(response) ? response.bodyToMono(bodyType) : ReactiveVaultTemplate.mapOtherwise(response, path);
    }

    private static <T> Function<ClientResponse, Mono<? extends T>> mapResponse(ParameterizedTypeReference<T> typeReference, String path) {
        return response -> ReactiveVaultTemplate.isSuccess(response) ? (Mono)response.body(BodyExtractors.toMono((ParameterizedTypeReference)typeReference)) : ReactiveVaultTemplate.mapOtherwise(response, path);
    }

    private static boolean isSuccess(ClientResponse response) {
        return response.statusCode().is2xxSuccessful();
    }

    private static <T> Mono<? extends T> mapOtherwise(ClientResponse response, String path) {
        if (response.statusCode() == HttpStatus.NOT_FOUND) {
            return Mono.empty();
        }
        return response.bodyToMono(String.class).flatMap(body -> {
            String error = VaultResponses.getError(body);
            return Mono.error((Throwable)((Object)VaultResponses.buildException(response.statusCode(), path, error)));
        });
    }

    private static class VaultListResponse
    extends VaultResponseSupport<Map<String, Object>> {
        private VaultListResponse() {
        }
    }
}

