/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.repository.mapping;

import org.springframework.data.keyvalue.core.mapping.BasicKeyValuePersistentEntity;
import org.springframework.data.keyvalue.core.mapping.KeySpaceResolver;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.StringUtils;
import org.springframework.vault.repository.mapping.Secret;
import org.springframework.vault.repository.mapping.VaultPersistentEntity;
import org.springframework.vault.repository.mapping.VaultPersistentProperty;

public class BasicVaultPersistentEntity<T>
extends BasicKeyValuePersistentEntity<T, VaultPersistentProperty>
implements VaultPersistentEntity<T> {
    private final String keyspace;
    private final String secretBackend;

    public BasicVaultPersistentEntity(TypeInformation<T> information, KeySpaceResolver fallbackKeySpaceResolver) {
        super(information, fallbackKeySpaceResolver);
        Secret annotation = (Secret)this.findAnnotation(Secret.class);
        String keyspace = super.getKeySpace();
        String secretBackend = "secret";
        if (annotation != null && StringUtils.hasText((String)annotation.backend())) {
            secretBackend = annotation.backend();
        }
        this.secretBackend = secretBackend;
        this.keyspace = String.format("%s/%s", secretBackend, keyspace);
    }

    public String getKeySpace() {
        return this.keyspace;
    }

    @Override
    public String getSecretBackend() {
        return this.secretBackend;
    }
}

