/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.core;

import java.util.Base64;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.Assert;
import org.springframework.vault.core.ReactiveVaultOperations;
import org.springframework.vault.core.ReactiveVaultTransitOperations;
import org.springframework.vault.core.VaultTransitTemplate;
import org.springframework.vault.support.Ciphertext;
import org.springframework.vault.support.Hmac;
import org.springframework.vault.support.Plaintext;
import org.springframework.vault.support.RawTransitKey;
import org.springframework.vault.support.Signature;
import org.springframework.vault.support.SignatureValidation;
import org.springframework.vault.support.TransitKeyType;
import org.springframework.vault.support.VaultDecryptionResult;
import org.springframework.vault.support.VaultEncryptionResult;
import org.springframework.vault.support.VaultHmacRequest;
import org.springframework.vault.support.VaultResponseSupport;
import org.springframework.vault.support.VaultSignRequest;
import org.springframework.vault.support.VaultSignatureVerificationRequest;
import org.springframework.vault.support.VaultTransitContext;
import org.springframework.vault.support.VaultTransitKey;
import org.springframework.vault.support.VaultTransitKeyConfiguration;
import org.springframework.vault.support.VaultTransitKeyCreationRequest;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveVaultTransitTemplate
implements ReactiveVaultTransitOperations {
    private final ReactiveVaultOperations reactiveVaultOperations;
    private final String path;

    public ReactiveVaultTransitTemplate(ReactiveVaultOperations reactiveVaultOperations, String path) {
        Assert.notNull((Object)reactiveVaultOperations, (String)"ReactiveVaultOperations must not be null");
        Assert.hasText((String)path, (String)"Path must not be empty");
        this.reactiveVaultOperations = reactiveVaultOperations;
        this.path = path;
    }

    @Override
    public Mono<Void> createKey(String keyName) {
        Assert.hasText((String)keyName, (String)"Key name must not be empty");
        return this.reactiveVaultOperations.write(String.format("%s/keys/%s", this.path, keyName), null).then();
    }

    @Override
    public Mono<Void> createKey(String keyName, VaultTransitKeyCreationRequest createKeyRequest) {
        Assert.hasText((String)keyName, (String)"Key name must not be empty");
        Assert.notNull((Object)createKeyRequest, (String)"VaultTransitKeyCreationRequest must not be empty");
        return this.reactiveVaultOperations.write(String.format("%s/keys/%s", this.path, keyName), createKeyRequest).then();
    }

    @Override
    public Mono<Void> rotate(String keyName) {
        Assert.hasText((String)keyName, (String)"Key name must not be empty");
        return this.reactiveVaultOperations.write(String.format("%s/keys/%s/rotate", this.path, keyName), null).then();
    }

    @Override
    public Mono<String> encrypt(String keyName, String plaintext) {
        Assert.hasText((String)keyName, (String)"Key name must not be empty");
        Assert.notNull((Object)plaintext, (String)"Plaintext must not be null");
        LinkedHashMap<String, String> request = new LinkedHashMap<String, String>();
        request.put("plaintext", Base64.getEncoder().encodeToString(plaintext.getBytes()));
        return this.reactiveVaultOperations.write(String.format("%s/encrypt/%s", this.path, keyName), request).map(it -> (String)((Map)it.getRequiredData()).get("ciphertext"));
    }

    @Override
    public Mono<Void> configureKey(String keyName, VaultTransitKeyConfiguration keyConfiguration) {
        Assert.hasText((String)keyName, (String)"Key name must not be empty");
        Assert.notNull((Object)keyConfiguration, (String)"VaultKeyConfiguration must not be empty");
        return this.reactiveVaultOperations.write(String.format("%s/keys/%s/config", this.path, keyName), keyConfiguration).then();
    }

    @Override
    public Mono<Void> deleteKey(String keyName) {
        Assert.hasText((String)keyName, (String)"Key name must not be empty");
        return this.reactiveVaultOperations.delete(String.format("%s/keys/%s", this.path, keyName));
    }

    @Override
    public Flux<String> getKeys() {
        return this.reactiveVaultOperations.read(String.format("%s/keys?list=true", this.path)).flatMapIterable(it -> (List)((Map)it.getRequiredData()).get("keys"));
    }

    @Override
    public Mono<String> encrypt(String keyName, byte[] plaintext, VaultTransitContext transitContext) {
        Assert.notNull((Object)plaintext, (String)"Plaintext must not be null");
        Assert.hasText((String)keyName, (String)"Key name must not be empty");
        Assert.notNull((Object)transitContext, (String)"VaultTransitContext must not be null");
        LinkedHashMap<String, String> request = new LinkedHashMap<String, String>();
        request.put("plaintext", Base64.getEncoder().encodeToString(plaintext));
        VaultTransitTemplate.applyTransitOptions(transitContext, request);
        return this.reactiveVaultOperations.write(String.format("%s/encrypt/%s", this.path, keyName), request).map(it -> (String)((Map)it.getRequiredData()).get("ciphertext"));
    }

    @Override
    public Mono<Ciphertext> encrypt(String keyName, Plaintext plaintext) {
        Assert.hasText((String)keyName, (String)"Key name must not be empty");
        Assert.notNull((Object)plaintext, (String)"Plaintext must not be null");
        return this.encrypt(keyName, plaintext.getPlaintext(), plaintext.getContext()).map(ciphertext -> VaultTransitTemplate.toCiphertext(ciphertext, plaintext.getContext()));
    }

    @Override
    public Mono<String> decrypt(String keyName, String ciphertext) {
        Assert.hasText((String)keyName, (String)"Key name must not be empty");
        Assert.hasText((String)ciphertext, (String)"Ciphertext must not be empty");
        LinkedHashMap<String, String> request = new LinkedHashMap<String, String>();
        request.put("ciphertext", ciphertext);
        return this.reactiveVaultOperations.write(String.format("%s/decrypt/%s", this.path, keyName), request).map(it -> (String)((Map)it.getRequiredData()).get("plaintext")).map(plaintext -> new String(Base64.getDecoder().decode((String)plaintext)));
    }

    @Override
    public Mono<Plaintext> decrypt(String keyName, Ciphertext ciphertext) {
        Assert.hasText((String)keyName, (String)"Key name must not be null");
        Assert.notNull((Object)ciphertext, (String)"Ciphertext must not be null");
        return this.decrypt(keyName, ciphertext.getCiphertext(), ciphertext.getContext()).map(plaintext -> Plaintext.of(plaintext).with(ciphertext.getContext()));
    }

    @Override
    public Mono<byte[]> decrypt(String keyName, String ciphertext, VaultTransitContext transitContext) {
        Assert.hasText((String)keyName, (String)"Key name must not be empty");
        Assert.hasText((String)ciphertext, (String)"Ciphertext must not be empty");
        Assert.notNull((Object)transitContext, (String)"VaultTransitContext must not be null");
        LinkedHashMap<String, String> request = new LinkedHashMap<String, String>();
        request.put("ciphertext", ciphertext);
        VaultTransitTemplate.applyTransitOptions(transitContext, request);
        return this.reactiveVaultOperations.write(String.format("%s/decrypt/%s", this.path, keyName), request).map(it -> (String)((Map)it.getRequiredData()).get("plaintext")).map(Base64.getDecoder()::decode);
    }

    @Override
    public Mono<String> rewrap(String keyName, String ciphertext) {
        Assert.hasText((String)keyName, (String)"Key name must not be empty");
        Assert.hasText((String)ciphertext, (String)"Ciphertext must not be empty");
        LinkedHashMap<String, String> request = new LinkedHashMap<String, String>();
        request.put("ciphertext", ciphertext);
        return this.reactiveVaultOperations.write(String.format("%s/rewrap/%s", this.path, keyName), request).map(response -> (String)((Map)response.getRequiredData()).get("ciphertext"));
    }

    @Override
    public Mono<String> rewrap(String keyName, String ciphertext, VaultTransitContext transitContext) {
        Assert.hasText((String)keyName, (String)"Key name must not be empty");
        Assert.hasText((String)ciphertext, (String)"Ciphertext must not be empty");
        Assert.notNull((Object)transitContext, (String)"VaultTransitContext must not be null");
        LinkedHashMap<String, String> request = new LinkedHashMap<String, String>();
        request.put("ciphertext", ciphertext);
        VaultTransitTemplate.applyTransitOptions(transitContext, request);
        return this.reactiveVaultOperations.write(String.format("%s/rewrap/%s", this.path, keyName), request).map(response -> (String)((Map)response.getRequiredData()).get("ciphertext"));
    }

    @Override
    public Flux<VaultEncryptionResult> encrypt(String keyName, List<Plaintext> batchRequest) {
        Assert.hasText((String)keyName, (String)"Key name must not be empty");
        Assert.notEmpty(batchRequest, (String)"BatchRequest must not be null and must have at least one entry");
        return Flux.fromIterable(batchRequest).map(request -> {
            LinkedHashMap<String, String> vaultRequest = new LinkedHashMap<String, String>(2);
            vaultRequest.put("plaintext", Base64.getEncoder().encodeToString(request.getPlaintext()));
            VaultTransitTemplate.applyTransitOptions(request.getContext(), vaultRequest);
            return vaultRequest;
        }).collectList().flatMap(batch -> this.reactiveVaultOperations.write(String.format("%s/encrypt/%s", this.path, keyName), Collections.singletonMap("batch_input", batch))).flatMapIterable(vaultResponse -> VaultTransitTemplate.toEncryptionResults(vaultResponse, batchRequest));
    }

    @Override
    public Flux<VaultDecryptionResult> decrypt(String keyName, List<Ciphertext> batchRequest) {
        Assert.hasText((String)keyName, (String)"Key name must not be empty");
        Assert.notEmpty(batchRequest, (String)"BatchRequest must not be null and must have at least one entry");
        return Flux.fromIterable(batchRequest).map(request -> {
            LinkedHashMap<String, String> vaultRequest = new LinkedHashMap<String, String>(2);
            vaultRequest.put("ciphertext", request.getCiphertext());
            VaultTransitTemplate.applyTransitOptions(request.getContext(), vaultRequest);
            return vaultRequest;
        }).collectList().flatMap(batch -> this.reactiveVaultOperations.write(String.format("%s/decrypt/%s", this.path, keyName), Collections.singletonMap("batch_input", batch))).flatMapIterable(vaultResponse -> VaultTransitTemplate.toDecryptionResults(vaultResponse, batchRequest));
    }

    @Override
    public Mono<Hmac> getHmac(String keyName, Plaintext plaintext) {
        Assert.hasText((String)keyName, (String)"Key name must not be empty");
        Assert.notNull((Object)plaintext, (String)"Plaintext must not be null");
        VaultHmacRequest request = VaultHmacRequest.create(plaintext);
        return this.getHmac(keyName, request);
    }

    @Override
    public Mono<Hmac> getHmac(String keyName, VaultHmacRequest hmacRequest) {
        Assert.hasText((String)keyName, (String)"Key name must not be empty");
        Assert.notNull((Object)hmacRequest, (String)"HMAC request must not be null");
        return this.reactiveVaultOperations.write(String.format("%s/hmac/%s", this.path, keyName), VaultTransitTemplate.toRequestBody(hmacRequest)).map(vaultResponse -> (String)((Map)vaultResponse.getRequiredData()).get("hmac")).map(Hmac::of);
    }

    @Override
    public Mono<Signature> sign(String keyName, Plaintext plaintext) {
        Assert.hasText((String)keyName, (String)"Key name must not be empty");
        Assert.notNull((Object)plaintext, (String)"Plaintext must not be null");
        VaultSignRequest request = VaultSignRequest.create(plaintext);
        return this.sign(keyName, request);
    }

    @Override
    public Mono<Signature> sign(String keyName, VaultSignRequest signRequest) {
        Assert.hasText((String)keyName, (String)"Key name must not be empty");
        Assert.notNull((Object)signRequest, (String)"Sign request must not be null");
        return this.reactiveVaultOperations.write(String.format("%s/sign/%s", this.path, keyName), VaultTransitTemplate.toRequestBody(signRequest)).map(vaultResponse -> (String)((Map)vaultResponse.getRequiredData()).get("signature")).map(Signature::of);
    }

    @Override
    public Mono<Boolean> verify(String keyName, Plaintext plaintext, Signature signature) {
        Assert.hasText((String)keyName, (String)"Key name must not be empty");
        Assert.notNull((Object)plaintext, (String)"Plaintext must not be null");
        Assert.notNull((Object)signature, (String)"Signature must not be null");
        VaultSignatureVerificationRequest request = VaultSignatureVerificationRequest.create(plaintext, signature);
        return this.verify(keyName, request).map(SignatureValidation::isValid);
    }

    @Override
    public Mono<SignatureValidation> verify(String keyName, VaultSignatureVerificationRequest verificationRequest) {
        Assert.hasText((String)keyName, (String)"Key name must not be empty");
        Assert.notNull((Object)verificationRequest, (String)"Signature verification request must not be null");
        return this.reactiveVaultOperations.write(String.format("%s/verify/%s", this.path, keyName), VaultTransitTemplate.toRequestBody(verificationRequest)).map(VaultResponseSupport::getRequiredData).map(vaultResponse -> {
            if (vaultResponse.containsKey("valid") && ((Boolean)vaultResponse.get("valid")).booleanValue()) {
                return SignatureValidation.valid();
            }
            return SignatureValidation.invalid();
        });
    }

    @Override
    public Mono<RawTransitKey> exportKey(String keyName, TransitKeyType type) {
        Assert.hasText((String)keyName, (String)"Key name must not be empty");
        Assert.notNull((Object)((Object)type), (String)"Key type must not be null");
        return this.reactiveVaultOperations.read(String.format("%s/export/%s/%s", this.path, type.getValue(), keyName), VaultTransitTemplate.RawTransitKeyImpl.class).flatMap(vaultResponse -> Mono.justOrEmpty((Object)((VaultTransitTemplate.RawTransitKeyImpl)vaultResponse.getRequiredData())));
    }

    @Override
    public Mono<VaultTransitKey> getKey(String keyName) {
        Assert.hasText((String)keyName, (String)"Key name must not be empty");
        return this.reactiveVaultOperations.read(String.format("%s/keys/%s", this.path, keyName), VaultTransitTemplate.VaultTransitKeyImpl.class).map(VaultResponseSupport::getRequiredData);
    }
}

