/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.bean.deploy;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.enterprise.inject.spi.BeanManager;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.switchyard.component.bean.BeanMessages;
import org.switchyard.component.bean.ClientProxyBean;
import org.switchyard.component.bean.deploy.BeanDeploymentMetaDataCDIBean;
import org.switchyard.component.bean.deploy.CDIBean;
import org.switchyard.component.bean.deploy.ServiceDescriptor;
import org.switchyard.component.bean.internal.ReferenceInvokerBean;

public class BeanDeploymentMetaData {
    private BeanManager _beanManager;
    private ClassLoader _deploymentClassLoader;
    private List<ServiceDescriptor> _serviceDescriptors = new ArrayList<ServiceDescriptor>();
    private List<ClientProxyBean> _clientProxies = new ArrayList<ClientProxyBean>();
    private List<ReferenceInvokerBean> _referenceInvokers = new ArrayList<ReferenceInvokerBean>();
    private List<CDIBean> _deploymentBeans = new ArrayList<CDIBean>();

    public BeanDeploymentMetaData setBeanManager(BeanManager beanManager) {
        this._beanManager = beanManager;
        return this;
    }

    public BeanManager getBeanManager() {
        return this._beanManager;
    }

    public BeanDeploymentMetaData setDeploymentClassLoader(ClassLoader deploymentClassLoader) {
        this._deploymentClassLoader = deploymentClassLoader;
        return this;
    }

    public ClassLoader getDeploymentClassLoader() {
        return this._deploymentClassLoader;
    }

    public void addServiceDescriptor(ServiceDescriptor serviceDescriptor) {
        this._serviceDescriptors.add(serviceDescriptor);
    }

    public void addClientProxy(ClientProxyBean proxy) {
        this._clientProxies.add(proxy);
    }

    public void addReferenceInvoker(ReferenceInvokerBean invoker) {
        this._referenceInvokers.add(invoker);
    }

    public void addDeploymentBean(CDIBean bean) {
        this._deploymentBeans.add(bean);
    }

    public List<ServiceDescriptor> getServiceDescriptors() {
        return Collections.unmodifiableList(this._serviceDescriptors);
    }

    public List<ClientProxyBean> getClientProxies() {
        return Collections.unmodifiableList(this._clientProxies);
    }

    public List<ReferenceInvokerBean> getReferenceInvokers() {
        return Collections.unmodifiableList(this._referenceInvokers);
    }

    public List<CDIBean> getDeploymentBeans() {
        return Collections.unmodifiableList(this._deploymentBeans);
    }

    public static BeanDeploymentMetaData lookupBeanDeploymentMetaData() {
        try {
            BeanManager beanManager = BeanDeploymentMetaData.getCDIBeanManager();
            Set beans = beanManager.getBeans(BeanDeploymentMetaData.class, new Annotation[0]);
            if (beans.isEmpty()) {
                throw BeanMessages.MESSAGES.failedToLookupBeanDeploymentMetaDataFromBeanManagerMustBeBoundIntoBeanManagerPerhapsSwitchYardCDIExtensionsNotProperlyInstalledInContainer();
            }
            if (beans.size() > 1) {
                throw BeanMessages.MESSAGES.failedToLookupBeanDeploymentMetaDataFromBeanManagerMultipleBeansResolvedForType(BeanDeploymentMetaData.class.getName());
            }
            BeanDeploymentMetaDataCDIBean bean = (BeanDeploymentMetaDataCDIBean)beans.iterator().next();
            return bean.getBeanMetaData();
        }
        catch (NamingException e) {
            throw BeanMessages.MESSAGES.failedToLookupBeanManagerMustBeBoundIntoJavaCompAsPerCDISpecification(e);
        }
    }

    public static BeanManager getCDIBeanManager() throws NamingException {
        BeanManager beanManager = BeanDeploymentMetaData.getCDIBeanManager("java:comp");
        if (beanManager == null && (beanManager = BeanDeploymentMetaData.getCDIBeanManager("java:comp/env")) == null) {
            throw BeanMessages.MESSAGES.nameBeanManagerIsNotBoundInThisContext();
        }
        return beanManager;
    }

    private static BeanManager getCDIBeanManager(String jndiLocation) {
        Context javaComp = BeanDeploymentMetaData.getJavaComp(jndiLocation);
        if (javaComp != null) {
            try {
                return (BeanManager)javaComp.lookup("BeanManager");
            }
            catch (NamingException e) {
                return null;
            }
        }
        return null;
    }

    private static Context getJavaComp(String jndiName) {
        InitialContext initialContext = null;
        try {
            initialContext = new InitialContext();
            Context context = (Context)initialContext.lookup(jndiName);
            return context;
        }
        catch (NamingException e) {
            Context context = null;
            return context;
        }
        catch (Exception e) {
            throw BeanMessages.MESSAGES.unexpectedExceptionRetrieving(jndiName, e);
        }
        finally {
            if (initialContext != null) {
                try {
                    initialContext.close();
                }
                catch (NamingException e) {
                    throw BeanMessages.MESSAGES.unexpectedErrorClosingInitialContext(e);
                }
            }
        }
    }
}

