/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.bean.internal;

import java.lang.annotation.Annotation;
import java.util.Set;
import org.switchyard.Exchange;
import org.switchyard.ExchangeHandler;
import org.switchyard.ServiceReference;
import org.switchyard.component.bean.ReferenceInvocation;
import org.switchyard.component.bean.ReferenceInvoker;
import org.switchyard.component.bean.internal.ExchangeInvocation;
import org.switchyard.component.bean.internal.InternalBean;
import org.switchyard.component.bean.internal.InvocationResponseHandler;
import org.switchyard.metadata.ServiceInterface;
import org.switchyard.metadata.ServiceOperation;

public class ReferenceInvokerBean
extends InternalBean
implements ReferenceInvoker {
    private final String _serviceName;
    private ServiceReference _reference;

    public ReferenceInvokerBean(String serviceName, Set<Annotation> qualifiers) {
        super(ReferenceInvoker.class, qualifiers);
        this.setProxyObject(this);
        this._serviceName = serviceName;
    }

    public String getServiceName() {
        return this._serviceName;
    }

    public void setReference(ServiceReference reference) {
        this._reference = reference;
    }

    public ServiceReference getReference() {
        return this._reference;
    }

    @Override
    public ReferenceInvocation newInvocation() {
        this.assertReference();
        ServiceInterface intf = this._reference.getInterface();
        if (intf.getOperations().size() != 1) {
            throw new IllegalStateException("Operation name is required to create ReferenceInvocation for " + this._serviceName);
        }
        return this.newInvocation(((ServiceOperation)intf.getOperations().iterator().next()).getName());
    }

    @Override
    public ReferenceInvocation newInvocation(String operation) {
        this.assertReference();
        InvocationResponseHandler handler = new InvocationResponseHandler();
        Exchange exchange = this._reference.createExchange(operation, (ExchangeHandler)handler);
        return new ExchangeInvocation(exchange, handler);
    }

    @Override
    public ServiceInterface getContract() {
        return this._reference.getInterface();
    }

    private void assertReference() throws IllegalStateException {
        if (this._reference == null) {
            throw new IllegalStateException("Reference does not exist for service: " + this._serviceName);
        }
    }
}

