/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.bean.config.model;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.switchyard.annotations.Requires;
import org.switchyard.common.type.classpath.AbstractTypeFilter;
import org.switchyard.common.type.classpath.ClasspathScanner;
import org.switchyard.common.type.classpath.CompositeFilter;
import org.switchyard.common.type.classpath.Filter;
import org.switchyard.common.type.classpath.IsAnnotationPresentFilter;
import org.switchyard.common.type.classpath.PackageFilter;
import org.switchyard.component.bean.BeanMessages;
import org.switchyard.component.bean.Reference;
import org.switchyard.component.bean.Service;
import org.switchyard.component.bean.config.model.BeanNamespace;
import org.switchyard.component.bean.config.model.v1.V1BeanComponentImplementationModel;
import org.switchyard.config.model.Model;
import org.switchyard.config.model.Namespace;
import org.switchyard.config.model.Scanner;
import org.switchyard.config.model.ScannerInput;
import org.switchyard.config.model.ScannerOutput;
import org.switchyard.config.model.composite.ComponentImplementationModel;
import org.switchyard.config.model.composite.ComponentModel;
import org.switchyard.config.model.composite.ComponentReferenceModel;
import org.switchyard.config.model.composite.ComponentServiceModel;
import org.switchyard.config.model.composite.CompositeModel;
import org.switchyard.config.model.composite.InterfaceModel;
import org.switchyard.config.model.composite.v1.V1ComponentModel;
import org.switchyard.config.model.composite.v1.V1ComponentReferenceModel;
import org.switchyard.config.model.composite.v1.V1ComponentServiceModel;
import org.switchyard.config.model.composite.v1.V1CompositeModel;
import org.switchyard.config.model.composite.v1.V1InterfaceModel;
import org.switchyard.config.model.switchyard.SwitchYardModel;
import org.switchyard.config.model.switchyard.SwitchYardNamespace;
import org.switchyard.config.model.switchyard.v1.V1SwitchYardModel;
import org.switchyard.policy.Policy;
import org.switchyard.policy.SecurityPolicy;
import org.switchyard.policy.TransactionPolicy;

public class BeanSwitchYardScanner
implements Scanner<SwitchYardModel> {
    public ScannerOutput<SwitchYardModel> scan(ScannerInput<SwitchYardModel> input) throws IOException {
        SwitchYardNamespace switchyardNamespace = input.getSwitchyardNamespace();
        V1SwitchYardModel switchyardModel = new V1SwitchYardModel(switchyardNamespace.uri());
        V1CompositeModel compositeModel = new V1CompositeModel();
        compositeModel.setName(input.getCompositeName());
        BeanNamespace beanNamespace = BeanNamespace.DEFAULT;
        for (BeanNamespace value : BeanNamespace.values()) {
            if (!value.versionMatches((Namespace)switchyardNamespace)) continue;
            beanNamespace = value;
            break;
        }
        List<Class<?>> serviceClasses = this.scanForServiceBeans(input);
        for (Class<?> serviceClass : serviceClasses) {
            Requires requires;
            if (serviceClass.isInterface() || Modifier.isAbstract(serviceClass.getModifiers())) continue;
            V1ComponentModel componentModel = new V1ComponentModel();
            V1ComponentServiceModel serviceModel = new V1ComponentServiceModel(switchyardNamespace.uri());
            String name = serviceClass.getSimpleName();
            V1BeanComponentImplementationModel beanModel = new V1BeanComponentImplementationModel(beanNamespace.uri());
            beanModel.setClazz(serviceClass.getName());
            componentModel.setImplementation((ComponentImplementationModel)beanModel);
            Service service = serviceClass.getAnnotation(Service.class);
            if (service != null) {
                Class<?> iface = service.value();
                if (iface == Service.class) {
                    Class<?>[] interfaces = serviceClass.getInterfaces();
                    if (interfaces.length == 1) {
                        iface = interfaces[0];
                    } else {
                        throw BeanMessages.MESSAGES.unexpectedExceptionTheServiceAnnotationHasNoValueItCannotBeOmmittedUnlessTheBeanImplementsExactlyOneInterface();
                    }
                }
                V1InterfaceModel csiModel = new V1InterfaceModel("java");
                name = service.name().equals("") ? iface.getSimpleName() : service.name();
                serviceModel.setName(name);
                serviceModel.setInterface((InterfaceModel)csiModel);
                csiModel.setInterface(iface.getName());
                componentModel.addService((ComponentServiceModel)serviceModel);
            }
            if ((requires = serviceClass.getAnnotation(Requires.class)) != null) {
                for (SecurityPolicy securityPolicy : requires.security()) {
                    if (securityPolicy == SecurityPolicy.AUTHORIZATION) {
                        beanModel.addPolicyRequirement(securityPolicy.getName());
                        continue;
                    }
                    if (securityPolicy.supports(Policy.PolicyType.INTERACTION)) {
                        serviceModel.addPolicyRequirement(securityPolicy.getName());
                        continue;
                    }
                    if (securityPolicy.supports(Policy.PolicyType.IMPLEMENTATION)) {
                        beanModel.addPolicyRequirement(securityPolicy.getName());
                        continue;
                    }
                    throw BeanMessages.MESSAGES.unknownPolicy(securityPolicy.toString());
                }
                for (SecurityPolicy securityPolicy : requires.transaction()) {
                    if (securityPolicy.supports(Policy.PolicyType.INTERACTION)) {
                        serviceModel.addPolicyRequirement(securityPolicy.getName());
                        continue;
                    }
                    if (securityPolicy.supports(Policy.PolicyType.IMPLEMENTATION)) {
                        beanModel.addPolicyRequirement(securityPolicy.getName());
                        continue;
                    }
                    throw BeanMessages.MESSAGES.unknownPolicy(securityPolicy.toString());
                }
                String ptx = TransactionPolicy.PROPAGATES_TRANSACTION.getName();
                String stx = TransactionPolicy.SUSPENDS_TRANSACTION.getName();
                if (serviceModel.hasPolicyRequirement(ptx) && serviceModel.hasPolicyRequirement(stx)) {
                    throw BeanMessages.MESSAGES.transactionPoliciesCannotCoexistService(ptx, stx, name);
                }
                String gtx = TransactionPolicy.MANAGED_TRANSACTION_GLOBAL.getName();
                String string = TransactionPolicy.MANAGED_TRANSACTION_LOCAL.getName();
                String ntx = TransactionPolicy.NO_MANAGED_TRANSACTION.getName();
                if (beanModel.hasPolicyRequirement(gtx) && beanModel.hasPolicyRequirement(string) || beanModel.hasPolicyRequirement(gtx) && beanModel.hasPolicyRequirement(ntx) || beanModel.hasPolicyRequirement(string) && beanModel.hasPolicyRequirement(ntx)) {
                    throw BeanMessages.MESSAGES.transactionPoliciesCannotCoexistImplementation(gtx, string, ntx, name);
                }
            }
            for (ComponentReferenceModel reference : this.getReferences(switchyardNamespace, serviceClass, name)) {
                componentModel.addReference(reference);
            }
            compositeModel.addComponent((ComponentModel)componentModel);
            componentModel.setName(this.getComponentName(name, service));
            compositeModel.addComponent((ComponentModel)componentModel);
        }
        if (!compositeModel.getModelChildren().isEmpty()) {
            switchyardModel.setComposite((CompositeModel)compositeModel);
        }
        return new ScannerOutput().setModel((Model)switchyardModel);
    }

    private String getComponentName(String serviceName, Service service) {
        if (service == null) {
            return serviceName;
        }
        String componentName = service.componentName();
        return "".equals(componentName) ? serviceName : componentName;
    }

    private List<Class<?>> scanForServiceBeans(ScannerInput<SwitchYardModel> input) throws IOException {
        IsAnnotationPresentFilter annoFilter = new IsAnnotationPresentFilter(Service.class);
        annoFilter.addType(Reference.class);
        PackageFilter pkgFilter = new PackageFilter(input.getIncludePackages().toArray(new Package[0]));
        for (Package pkg : input.getExcludePackages()) {
            pkgFilter.addExclude(pkg);
        }
        CompositeFilter filter = new CompositeFilter(new AbstractTypeFilter[]{annoFilter, pkgFilter});
        ClasspathScanner serviceScanner = new ClasspathScanner((Filter)filter);
        for (URL url : input.getURLs()) {
            serviceScanner.scan(url);
        }
        return filter.getMatchedTypes();
    }

    private Set<ComponentReferenceModel> getReferences(SwitchYardNamespace switchyardNamespace, Class<?> serviceClass, String name) throws IOException {
        HashSet<ComponentReferenceModel> references = new HashSet<ComponentReferenceModel>();
        for (Field field : serviceClass.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Reference.class)) continue;
            Class<?> reference = field.getType();
            V1ComponentReferenceModel referenceModel = new V1ComponentReferenceModel(switchyardNamespace.uri());
            V1InterfaceModel interfaceModel = new V1InterfaceModel("java");
            if (field.getAnnotation(Reference.class) != null) {
                Reference ref = field.getAnnotation(Reference.class);
                if (ref.value() == null || "".equals(ref.value())) {
                    referenceModel.setName(reference.getSimpleName());
                } else {
                    QName qname = QName.valueOf(ref.value());
                    referenceModel.setName(qname.getLocalPart());
                }
            } else {
                referenceModel.setName(reference.getSimpleName());
            }
            referenceModel.setInterface((InterfaceModel)interfaceModel);
            interfaceModel.setInterface(reference.getCanonicalName());
            Requires refRequires = field.getAnnotation(Requires.class);
            if (refRequires != null) {
                for (SecurityPolicy securityPolicy : refRequires.security()) {
                    if (!securityPolicy.supports(Policy.PolicyType.INTERACTION)) {
                        throw BeanMessages.MESSAGES.referenceOnlyCouldBeMarkedWithInteractionPolicyButIsNotTheOne(securityPolicy.toString());
                    }
                    referenceModel.addPolicyRequirement(securityPolicy.getName());
                }
                for (SecurityPolicy securityPolicy : refRequires.transaction()) {
                    if (!securityPolicy.supports(Policy.PolicyType.INTERACTION)) {
                        throw BeanMessages.MESSAGES.referenceOnlyCouldBeMarkedWithInteractionPolicyButIsNotTheOne(securityPolicy.toString());
                    }
                    referenceModel.addPolicyRequirement(securityPolicy.getName());
                }
                String ptx = TransactionPolicy.PROPAGATES_TRANSACTION.getName();
                String stx = TransactionPolicy.SUSPENDS_TRANSACTION.getName();
                if (referenceModel.hasPolicyRequirement(ptx) && referenceModel.hasPolicyRequirement(stx)) {
                    throw BeanMessages.MESSAGES.transactionPoliciesCannotCoexistService(ptx, stx, name);
                }
            }
            references.add((ComponentReferenceModel)referenceModel);
        }
        return references;
    }
}

