/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.camel.deploy;

import java.net.URI;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.component.properties.PropertiesParser;
import org.apache.camel.model.FromDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.ToDefinition;
import org.switchyard.ServiceReference;
import org.switchyard.SwitchYardException;
import org.switchyard.common.camel.SwitchYardCamelContext;
import org.switchyard.common.property.PropertyResolver;
import org.switchyard.component.camel.CamelComponentMessages;
import org.switchyard.component.camel.ComponentNameComposer;
import org.switchyard.component.camel.RouteFactory;
import org.switchyard.component.camel.SwitchYardConsumer;
import org.switchyard.component.camel.SwitchYardEndpoint;
import org.switchyard.component.camel.SwitchYardPropertiesParser;
import org.switchyard.component.camel.common.composer.CamelComposition;
import org.switchyard.component.camel.common.deploy.BaseCamelActivator;
import org.switchyard.component.camel.model.CamelComponentImplementationModel;
import org.switchyard.config.model.composite.ComponentModel;
import org.switchyard.config.model.composite.ComponentReferenceModel;
import org.switchyard.config.model.composite.ComponentServiceModel;
import org.switchyard.deploy.ComponentNames;
import org.switchyard.deploy.ServiceHandler;

public class CamelActivator
extends BaseCamelActivator {
    public CamelActivator(SwitchYardCamelContext context, String ... types) {
        super(context, types);
    }

    public ServiceHandler activateService(QName serviceName, ComponentModel config) {
        ServiceHandler handler = null;
        PropertiesComponent propertiesComponent = (PropertiesComponent)this.getCamelContext().getComponent("properties", PropertiesComponent.class);
        PropertyResolver pr = config.getModelConfiguration().getPropertyResolver();
        propertiesComponent.setPropertiesParser((PropertiesParser)new SwitchYardPropertiesParser(pr));
        for (ComponentServiceModel service : config.getServices()) {
            if (!service.getQName().equals(serviceName)) continue;
            handler = this.handleImplementation(service, serviceName);
            break;
        }
        return handler;
    }

    public void deactivateService(QName name, ServiceHandler handler) {
    }

    private ServiceHandler handleImplementation(ComponentServiceModel config, QName serviceName) {
        CamelComponentImplementationModel ccim = (CamelComponentImplementationModel)config.getComponent().getImplementation();
        try {
            String endpointUri = ComponentNameComposer.composeComponentUri((QName)serviceName);
            List<RouteDefinition> routeDefinitions = this.getRouteDefinition(ccim);
            this.verifyRouteDefinitions(routeDefinitions, ccim);
            this.getCamelContext().addRouteDefinitions(routeDefinitions);
            SwitchYardEndpoint endpoint = (SwitchYardEndpoint)this.getCamelContext().getEndpoint(endpointUri, SwitchYardEndpoint.class);
            endpoint.setMessageComposer(CamelComposition.getMessageComposer());
            SwitchYardConsumer consumer = endpoint.getConsumer();
            consumer.setComponentName(config.getComponent().getQName());
            consumer.setNamespace(serviceName.getNamespaceURI());
            return consumer;
        }
        catch (Exception e) {
            throw new SwitchYardException(e.getMessage(), (Throwable)e);
        }
    }

    private boolean containsServiceRef(List<ComponentReferenceModel> refs, String serviceName) {
        for (ComponentReferenceModel refModel : refs) {
            if (!refModel.getName().equals(serviceName)) continue;
            return true;
        }
        return false;
    }

    private void verifyRouteDefinitions(List<RouteDefinition> routeDefinitions, CamelComponentImplementationModel ccim) throws Exception {
        String serviceName = ((ComponentServiceModel)ccim.getComponent().getServices().get(0)).getName();
        String compositeNs = ccim.getComponent().getComposite().getTargetNamespace();
        int serviceConsumer = 0;
        for (RouteDefinition routeDefinition : routeDefinitions) {
            if (routeDefinition.getInputs().isEmpty()) {
                throw CamelComponentMessages.MESSAGES.mustHaveAtLeastOneInput();
            }
            for (FromDefinition fromDefinition : routeDefinition.getInputs()) {
                URI from = URI.create(fromDefinition.getUri());
                if (!from.getScheme().equals("switchyard")) continue;
                if (serviceConsumer > 0) {
                    throw CamelComponentMessages.MESSAGES.onlyOneSwitchYardInputPerImpl();
                }
                String host = from.getHost();
                if (!serviceName.equals(host)) {
                    throw CamelComponentMessages.MESSAGES.implementationConsumerDoesNotMatchService(serviceName);
                }
                ++serviceConsumer;
            }
            List outputs = routeDefinition.getOutputs();
            for (ProcessorDefinition processorDefinition : outputs) {
                ToDefinition to;
                URI componentUri;
                if (!(processorDefinition instanceof ToDefinition) || !(componentUri = URI.create((to = (ToDefinition)processorDefinition).getUri())).getScheme().equals("switchyard")) continue;
                String referenceName = componentUri.getHost();
                QName refServiceName = new QName(compositeNs, referenceName);
                if (!this.containsServiceRef(ccim.getComponent().getReferences(), referenceName)) {
                    throw CamelComponentMessages.MESSAGES.couldNotFindServiceReference(referenceName, to.toString());
                }
                QName qualifiedRefName = ComponentNames.qualify((QName)ccim.getComponent().getQName(), (QName)refServiceName);
                ServiceReference service = this.getServiceDomain().getServiceReference(qualifiedRefName);
                if (service != null) continue;
                throw CamelComponentMessages.MESSAGES.couldNotFindServiceName(qualifiedRefName.toString(), to.toString());
            }
        }
        if (serviceConsumer != 1) {
            throw CamelComponentMessages.MESSAGES.cannotCreateComponentImpl();
        }
    }

    private List<RouteDefinition> getRouteDefinition(CamelComponentImplementationModel model) {
        List<RouteDefinition> routes = RouteFactory.getRoutes(model);
        return routes;
    }
}

