/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.common.composer;

import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.switchyard.common.type.Classes;
import org.switchyard.component.common.CommonCommonLogger;
import org.switchyard.component.common.composer.BindingData;
import org.switchyard.component.common.composer.MessageComposer;
import org.switchyard.config.model.composer.MessageComposerModel;

public abstract class MessageComposerFactory<D extends BindingData> {
    public abstract Class<D> getBindingDataClass();

    public abstract MessageComposer<D> newMessageComposerDefault();

    public final MessageComposer<D> newMessageComposer(MessageComposerModel model) {
        MessageComposer<D> messageComposer = null;
        MessageComposerFactory<D> messageComposerFactory = MessageComposerFactory.getMessageComposerFactory(this.getBindingDataClass());
        messageComposer = model != null ? messageComposerFactory.newMessageComposer(Classes.forName((String)model.getClazz())) : messageComposerFactory.newMessageComposerDefault();
        return messageComposer;
    }

    public final MessageComposer<D> newMessageComposer(Class<? extends MessageComposer<D>> custom) {
        MessageComposer<D> messageComposer = null;
        if (custom != null) {
            try {
                messageComposer = custom.newInstance();
            }
            catch (Exception e) {
                CommonCommonLogger.ROOT_LOGGER.couldNotInstantiateMessageComposer(custom.getClass().getName(), e.getMessage());
            }
        }
        if (messageComposer == null) {
            messageComposer = this.newMessageComposerDefault();
        }
        return messageComposer;
    }

    public static final <F extends BindingData> MessageComposerFactory<F> getMessageComposerFactory(Class<F> targetClass) {
        return MessageComposerFactory.getMessageComposerFactories().get(targetClass);
    }

    public static final Map<Class, MessageComposerFactory> getMessageComposerFactories() {
        HashMap<Class, MessageComposerFactory> factories = new HashMap<Class, MessageComposerFactory>();
        ServiceLoader<MessageComposerFactory> services = ServiceLoader.load(MessageComposerFactory.class);
        for (MessageComposerFactory factory : services) {
            factories.put(factory.getBindingDataClass(), factory);
        }
        return factories;
    }
}

