/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.validate.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.jboss.logging.Logger;
import org.switchyard.common.type.Classes;
import org.switchyard.config.model.ModelPuller;
import org.switchyard.config.model.validate.ValidateModel;
import org.switchyard.config.model.validate.ValidatesModel;
import org.switchyard.validate.ValidateMessages;
import org.switchyard.validate.Validator;
import org.switchyard.validate.ValidatorRegistry;
import org.switchyard.validate.internal.DuplicateValidatorException;
import org.switchyard.validate.internal.ValidatorUtil;

public class ValidatorRegistryLoader {
    private static Logger _log = Logger.getLogger(ValidatorRegistryLoader.class);
    public static final String VALIDATES_XML = "META-INF/switchyard/validates.xml";
    private List<Validator> _validators = new LinkedList<Validator>();
    private ValidatorRegistry _validatorRegistry;

    public ValidatorRegistryLoader(ValidatorRegistry validatorRegistry) {
        if (validatorRegistry == null) {
            throw ValidateMessages.MESSAGES.nullValidatorRegistryArgument();
        }
        this._validatorRegistry = validatorRegistry;
    }

    public void registerValidators(ValidatesModel validates) throws DuplicateValidatorException {
        if (validates == null) {
            return;
        }
        try {
            for (ValidateModel validateModel : validates.getValidates()) {
                Collection<Validator<?>> validators = ValidatorUtil.newValidators(validateModel);
                for (Validator<?> validator : validators) {
                    if (this._validatorRegistry.hasValidator(validator.getName())) {
                        Validator registeredValidator = this._validatorRegistry.getValidator(validator.getName());
                        throw ValidateMessages.MESSAGES.failedToRegisterValidator(this.toDescription(validator), this.toDescription(registeredValidator));
                    }
                    _log.debug((Object)("Adding validator =>, Name:" + validator.getName()));
                    this._validatorRegistry.addValidator(validator);
                    this._validators.add(validator);
                }
            }
        }
        catch (DuplicateValidatorException e) {
            throw e;
        }
        catch (RuntimeException e) {
            this.unregisterValidators();
            throw e;
        }
    }

    public void unregisterValidators() {
        for (Validator validator : this._validators) {
            this._validatorRegistry.removeValidator(validator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadOOTBValidates() {
        try {
            List resources = Classes.getResources((String)VALIDATES_XML, this.getClass());
            for (URL resource : resources) {
                InputStream configStream = resource.openStream();
                try {
                    ValidatesModel validatesModel = (ValidatesModel)new ModelPuller().pull(configStream);
                    this.registerValidators(validatesModel);
                }
                catch (DuplicateValidatorException e) {
                    _log.debug((Object)e.getMessage(), (Throwable)((Object)e));
                }
                finally {
                    configStream.close();
                }
            }
        }
        catch (IOException e) {
            throw ValidateMessages.MESSAGES.errorReadingValidator(VALIDATES_XML, e);
        }
    }

    private String toDescription(Validator<?> validator) {
        return validator.getClass().getName() + "(" + validator.getName() + ")";
    }
}

