/*
 * Decompiled with CFR 0.152.
 */
package com.drew.lang;

import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import java.io.Serializable;

public class Rational
extends Number
implements Comparable<Rational>,
Serializable {
    private static final long serialVersionUID = 510688928138848770L;
    private final long _numerator;
    private final long _denominator;

    public Rational(long numerator, long denominator) {
        this._numerator = numerator;
        this._denominator = denominator;
    }

    @Override
    public double doubleValue() {
        return this._numerator == 0L ? 0.0 : (double)this._numerator / (double)this._denominator;
    }

    @Override
    public float floatValue() {
        return this._numerator == 0L ? 0.0f : (float)this._numerator / (float)this._denominator;
    }

    @Override
    public final byte byteValue() {
        return (byte)this.doubleValue();
    }

    @Override
    public final int intValue() {
        return (int)this.doubleValue();
    }

    @Override
    public final long longValue() {
        return (long)this.doubleValue();
    }

    @Override
    public final short shortValue() {
        return (short)this.doubleValue();
    }

    public final long getDenominator() {
        return this._denominator;
    }

    public final long getNumerator() {
        return this._numerator;
    }

    @NotNull
    public Rational getReciprocal() {
        return new Rational(this._denominator, this._numerator);
    }

    public Rational getAbsolute() {
        return new Rational(Math.abs(this._numerator), Math.abs(this._denominator));
    }

    public boolean isInteger() {
        return this._denominator == 1L || this._denominator != 0L && this._numerator % this._denominator == 0L || this._denominator == 0L && this._numerator == 0L;
    }

    public boolean isZero() {
        return this._numerator == 0L || this._denominator == 0L;
    }

    public boolean isPositive() {
        return !this.isZero() && this._numerator > 0L == this._denominator > 0L;
    }

    @NotNull
    public String toString() {
        return this._numerator + "/" + this._denominator;
    }

    @NotNull
    public String toSimpleString(boolean allowDecimal) {
        String doubleString;
        if (this._denominator == 0L && this._numerator != 0L) {
            return this.toString();
        }
        if (this.isInteger()) {
            return Integer.toString(this.intValue());
        }
        if (this._numerator != 1L && this._denominator % this._numerator == 0L) {
            long newDenominator = this._denominator / this._numerator;
            return new Rational(1L, newDenominator).toSimpleString(allowDecimal);
        }
        Rational simplifiedInstance = this.getSimplifiedInstance();
        if (allowDecimal && (doubleString = Double.toString(simplifiedInstance.doubleValue())).length() < 5) {
            return doubleString;
        }
        return simplifiedInstance.toString();
    }

    @Override
    public int compareTo(@NotNull Rational that) {
        return Double.compare(this.doubleValue(), that.doubleValue());
    }

    public boolean equals(Rational other) {
        return other.doubleValue() == this.doubleValue();
    }

    public boolean equalsExact(Rational other) {
        return this.getDenominator() == other.getDenominator() && this.getNumerator() == other.getNumerator();
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof Rational)) {
            return false;
        }
        Rational that = (Rational)obj;
        return this.doubleValue() == that.doubleValue();
    }

    public int hashCode() {
        return 23 * (int)this._denominator + (int)this._numerator;
    }

    @NotNull
    public Rational getSimplifiedInstance() {
        long gcd = Rational.GCD(this._numerator, this._denominator);
        return new Rational(this._numerator / gcd, this._denominator / gcd);
    }

    private static long GCD(long a, long b) {
        if (a < 0L) {
            a = -a;
        }
        if (b < 0L) {
            b = -b;
        }
        while (a != 0L && b != 0L) {
            if (a > b) {
                a %= b;
                continue;
            }
            b %= a;
        }
        return a == 0L ? b : a;
    }
}

