/* Generated By:JJTree&JavaCC: Do not edit this line. Parser.java */
package org.tautua.markdownpapers.parser;
import org.tautua.markdownpapers.ast.*;


import org.tautua.markdownpapers.ast.*;
import org.tautua.markdownpapers.util.*;

public class Parser/*@bgen(jjtree)*/implements ParserTreeConstants, ParserConstants {/*@bgen(jjtree)*/
  protected JJTParserState jjtree = new JJTParserState();private static final String QUOTE = '"' + "";

    private Stack<Node> stack = new DequeStack<Node>();
    private Stack<Node> markupStack = new DequeStack<Node>();
    private int currentQuoteLevel = 0;
    private int parentheses;
    private int brackets;
    private int codespanPrefix;

    public Document parse() throws ParseException {
        jj_input_stream.setTabSize(4);
        Document();
        return (Document)getRootNode();
    }

    public Node getRootNode() {
        return jjtree.rootNode();
    }

    String val(Token t) {
        String i = t.image;
        if(t.kind == ESCAPED_CHAR) {
            i = String.valueOf(i.charAt(1));
        }
        return i;
    }

    int getTabLength(Token prev, Token tab) {
        return (4 - ((prev == null || prev.kind == EOL ? 1 : prev.endColumn + 1) % 4)) + 1;
    }

    String toWhitespace(Token prev, Token tab) {
        int x = getTabLength(prev, tab);
        switch(x) {
            case 1:
                return " ";
            case 2:
                return "  ";
            case 3:
                return "   ";
            default:
                return "    ";
        }
    }

    boolean ItemContinuesLookahead(){
        if (getToken(1).kind != EOL) {
            return false;
        }

        int offset = 2;
        int quotes = 0;
        boolean emptyLine = false;
        Token t;

        do {
            t = getToken(offset++);
            if (t.kind == GT) {
                quotes++;
            } else if (t.kind == EOL) {
                quotes = 0;
                emptyLine = true;
            }
        } while(t.any(EOL, SPACE, TAB, GT));

        if (t.kind == EOF) {
            return false;
        }

        Item item = (Item)stack.peek();

        return (item.getIndentation() < t.beginColumn && currentQuoteLevel == quotes) ||
            (emptyLine && (t.any(PLUS, MINUS, STAR) || (t.kind == DIGITS && getToken(offset++).kind == DOT)) && (getToken(offset).any(SPACE,TAB))
                && item.getIndentation() == t.beginColumn);
    }

    boolean BlockLookahead(Class expected){
        int offset = 1;
        int quotes = 0;
        Token t;

        do {
            t = getToken(offset++);
            if (t.kind == GT) {
                quotes++;
            }
        } while(t.any(SPACE, TAB, GT));

        if (t.any(EOL,EOF)) {
            return false;
        }

        Item item = (Item)stack.peek();

        if(item.getIndentation() < t.beginColumn && currentQuoteLevel == quotes) {
            if((t.any(PLUS, MINUS, STAR) || (t.kind == DIGITS && getToken(offset++).kind == DOT)) && (getToken(offset).any(SPACE, TAB))) {
                return List.class.equals(expected);
            }

            if(t.beginColumn - item.getIndentation() >= 8) {
                return Code.class.equals(expected);
            }

            return Paragraph.class.equals(expected);
        }

        return false;
    }

    boolean LineLookahead() {
        if (getToken(1).kind != EOL) {
            return false;
        }

        int offset = 2;
        int quotes = 0;
        Token t;

        do {
            t = getToken(offset++);
            if(t.kind == GT) {
                quotes++;
            }
        } while (t.any(SPACE, TAB, GT));

        if (t.any(EOL, EOF)) {
            return false;
        }

        if (((t.any(PLUS, MINUS, STAR) || (t.kind == DIGITS && getToken(offset++).kind == DOT)) && getToken(offset).any(SPACE, TAB)) && stack.peek() instanceof Item) {
            return false;
        }

        return currentQuoteLevel >= quotes;
    }

    boolean CodeLineLookahead() {
        if (getToken(1).kind != EOL) {
            return false;
        }

        int offset = 2;
        int quotes = 0;
        int indent = 0;
        Token t;

        do {
            t = getToken(offset++);
            if(t.kind == GT) {
                quotes++;
                indent = 0;
            } else if(t.kind == SPACE) {
                indent++;
            } else if(t.kind == TAB) {
                indent += 4;//getTabLength(getToken(offset - 2),t);
            } else if(t.kind == EOL) {
                indent = 0;
            }
        } while (t.any(SPACE, TAB, GT, EOL) && indent < 4);

        if (t.any(EOF)) {
            return false;
        }

        return currentQuoteLevel >= quotes && indent >= 4;
    }

    boolean QuotedElementLookahead() {
        if (getToken(1).kind != EOL) {
            return false;
        }

        int offset = 2;
        int quotes = 0;
        Token t;

        do {
            t = getToken(offset++);
            if (t.any(GT)) {
                quotes++;
            }
        } while (t.any(SPACE, TAB, GT));

        if (t.any(EOL, EOF)) {
            return true;
        }

        return currentQuoteLevel <= quotes;
    }

    boolean TextLookahead() {
        if (stack.size() > 0 && stack.peek() instanceof Header) {
            int offset = 1;
            Token t;
            do {
                t = getToken(offset++);
            } while(t.kind == SHARP);

            return t.none(EOL,EOF);
        }

        return getToken(1).none(EOL, EOF);
    }

    boolean ItemLookahead() {
        if (getToken(1).none(EOL)) {
            return false;
        }

        int offset = 2;
        int quotes = 0;
        Token t;

        do {
            t = getToken(offset++);
            if (t.any(GT)) {
                quotes++;
            }
        } while (t.any(EOL, SPACE, TAB, GT));

        List list = (List)stack.peek();

        return list.getIndentation() == t.beginColumn
            && ((t.any(PLUS, MINUS, STAR) && !RulerLookahead(offset)) || (t.kind == DIGITS && getToken(offset++).kind == DOT)) && getToken(offset).any(SPACE, TAB);
    }

    boolean RulerLookahead(int offset) {
        Token t;
        int whitespace = 0;
        int count = 0;
        do {
            t = getToken(offset++);
            if(t.kind == SPACE) {
                whitespace++;
            } else {
                if(t.any(STAR, MINUS)) {
                    count++;
                }
                whitespace = 0;
            }

            if(whitespace > 2) {
                return false;
            }
        } while(t.any(STAR, MINUS, SPACE));

        return count >= 2 && t.any(EOL, EOF);
    }

    boolean BacktickInsideCodeSpanLookahead(){
        if(codespanPrefix == 0) {
            return false;
        }
        int offset = 1;
        int suffix = 0;
        Token t;
        do {
            t = getToken(offset++);
            if(t.kind == BACKTICK) {
                suffix++;
            }
        } while(t.kind == BACKTICK);

        return suffix < codespanPrefix;
    }

    boolean CodeSpanLookahead() {
        int offset = 1;
        int prefix = 0;
        boolean empty = true;

        Token t;
        do {
            t = getToken(offset++);
            if(t.kind == BACKTICK){
                prefix++;
            }
        } while(t.kind == BACKTICK);

        if(prefix == 0) {
            return false;
        }

        do {
            do {
                t = getToken(offset++);
                if(t.none(SPACE, TAB, EOL)) {
                    empty = false;
                }
            } while(t.kind != BACKTICK && t.kind != EOL && t.kind != EOF);

            if(t.kind == EOL) {
                if(empty) {
                    return false;
                } else {
                    empty = true;
                    continue;
                }
            }

            if(t.kind != EOF) {
                int countdown = prefix;
                do {
                    countdown--;
                    t = getToken(offset++);
                } while(t.kind == BACKTICK);
                if(countdown <= 0) {
                    return true;
                }
            }
        } while(t.kind != EOF);

        return false;
    }

    boolean CodeSpanTextLookahead() {
        int offset = 1;
        Token t;
        do {
            t = getToken(offset++);
        } while(t.any(EOL,SPACE,TAB));

        return t.kind != EOF && t.kind != BACKTICK;
    }

  final public void Document() throws ParseException {
                             /*@bgen(jjtree) Document */
  Document jjtn000 = new Document(JJTDOCUMENT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      label_1:
      while (true) {
        if (jj_2_1(1)) {
          ;
        } else {
          break label_1;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case EOL:
          jj_consume_token(EOL);
          break;
        default:
          jj_la1[0] = jj_gen;
          if (jj_2_3(1)) {
            Element();
            label_2:
            while (true) {
              if (jj_2_2(2)) {
                ;
              } else {
                break label_2;
              }
              jj_consume_token(EOL);
              Element();
            }
          } else {
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
      }
      jj_consume_token(0);
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
  }

  final public void Element() throws ParseException {
    if (jj_2_4(2147483647)) {
      ResourceDefinition();
    } else if (jj_2_5(1)) {
      BlockElement();
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void BlockElement() throws ParseException {
    if (jj_2_13(2147483647)) {
      Whitespace();
    } else if (jj_2_14(2147483647)) {
      Code();
    } else if (jj_2_15(1)) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SPACE:
        InsignificantWhitespace();
        break;
      default:
        jj_la1[1] = jj_gen;
        ;
      }
      if (jj_2_6(2147483647)) {
        Quote();
      } else if (jj_2_7(2147483647)) {
        Ruler();
      } else if (jj_2_8(2147483647)) {
        Header();
      } else if (jj_2_9(2147483647)) {
        Comment();
      } else if (jj_2_10(2147483647)) {
        HtmlBlock();
      } else if (jj_2_11(3)) {
        List();
      } else if (jj_2_12(1)) {
        Paragraph();
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void HtmlBlock() throws ParseException {
    Tag();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SPACE:
    case TAB:
      Whitespace();
      break;
    default:
      jj_la1[2] = jj_gen;
      ;
    }
  }

  final public void Whitespace() throws ParseException {
    label_3:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SPACE:
        jj_consume_token(SPACE);
        break;
      case TAB:
        jj_consume_token(TAB);
        break;
      default:
        jj_la1[3] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SPACE:
      case TAB:
        ;
        break;
      default:
        jj_la1[4] = jj_gen;
        break label_3;
      }
    }
  }

  final public void InsignificantWhitespace() throws ParseException {
    jj_consume_token(SPACE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SPACE:
      jj_consume_token(SPACE);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SPACE:
        jj_consume_token(SPACE);
        break;
      default:
        jj_la1[5] = jj_gen;
        ;
      }
      break;
    default:
      jj_la1[6] = jj_gen;
      ;
    }
  }

  final public void EmptyLine() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SPACE:
    case TAB:
      Whitespace();
      break;
    default:
      jj_la1[7] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EOL:
      jj_consume_token(EOL);
      break;
    case 0:
      jj_consume_token(0);
      break;
    default:
      jj_la1[8] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void Header() throws ParseException {
                         /*@bgen(jjtree) Header */
    Header jjtn000 = new Header(JJTHEADER);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);int level = 1;
    stack.push(jjtn000);
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SHARP:
        level = HeaderPrefix();
        Line();
        label_4:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case SHARP:
            ;
            break;
          default:
            jj_la1[9] = jj_gen;
            break label_4;
          }
          jj_consume_token(SHARP);
        }
        break;
      default:
        jj_la1[10] = jj_gen;
        if (jj_2_16(1)) {
          Line();
          jj_consume_token(EOL);
          level = HeaderSuffix();
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SPACE:
      case TAB:
        Whitespace();
        break;
      default:
        jj_la1[11] = jj_gen;
        ;
      }
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
        jjtn000.setLevel(level);
        stack.pop();
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
  }

  final public int HeaderPrefix() throws ParseException {
    int level = 1;
    jj_consume_token(SHARP);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SHARP:
      jj_consume_token(SHARP);
                level++;
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SHARP:
        jj_consume_token(SHARP);
                                   level++;
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case SHARP:
          jj_consume_token(SHARP);
                                                      level++;
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case SHARP:
            jj_consume_token(SHARP);
                                                                         level++;
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case SHARP:
              jj_consume_token(SHARP);
                                                                                            level++;
              break;
            default:
              jj_la1[12] = jj_gen;
              ;
            }
            break;
          default:
            jj_la1[13] = jj_gen;
            ;
          }
          break;
        default:
          jj_la1[14] = jj_gen;
          ;
        }
        break;
      default:
        jj_la1[15] = jj_gen;
        ;
      }
      break;
    default:
      jj_la1[16] = jj_gen;
      ;
    }
        {if (true) return level;}
    throw new Error("Missing return statement in function");
  }

  final public int HeaderSuffix() throws ParseException {
    int level = 1;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EQ:
      label_5:
      while (true) {
        jj_consume_token(EQ);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case EQ:
          ;
          break;
        default:
          jj_la1[17] = jj_gen;
          break label_5;
        }
      }
                      level = 1;
      break;
    case MINUS:
      label_6:
      while (true) {
        jj_consume_token(MINUS);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case MINUS:
          ;
          break;
        default:
          jj_la1[18] = jj_gen;
          break label_6;
        }
      }
                           level = 2;
      break;
    default:
      jj_la1[19] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return level;}
    throw new Error("Missing return statement in function");
  }

  final public void Ruler() throws ParseException {
                       /*@bgen(jjtree) Ruler */
  Ruler jjtn000 = new Ruler(JJTRULER);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case MINUS:
        jj_consume_token(MINUS);
        if (jj_2_17(3)) {
          jj_consume_token(SPACE);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case SPACE:
            jj_consume_token(SPACE);
            break;
          default:
            jj_la1[20] = jj_gen;
            ;
          }
        } else {
          ;
        }
        jj_consume_token(MINUS);
        label_7:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case SPACE:
            jj_consume_token(SPACE);
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case SPACE:
              jj_consume_token(SPACE);
              break;
            default:
              jj_la1[21] = jj_gen;
              ;
            }
            break;
          default:
            jj_la1[22] = jj_gen;
            ;
          }
          jj_consume_token(MINUS);
          if (jj_2_18(3)) {
            ;
          } else {
            break label_7;
          }
        }
        break;
      case STAR:
        jj_consume_token(STAR);
        if (jj_2_19(3)) {
          jj_consume_token(SPACE);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case SPACE:
            jj_consume_token(SPACE);
            break;
          default:
            jj_la1[23] = jj_gen;
            ;
          }
        } else {
          ;
        }
        jj_consume_token(STAR);
        label_8:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case SPACE:
            jj_consume_token(SPACE);
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case SPACE:
              jj_consume_token(SPACE);
              break;
            default:
              jj_la1[24] = jj_gen;
              ;
            }
            break;
          default:
            jj_la1[25] = jj_gen;
            ;
          }
          jj_consume_token(STAR);
          if (jj_2_20(3)) {
            ;
          } else {
            break label_8;
          }
        }
        break;
      case UNDERSCORE:
        jj_consume_token(UNDERSCORE);
        if (jj_2_21(3)) {
          jj_consume_token(SPACE);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case SPACE:
            jj_consume_token(SPACE);
            break;
          default:
            jj_la1[26] = jj_gen;
            ;
          }
        } else {
          ;
        }
        jj_consume_token(UNDERSCORE);
        label_9:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case SPACE:
            jj_consume_token(SPACE);
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case SPACE:
              jj_consume_token(SPACE);
              break;
            default:
              jj_la1[27] = jj_gen;
              ;
            }
            break;
          default:
            jj_la1[28] = jj_gen;
            ;
          }
          jj_consume_token(UNDERSCORE);
          if (jj_2_22(3)) {
            ;
          } else {
            break label_9;
          }
        }
        break;
      default:
        jj_la1[29] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SPACE:
      case TAB:
        Whitespace();
        break;
      default:
        jj_la1[30] = jj_gen;
        ;
      }
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
  }

  final public void Quote() throws ParseException {
                       /*@bgen(jjtree) Quote */
    Quote jjtn000 = new Quote(JJTQUOTE);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);stack.push(jjtn000);
    currentQuoteLevel++;
    try {
      QuotePrefix();
      BlockElement();
      label_10:
      while (true) {
        if (QuotedElementLookahead()) {
          ;
        } else {
          break label_10;
        }
        jj_consume_token(EOL);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case SPACE:
        case TAB:
        case GT:
          if (jj_2_24(2147483647)) {
                                                           Line jjtn001 = new Line(JJTLINE);
                                                           boolean jjtc001 = true;
                                                           jjtree.openNodeScope(jjtn001);
            try {
              Whitespace();
            } catch (Throwable jjte001) {
                                                           if (jjtc001) {
                                                             jjtree.clearNodeScope(jjtn001);
                                                             jjtc001 = false;
                                                           } else {
                                                             jjtree.popNode();
                                                           }
                                                           if (jjte001 instanceof RuntimeException) {
                                                             {if (true) throw (RuntimeException)jjte001;}
                                                           }
                                                           if (jjte001 instanceof ParseException) {
                                                             {if (true) throw (ParseException)jjte001;}
                                                           }
                                                           {if (true) throw (Error)jjte001;}
            } finally {
                                                           if (jjtc001) {
                                                             jjtree.closeNodeScope(jjtn001, true);
                                                           }
            }
          } else if (jj_2_25(2147483647)) {
            QuotePrefix();
            if (jj_2_23(1)) {
              BlockElement();
            } else {
              ;
            }
          } else {
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
        default:
          jj_la1[31] = jj_gen;
          ;
        }
      }
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
    currentQuoteLevel--;
    stack.pop();
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
  }

  final public void QuotePrefix() throws ParseException {
    jj_consume_token(GT);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SPACE:
      jj_consume_token(SPACE);
      break;
    default:
      jj_la1[32] = jj_gen;
      ;
    }
  }

  final public void Code() throws ParseException {
                     /*@bgen(jjtree) Code */
  Code jjtn000 = new Code(JJTCODE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      CodeLine();
      label_11:
      while (true) {
        if (CodeLineLookahead()) {
          ;
        } else {
          break label_11;
        }
        jj_consume_token(EOL);
        label_12:
        while (true) {
          if (jj_2_26(2147483647)) {
            ;
          } else {
            break label_12;
          }
          QuotePrefix();
        }
        if (jj_2_27(2147483647)) {
                                                           Line jjtn001 = new Line(JJTLINE);
                                                           boolean jjtc001 = true;
                                                           jjtree.openNodeScope(jjtn001);
          try {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case SPACE:
            case TAB:
              Whitespace();
              break;
            default:
              jj_la1[33] = jj_gen;
              ;
            }
          } catch (Throwable jjte001) {
                                                           if (jjtc001) {
                                                             jjtree.clearNodeScope(jjtn001);
                                                             jjtc001 = false;
                                                           } else {
                                                             jjtree.popNode();
                                                           }
                                                           if (jjte001 instanceof RuntimeException) {
                                                             {if (true) throw (RuntimeException)jjte001;}
                                                           }
                                                           if (jjte001 instanceof ParseException) {
                                                             {if (true) throw (ParseException)jjte001;}
                                                           }
                                                           {if (true) throw (Error)jjte001;}
          } finally {
                                                           if (jjtc001) {
                                                             jjtree.closeNodeScope(jjtn001, true);
                                                           }
          }
        } else {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case SPACE:
          case TAB:
            CodeLine();
            break;
          default:
            jj_la1[34] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
      }
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
  }

  final public void CodeLine() throws ParseException {
                         /*@bgen(jjtree) Line */
  Line jjtn000 = new Line(JJTLINE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      CodeLinePrefix();
      CodeText();
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
  }

  final public void CodeLinePrefix() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SPACE:
      jj_consume_token(SPACE);
      jj_consume_token(SPACE);
      jj_consume_token(SPACE);
      jj_consume_token(SPACE);
      break;
    case TAB:
      jj_consume_token(TAB);
      break;
    default:
      jj_la1[35] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void CodeText() throws ParseException {
                             /*@bgen(jjtree) CodeText */
    CodeText jjtn000 = new CodeText(JJTCODETEXT);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);Token t;
    Token prev = null;
    try {
      label_13:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case SPACE:
        case TAB:
        case CHAR_ENTITY_REF:
        case NUMERIC_CHAR_REF:
        case ESCAPED_CHAR:
        case CHAR_SEQUENCE:
        case DIGITS:
        case AMPERSAND:
        case BACKSLASH:
        case BACKTICK:
        case BANG:
        case COMMENT_OPEN:
        case COMMENT_CLOSE:
        case COLON:
        case DOUBLE_QUOTE:
        case DOT:
        case EQ:
        case GT:
        case LBRACKET:
        case LPAREN:
        case LT:
        case MINUS:
        case PLUS:
        case RBRACKET:
        case RPAREN:
        case SHARP:
        case SINGLE_QUOTE:
        case SLASH:
        case STAR:
        case UNDERSCORE:
          ;
          break;
        default:
          jj_la1[36] = jj_gen;
          break label_13;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case SPACE:
        case CHAR_ENTITY_REF:
        case NUMERIC_CHAR_REF:
        case ESCAPED_CHAR:
        case CHAR_SEQUENCE:
        case DIGITS:
        case AMPERSAND:
        case BACKSLASH:
        case BACKTICK:
        case BANG:
        case COMMENT_OPEN:
        case COMMENT_CLOSE:
        case COLON:
        case DOUBLE_QUOTE:
        case DOT:
        case EQ:
        case GT:
        case LBRACKET:
        case LPAREN:
        case LT:
        case MINUS:
        case PLUS:
        case RBRACKET:
        case RPAREN:
        case SHARP:
        case SINGLE_QUOTE:
        case SLASH:
        case STAR:
        case UNDERSCORE:
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case CHAR_SEQUENCE:
            t = jj_consume_token(CHAR_SEQUENCE);
            break;
          case SPACE:
            t = jj_consume_token(SPACE);
            break;
          case DIGITS:
            t = jj_consume_token(DIGITS);
            break;
          case AMPERSAND:
            t = jj_consume_token(AMPERSAND);
            break;
          case BACKTICK:
            t = jj_consume_token(BACKTICK);
            break;
          case BACKSLASH:
            t = jj_consume_token(BACKSLASH);
            break;
          case BANG:
            t = jj_consume_token(BANG);
            break;
          case CHAR_ENTITY_REF:
            t = jj_consume_token(CHAR_ENTITY_REF);
            break;
          case COMMENT_OPEN:
            t = jj_consume_token(COMMENT_OPEN);
            break;
          case COMMENT_CLOSE:
            t = jj_consume_token(COMMENT_CLOSE);
            break;
          case COLON:
            t = jj_consume_token(COLON);
            break;
          case DOT:
            t = jj_consume_token(DOT);
            break;
          case DOUBLE_QUOTE:
            t = jj_consume_token(DOUBLE_QUOTE);
            break;
          case EQ:
            t = jj_consume_token(EQ);
            break;
          case ESCAPED_CHAR:
            t = jj_consume_token(ESCAPED_CHAR);
            break;
          case GT:
            t = jj_consume_token(GT);
            break;
          case NUMERIC_CHAR_REF:
            t = jj_consume_token(NUMERIC_CHAR_REF);
            break;
          case LBRACKET:
            t = jj_consume_token(LBRACKET);
            break;
          case LPAREN:
            t = jj_consume_token(LPAREN);
            break;
          case LT:
            t = jj_consume_token(LT);
            break;
          case MINUS:
            t = jj_consume_token(MINUS);
            break;
          case PLUS:
            t = jj_consume_token(PLUS);
            break;
          case RBRACKET:
            t = jj_consume_token(RBRACKET);
            break;
          case RPAREN:
            t = jj_consume_token(RPAREN);
            break;
          case SHARP:
            t = jj_consume_token(SHARP);
            break;
          case SINGLE_QUOTE:
            t = jj_consume_token(SINGLE_QUOTE);
            break;
          case SLASH:
            t = jj_consume_token(SLASH);
            break;
          case STAR:
            t = jj_consume_token(STAR);
            break;
          case UNDERSCORE:
            t = jj_consume_token(UNDERSCORE);
            break;
          default:
            jj_la1[37] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
                jjtn000.append(t.image);
          break;
        case TAB:
          t = jj_consume_token(TAB);
                          jjtn000.append(toWhitespace(prev, t));
          break;
        default:
          jj_la1[38] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
            prev = t;
      }
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
  }

  final public void ResourceDefinition() throws ParseException {
                                                 /*@bgen(jjtree) ResourceDefinition */
    ResourceDefinition jjtn000 = new ResourceDefinition(JJTRESOURCEDEFINITION);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);String n = null;
    Resource resource;
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SPACE:
        InsignificantWhitespace();
        break;
      default:
        jj_la1[39] = jj_gen;
        ;
      }
      jj_consume_token(LBRACKET);
      n = refname();
      jj_consume_token(RBRACKET);
                            jjtn000.setId(n);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SPACE:
        jj_consume_token(SPACE);
        break;
      default:
        jj_la1[40] = jj_gen;
        ;
      }
      jj_consume_token(COLON);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SPACE:
      case TAB:
        Whitespace();
        break;
      default:
        jj_la1[41] = jj_gen;
        ;
      }
      resource = Resource();
                            jjtn000.setResource(resource);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SPACE:
      case TAB:
        Whitespace();
        break;
      default:
        jj_la1[42] = jj_gen;
        ;
      }
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
  }

  final public void List() throws ParseException {
                     /*@bgen(jjtree) List */
    List jjtn000 = new List(JJTLIST);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);stack.push(jjtn000);
    try {
      label_14:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case SPACE:
        case TAB:
        case GT:
          ;
          break;
        default:
          jj_la1[43] = jj_gen;
          break label_14;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case SPACE:
          jj_consume_token(SPACE);
          break;
        case TAB:
          jj_consume_token(TAB);
          break;
        case GT:
          jj_consume_token(GT);
          break;
        default:
          jj_la1[44] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      Item();
      label_15:
      while (true) {
        if (ItemLookahead()) {
          ;
        } else {
          break label_15;
        }
        jj_consume_token(EOL);
        label_16:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case SPACE:
          case TAB:
          case GT:
            ;
            break;
          default:
            jj_la1[45] = jj_gen;
            break label_16;
          }
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case SPACE:
            jj_consume_token(SPACE);
            break;
          case TAB:
            jj_consume_token(TAB);
            break;
          case GT:
            jj_consume_token(GT);
            break;
          default:
            jj_la1[46] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case DIGITS:
        case MINUS:
        case PLUS:
        case STAR:
          Item();
          break;
        default:
          jj_la1[47] = jj_gen;
          ;
        }
      }
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
        stack.pop();
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
  }

  final public void Item() throws ParseException {
                     /*@bgen(jjtree) Item */
    Item jjtn000 = new Item(JJTITEM);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);stack.push(jjtn000);
    Token t;
    try {
      t = ItemPrefix();
        if(t.kind == DIGITS) {
            jjtn000.makeOrdered();
        }
        jjtn000.setIndentation(t.beginColumn);
      if (jj_2_29(1)) {
        Paragraph();
        label_17:
        while (true) {
          if (ItemContinuesLookahead()) {
            ;
          } else {
            break label_17;
          }
          jj_consume_token(EOL);
          if (jj_2_28(2147483647)) {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case SPACE:
            case TAB:
              Whitespace();
              break;
            default:
              jj_la1[48] = jj_gen;
              ;
            }
                                                                  jjtn000.makeLoose();
          } else if (BlockLookahead(Code.class)) {
            TrimItemWhitespace();
            Code();
                                                                                              jjtn000.makeLoose();
          } else if (BlockLookahead(Paragraph.class)) {
            Paragraph();
                                                                                   jjtn000.makeLoose();
          } else if (BlockLookahead(List.class)) {
            List();
          } else {
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
      } else {
        ;
      }
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
        Item item = (Item)stack.pop();
        List list = (List)stack.peek();
        if (list.getIndentation() == -1) {
            list.setIndentation(item.getIndentation());
        }
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
  }

  void TrimItemWhitespace() throws ParseException {
    Token t;
    int indent = 0;
    int offset = 0;
    Item item = (Item)stack.peek();

    do {
        t = getToken(++offset);
        if(t.kind == GT) {
            indent = 0;
        } else if(t.kind == SPACE) {
            indent++;
        } else if(t.kind == TAB) {
            indent += getTabLength(getToken(offset - 1),t);
        }

        if((indent - item.getIndentation()) >= 4) {
            break;
        }
    } while(t.any(SPACE, TAB, GT));

    while(offset > 1) {
        offset--;
        getNextToken();
    }
  }

  final public Token ItemPrefix() throws ParseException {
    Token t;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PLUS:
      t = jj_consume_token(PLUS);
      break;
    case MINUS:
      t = jj_consume_token(MINUS);
      break;
    case STAR:
      t = jj_consume_token(STAR);
      break;
    case DIGITS:
      t = jj_consume_token(DIGITS);
      jj_consume_token(DOT);
      break;
    default:
      jj_la1[49] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SPACE:
      jj_consume_token(SPACE);
      break;
    case TAB:
      jj_consume_token(TAB);
      break;
    default:
      jj_la1[50] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public void Paragraph() throws ParseException {
                               /*@bgen(jjtree) Paragraph */
  Paragraph jjtn000 = new Paragraph(JJTPARAGRAPH);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      Line();
      label_18:
      while (true) {
        if (LineLookahead()) {
          ;
        } else {
          break label_18;
        }
        jj_consume_token(EOL);
        label_19:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case SPACE:
          case TAB:
          case GT:
            ;
            break;
          default:
            jj_la1[51] = jj_gen;
            break label_19;
          }
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case SPACE:
            jj_consume_token(SPACE);
            break;
          case TAB:
            jj_consume_token(TAB);
            break;
          case GT:
            jj_consume_token(GT);
            break;
          default:
            jj_la1[52] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        Line();
      }
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
  }

  final public void Line() throws ParseException {
                     /*@bgen(jjtree) Line */
  Line jjtn000 = new Line(JJTLINE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      label_20:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case CHAR_ENTITY_REF:
        case NUMERIC_CHAR_REF:
          CharRef();
          break;
        default:
          jj_la1[53] = jj_gen;
          if (CodeSpanLookahead()) {
            CodeSpan();
          } else if (jj_2_30(2147483647)) {
            Link();
          } else if (jj_2_31(2147483647)) {
            Image();
          } else if (jj_2_32(2147483647)) {
            InlineURL();
          } else if (jj_2_33(2147483647)) {
            Emphasis();
          } else if (jj_2_34(2147483647)) {
            LineBreak();
          } else if (jj_2_35(2147483647)) {
            Markup();
          } else {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case SPACE:
            case TAB:
            case ESCAPED_CHAR:
            case CHAR_SEQUENCE:
            case DIGITS:
            case AMPERSAND:
            case BACKSLASH:
            case BACKTICK:
            case BANG:
            case COMMENT_OPEN:
            case COMMENT_CLOSE:
            case COLON:
            case DOUBLE_QUOTE:
            case DOT:
            case EQ:
            case GT:
            case LBRACKET:
            case LPAREN:
            case LT:
            case MINUS:
            case PLUS:
            case RBRACKET:
            case RPAREN:
            case SHARP:
            case SINGLE_QUOTE:
            case SLASH:
            case STAR:
            case UNDERSCORE:
              Text();
              break;
            default:
              jj_la1[54] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
        }
        if (TextLookahead()) {
          ;
        } else {
          break label_20;
        }
      }
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
  }

  final public void LineBreak() throws ParseException {
                               /*@bgen(jjtree) LineBreak */
  LineBreak jjtn000 = new LineBreak(JJTLINEBREAK);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(SPACE);
      jj_consume_token(SPACE);
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
  }

  final public void Text() throws ParseException {
                     /*@bgen(jjtree) Text */
    Text jjtn000 = new Text(JJTTEXT);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);Token t;
    String v;
    try {
      v = Anything();
                     jjtree.closeNodeScope(jjtn000, true);
                     jjtc000 = false;
                     jjtn000.append(v);
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
  }

  final public void CharRef() throws ParseException {
                           /*@bgen(jjtree) CharRef */
    CharRef jjtn000 = new CharRef(JJTCHARREF);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);Token t;
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NUMERIC_CHAR_REF:
        t = jj_consume_token(NUMERIC_CHAR_REF);
        break;
      case CHAR_ENTITY_REF:
        t = jj_consume_token(CHAR_ENTITY_REF);
        break;
      default:
        jj_la1[55] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                                                         jjtree.closeNodeScope(jjtn000, true);
                                                         jjtc000 = false;
                                                         jjtn000.setValue(t.image);
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
  }

  final public void CodeSpan() throws ParseException {
                             /*@bgen(jjtree) CodeSpan */
    CodeSpan jjtn000 = new CodeSpan(JJTCODESPAN);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);StringBuilder buff = new StringBuilder();
    int prefix = 0;
    try {
      label_21:
      while (true) {
        jj_consume_token(BACKTICK);
                  codespanPrefix++;
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case BACKTICK:
          ;
          break;
        default:
          jj_la1[56] = jj_gen;
          break label_21;
        }
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SPACE:
      case TAB:
        Whitespace();
        break;
      default:
        jj_la1[57] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EOL:
        jj_consume_token(EOL);
        break;
      default:
        jj_la1[58] = jj_gen;
        ;
      }
      label_22:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case SPACE:
        case TAB:
        case CHAR_ENTITY_REF:
        case NUMERIC_CHAR_REF:
        case ESCAPED_CHAR:
        case CHAR_SEQUENCE:
        case DIGITS:
        case AMPERSAND:
        case BACKSLASH:
        case BANG:
        case COMMENT_OPEN:
        case COMMENT_CLOSE:
        case COLON:
        case DOUBLE_QUOTE:
        case DOT:
        case EQ:
        case GT:
        case LBRACKET:
        case LPAREN:
        case LT:
        case MINUS:
        case PLUS:
        case RBRACKET:
        case RPAREN:
        case SHARP:
        case SINGLE_QUOTE:
        case SLASH:
        case STAR:
        case UNDERSCORE:
          CodeSpanText(buff);
          break;
        default:
          jj_la1[60] = jj_gen;
          if (jj_2_36(2147483647)) {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case SPACE:
              jj_consume_token(SPACE);
              break;
            case TAB:
              jj_consume_token(TAB);
              break;
            default:
              jj_la1[59] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          } else {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case EOL:
              jj_consume_token(EOL);
                      buff.append("\u005cn");
              break;
            default:
              jj_la1[61] = jj_gen;
              if (BacktickInsideCodeSpanLookahead()) {
                jj_consume_token(BACKTICK);
                                                                            buff.append("`");
              } else {
                jj_consume_token(-1);
                throw new ParseException();
              }
            }
          }
        }
        if (jj_2_37(1)) {
          ;
        } else {
          break label_22;
        }
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SPACE:
      case TAB:
        Whitespace();
        break;
      default:
        jj_la1[62] = jj_gen;
        ;
      }
      label_23:
      while (true) {
        jj_consume_token(BACKTICK);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case BACKTICK:
          ;
          break;
        default:
          jj_la1[63] = jj_gen;
          break label_23;
        }
      }
                                        jjtree.closeNodeScope(jjtn000, true);
                                        jjtc000 = false;
                                        jjtn000.setText(buff.toString()); codespanPrefix = 0;
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
  }

  final public void CodeSpanText(StringBuilder buff) throws ParseException {
    Token t;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CHAR_SEQUENCE:
      t = jj_consume_token(CHAR_SEQUENCE);
      break;
    case SPACE:
      t = jj_consume_token(SPACE);
      break;
    case DIGITS:
      t = jj_consume_token(DIGITS);
      break;
    case AMPERSAND:
      t = jj_consume_token(AMPERSAND);
      break;
    case BACKSLASH:
      t = jj_consume_token(BACKSLASH);
      break;
    case BANG:
      t = jj_consume_token(BANG);
      break;
    case CHAR_ENTITY_REF:
      t = jj_consume_token(CHAR_ENTITY_REF);
      break;
    case COLON:
      t = jj_consume_token(COLON);
      break;
    case COMMENT_CLOSE:
      t = jj_consume_token(COMMENT_CLOSE);
      break;
    case COMMENT_OPEN:
      t = jj_consume_token(COMMENT_OPEN);
      break;
    case DOT:
      t = jj_consume_token(DOT);
      break;
    case DOUBLE_QUOTE:
      t = jj_consume_token(DOUBLE_QUOTE);
      break;
    case EQ:
      t = jj_consume_token(EQ);
      break;
    case ESCAPED_CHAR:
      t = jj_consume_token(ESCAPED_CHAR);
      break;
    case GT:
      t = jj_consume_token(GT);
      break;
    case LBRACKET:
      t = jj_consume_token(LBRACKET);
      break;
    case LPAREN:
      t = jj_consume_token(LPAREN);
      break;
    case LT:
      t = jj_consume_token(LT);
      break;
    case MINUS:
      t = jj_consume_token(MINUS);
      break;
    case NUMERIC_CHAR_REF:
      t = jj_consume_token(NUMERIC_CHAR_REF);
      break;
    case PLUS:
      t = jj_consume_token(PLUS);
      break;
    case RBRACKET:
      t = jj_consume_token(RBRACKET);
      break;
    case RPAREN:
      t = jj_consume_token(RPAREN);
      break;
    case SHARP:
      t = jj_consume_token(SHARP);
      break;
    case SINGLE_QUOTE:
      t = jj_consume_token(SINGLE_QUOTE);
      break;
    case SLASH:
      t = jj_consume_token(SLASH);
      break;
    case STAR:
      t = jj_consume_token(STAR);
      break;
    case TAB:
      t = jj_consume_token(TAB);
      break;
    case UNDERSCORE:
      t = jj_consume_token(UNDERSCORE);
      break;
    default:
      jj_la1[64] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        buff.append(t.image);
  }

  final public void Emphasis() throws ParseException {
                             /*@bgen(jjtree) Emphasis */
    Emphasis jjtn000 = new Emphasis(JJTEMPHASIS);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);StringBuilder buff = new StringBuilder();
    Token t;
    int flag = 1;
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case UNDERSCORE:
        jj_consume_token(UNDERSCORE);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case UNDERSCORE:
          jj_consume_token(UNDERSCORE);
                                      flag = 2;
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case UNDERSCORE:
            jj_consume_token(UNDERSCORE);
                                                                   flag = 3;
            break;
          default:
            jj_la1[65] = jj_gen;
            ;
          }
          break;
        default:
          jj_la1[66] = jj_gen;
          ;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case CHAR_ENTITY_REF:
        case NUMERIC_CHAR_REF:
          CharRef();
          break;
        case TAB:
        case ESCAPED_CHAR:
        case CHAR_SEQUENCE:
        case DIGITS:
        case AMPERSAND:
        case BACKSLASH:
        case BACKTICK:
        case BANG:
        case COMMENT_OPEN:
        case COMMENT_CLOSE:
        case COLON:
        case DOUBLE_QUOTE:
        case DOT:
        case EQ:
        case GT:
        case LBRACKET:
        case LPAREN:
        case LT:
        case MINUS:
        case PLUS:
        case RBRACKET:
        case RPAREN:
        case SHARP:
        case SINGLE_QUOTE:
        case SLASH:
          EmphasisText();
          break;
        case STAR:
          jj_consume_token(STAR);
                                                Text jjtn001 = new Text(JJTTEXT);
                                                boolean jjtc001 = true;
                                                jjtree.openNodeScope(jjtn001);
          try {
                                                jjtree.closeNodeScope(jjtn001, true);
                                                jjtc001 = false;
                                                jjtn001.append("*");
          } finally {
                                                if (jjtc001) {
                                                  jjtree.closeNodeScope(jjtn001, true);
                                                }
          }
          break;
        default:
          jj_la1[67] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        label_24:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case SPACE:
          case TAB:
          case CHAR_ENTITY_REF:
          case NUMERIC_CHAR_REF:
          case ESCAPED_CHAR:
          case CHAR_SEQUENCE:
          case DIGITS:
          case AMPERSAND:
          case BACKSLASH:
          case BACKTICK:
          case BANG:
          case COMMENT_OPEN:
          case COMMENT_CLOSE:
          case COLON:
          case DOUBLE_QUOTE:
          case DOT:
          case EQ:
          case GT:
          case LBRACKET:
          case LPAREN:
          case LT:
          case MINUS:
          case PLUS:
          case RBRACKET:
          case RPAREN:
          case SHARP:
          case SINGLE_QUOTE:
          case SLASH:
          case STAR:
            ;
            break;
          default:
            jj_la1[68] = jj_gen;
            break label_24;
          }
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case SPACE:
            jj_consume_token(SPACE);
                        Text jjtn002 = new Text(JJTTEXT);
                        boolean jjtc002 = true;
                        jjtree.openNodeScope(jjtn002);
            try {
                        jjtree.closeNodeScope(jjtn002, true);
                        jjtc002 = false;
                        jjtn002.append(" ");
            } finally {
                        if (jjtc002) {
                          jjtree.closeNodeScope(jjtn002, true);
                        }
            }
            break;
          default:
            jj_la1[69] = jj_gen;
            ;
          }
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case CHAR_ENTITY_REF:
          case NUMERIC_CHAR_REF:
            CharRef();
            break;
          case TAB:
          case ESCAPED_CHAR:
          case CHAR_SEQUENCE:
          case DIGITS:
          case AMPERSAND:
          case BACKSLASH:
          case BACKTICK:
          case BANG:
          case COMMENT_OPEN:
          case COMMENT_CLOSE:
          case COLON:
          case DOUBLE_QUOTE:
          case DOT:
          case EQ:
          case GT:
          case LBRACKET:
          case LPAREN:
          case LT:
          case MINUS:
          case PLUS:
          case RBRACKET:
          case RPAREN:
          case SHARP:
          case SINGLE_QUOTE:
          case SLASH:
            EmphasisText();
            break;
          case STAR:
            jj_consume_token(STAR);
                                                    Text jjtn003 = new Text(JJTTEXT);
                                                    boolean jjtc003 = true;
                                                    jjtree.openNodeScope(jjtn003);
            try {
                                                    jjtree.closeNodeScope(jjtn003, true);
                                                    jjtc003 = false;
                                                    jjtn003.append("*");
            } finally {
                                                    if (jjtc003) {
                                                      jjtree.closeNodeScope(jjtn003, true);
                                                    }
            }
            break;
          default:
            jj_la1[70] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        jj_consume_token(UNDERSCORE);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case UNDERSCORE:
          jj_consume_token(UNDERSCORE);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case UNDERSCORE:
            jj_consume_token(UNDERSCORE);
            break;
          default:
            jj_la1[71] = jj_gen;
            ;
          }
          break;
        default:
          jj_la1[72] = jj_gen;
          ;
        }
        break;
      case STAR:
        jj_consume_token(STAR);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case STAR:
          jj_consume_token(STAR);
                          flag = 2;
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case STAR:
            jj_consume_token(STAR);
                                                 flag = 3;
            break;
          default:
            jj_la1[73] = jj_gen;
            ;
          }
          break;
        default:
          jj_la1[74] = jj_gen;
          ;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case CHAR_ENTITY_REF:
        case NUMERIC_CHAR_REF:
          CharRef();
          break;
        case TAB:
        case ESCAPED_CHAR:
        case CHAR_SEQUENCE:
        case DIGITS:
        case AMPERSAND:
        case BACKSLASH:
        case BACKTICK:
        case BANG:
        case COMMENT_OPEN:
        case COMMENT_CLOSE:
        case COLON:
        case DOUBLE_QUOTE:
        case DOT:
        case EQ:
        case GT:
        case LBRACKET:
        case LPAREN:
        case LT:
        case MINUS:
        case PLUS:
        case RBRACKET:
        case RPAREN:
        case SHARP:
        case SINGLE_QUOTE:
        case SLASH:
          EmphasisText();
          break;
        case UNDERSCORE:
          jj_consume_token(UNDERSCORE);
                                                      Text jjtn004 = new Text(JJTTEXT);
                                                      boolean jjtc004 = true;
                                                      jjtree.openNodeScope(jjtn004);
          try {
                                                      jjtree.closeNodeScope(jjtn004, true);
                                                      jjtc004 = false;
                                                      jjtn004.append("_");
          } finally {
                                                      if (jjtc004) {
                                                        jjtree.closeNodeScope(jjtn004, true);
                                                      }
          }
          break;
        default:
          jj_la1[75] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        label_25:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case SPACE:
          case TAB:
          case CHAR_ENTITY_REF:
          case NUMERIC_CHAR_REF:
          case ESCAPED_CHAR:
          case CHAR_SEQUENCE:
          case DIGITS:
          case AMPERSAND:
          case BACKSLASH:
          case BACKTICK:
          case BANG:
          case COMMENT_OPEN:
          case COMMENT_CLOSE:
          case COLON:
          case DOUBLE_QUOTE:
          case DOT:
          case EQ:
          case GT:
          case LBRACKET:
          case LPAREN:
          case LT:
          case MINUS:
          case PLUS:
          case RBRACKET:
          case RPAREN:
          case SHARP:
          case SINGLE_QUOTE:
          case SLASH:
          case UNDERSCORE:
            ;
            break;
          default:
            jj_la1[76] = jj_gen;
            break label_25;
          }
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case SPACE:
            jj_consume_token(SPACE);
                        Text jjtn005 = new Text(JJTTEXT);
                        boolean jjtc005 = true;
                        jjtree.openNodeScope(jjtn005);
            try {
                        jjtree.closeNodeScope(jjtn005, true);
                        jjtc005 = false;
                        jjtn005.append(" ");
            } finally {
                        if (jjtc005) {
                          jjtree.closeNodeScope(jjtn005, true);
                        }
            }
            break;
          default:
            jj_la1[77] = jj_gen;
            ;
          }
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case CHAR_ENTITY_REF:
          case NUMERIC_CHAR_REF:
            CharRef();
            break;
          case TAB:
          case ESCAPED_CHAR:
          case CHAR_SEQUENCE:
          case DIGITS:
          case AMPERSAND:
          case BACKSLASH:
          case BACKTICK:
          case BANG:
          case COMMENT_OPEN:
          case COMMENT_CLOSE:
          case COLON:
          case DOUBLE_QUOTE:
          case DOT:
          case EQ:
          case GT:
          case LBRACKET:
          case LPAREN:
          case LT:
          case MINUS:
          case PLUS:
          case RBRACKET:
          case RPAREN:
          case SHARP:
          case SINGLE_QUOTE:
          case SLASH:
            EmphasisText();
            break;
          case UNDERSCORE:
            jj_consume_token(UNDERSCORE);
                                                          Text jjtn006 = new Text(JJTTEXT);
                                                          boolean jjtc006 = true;
                                                          jjtree.openNodeScope(jjtn006);
            try {
                                                          jjtree.closeNodeScope(jjtn006, true);
                                                          jjtc006 = false;
                                                          jjtn006.append("_");
            } finally {
                                                          if (jjtc006) {
                                                            jjtree.closeNodeScope(jjtn006, true);
                                                          }
            }
            break;
          default:
            jj_la1[78] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        jj_consume_token(STAR);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case STAR:
          jj_consume_token(STAR);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case STAR:
            jj_consume_token(STAR);
            break;
          default:
            jj_la1[79] = jj_gen;
            ;
          }
          break;
        default:
          jj_la1[80] = jj_gen;
          ;
        }
        break;
      default:
        jj_la1[81] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
        jjtree.closeNodeScope(jjtn000, true);
        jjtc000 = false;
        if (flag == 2) {
            jjtn000.makeBold();
        } else if (flag == 3) {
            jjtn000.makeItalicAndBold();
        }
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
  }

  final public void Comment() throws ParseException {
                           /*@bgen(jjtree) Comment */
    Comment jjtn000 = new Comment(JJTCOMMENT);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);StringBuilder buff = new StringBuilder();
    String v;
    Token t;
    try {
      jj_consume_token(COMMENT_OPEN);
      label_26:
      while (true) {
        if (jj_2_38(1)) {
          ;
        } else {
          break label_26;
        }
        if (getToken(1).none(EOL,COMMENT_CLOSE)) {
          v = Anything();
                                                                            buff.append(v);
        } else {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case EOL:
            t = jj_consume_token(EOL);
                      buff.append(t.image);
            break;
          default:
            jj_la1[82] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
      }
      jjtn000.setText(buff.toString());
      jj_consume_token(COMMENT_CLOSE);
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
  }

  final public void InlineURL() throws ParseException {
                               /*@bgen(jjtree) InlineUrl */
    InlineUrl jjtn000 = new InlineUrl(JJTINLINEURL);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);Token t;
    StringBuilder buff = new StringBuilder();
    try {
      jj_consume_token(LT);
      t = jj_consume_token(CHAR_SEQUENCE);
                          buff.append(t.image);
      jj_consume_token(COLON);
          buff.append(":");
      label_27:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case SLASH:
          ;
          break;
        default:
          jj_la1[83] = jj_gen;
          break label_27;
        }
        jj_consume_token(SLASH);
            buff.append("/");
      }
      t = jj_consume_token(CHAR_SEQUENCE);
                          buff.append(t.image);
      label_28:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case CHAR_SEQUENCE:
        case DIGITS:
        case AMPERSAND:
        case BACKSLASH:
        case COLON:
        case DOT:
        case EQ:
        case LBRACKET:
        case LPAREN:
        case MINUS:
        case RBRACKET:
        case RPAREN:
        case SHARP:
        case SLASH:
        case UNDERSCORE:
          ;
          break;
        default:
          jj_la1[84] = jj_gen;
          break label_28;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case CHAR_SEQUENCE:
          t = jj_consume_token(CHAR_SEQUENCE);
          break;
        case DIGITS:
          t = jj_consume_token(DIGITS);
          break;
        case AMPERSAND:
          t = jj_consume_token(AMPERSAND);
          break;
        case BACKSLASH:
          t = jj_consume_token(BACKSLASH);
          break;
        case COLON:
          t = jj_consume_token(COLON);
          break;
        case DOT:
          t = jj_consume_token(DOT);
          break;
        case EQ:
          t = jj_consume_token(EQ);
          break;
        case LBRACKET:
          t = jj_consume_token(LBRACKET);
          break;
        case LPAREN:
          t = jj_consume_token(LPAREN);
          break;
        case MINUS:
          t = jj_consume_token(MINUS);
          break;
        case RBRACKET:
          t = jj_consume_token(RBRACKET);
          break;
        case RPAREN:
          t = jj_consume_token(RPAREN);
          break;
        case SHARP:
          t = jj_consume_token(SHARP);
          break;
        case SLASH:
          t = jj_consume_token(SLASH);
          break;
        case UNDERSCORE:
          t = jj_consume_token(UNDERSCORE);
          break;
        default:
          jj_la1[85] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
            buff.append(t.image);
      }
      jj_consume_token(GT);
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.setUrl(buff.toString());
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
  }

  final public void Link() throws ParseException {
                     /*@bgen(jjtree) Link */
    Link jjtn000 = new Link(JJTLINK);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);String text, reference;
    Resource resource = null;
    try {
      jj_consume_token(LBRACKET);
      if (jj_2_40(2147483647)) {
        LinkBodyText();
        jj_consume_token(RBRACKET);
        if (jj_2_39(2147483647)) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case LPAREN:
            resource = LinkResource();
                  jjtn000.setResource(resource);
            break;
          case SPACE:
          case EOL:
          case LBRACKET:
            reference = LinkReference(jjtn000);
                  jjtn000.setReference(reference);
            break;
          default:
            jj_la1[86] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        } else {
          ;
        }
      } else if (jj_2_41(1)) {
        LinkBodyComposite();
        jj_consume_token(RBRACKET);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LPAREN:
          resource = LinkResource();
              jjtree.closeNodeScope(jjtn000, true);
              jjtc000 = false;
              jjtn000.setResource(resource);
          break;
        case SPACE:
        case EOL:
        case LBRACKET:
          reference = LinkReference(jjtn000);
              jjtree.closeNodeScope(jjtn000, true);
              jjtc000 = false;
              jjtn000.setReference(reference);
          break;
        default:
          jj_la1[87] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
  }

  final public void LinkBodyText() throws ParseException {
    StringBuilder buff;
    label_29:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CHAR_ENTITY_REF:
      case NUMERIC_CHAR_REF:
        CharRef();
        break;
      case SPACE:
      case TAB:
      case EOL:
      case ESCAPED_CHAR:
      case CHAR_SEQUENCE:
      case DIGITS:
      case AMPERSAND:
      case BACKSLASH:
      case BACKTICK:
      case BANG:
      case COMMENT_OPEN:
      case COMMENT_CLOSE:
      case COLON:
      case DOUBLE_QUOTE:
      case DOT:
      case EQ:
      case GT:
      case LPAREN:
      case LT:
      case MINUS:
      case PLUS:
      case RPAREN:
      case SHARP:
      case SINGLE_QUOTE:
      case SLASH:
      case STAR:
      case UNDERSCORE:
            buff = new StringBuilder();
        LinkText(buff);
                                                           Text jjtn001 = new Text(JJTTEXT);
                                                           boolean jjtc001 = true;
                                                           jjtree.openNodeScope(jjtn001);
        try {
                                                           jjtree.closeNodeScope(jjtn001, true);
                                                           jjtc001 = false;
                                                           jjtn001.append(buff.toString());
        } finally {
                                                           if (jjtc001) {
                                                             jjtree.closeNodeScope(jjtn001, true);
                                                           }
        }
        break;
      default:
        jj_la1[88] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SPACE:
      case TAB:
      case EOL:
      case CHAR_ENTITY_REF:
      case NUMERIC_CHAR_REF:
      case ESCAPED_CHAR:
      case CHAR_SEQUENCE:
      case DIGITS:
      case AMPERSAND:
      case BACKSLASH:
      case BACKTICK:
      case BANG:
      case COMMENT_OPEN:
      case COMMENT_CLOSE:
      case COLON:
      case DOUBLE_QUOTE:
      case DOT:
      case EQ:
      case GT:
      case LPAREN:
      case LT:
      case MINUS:
      case PLUS:
      case RPAREN:
      case SHARP:
      case SINGLE_QUOTE:
      case SLASH:
      case STAR:
      case UNDERSCORE:
        ;
        break;
      default:
        jj_la1[89] = jj_gen;
        break label_29;
      }
    }
  }

  final public void LinkBodyComposite() throws ParseException {
    StringBuilder buff = new StringBuilder();
    label_30:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CHAR_ENTITY_REF:
      case NUMERIC_CHAR_REF:
        CharRef();
        break;
      default:
        jj_la1[91] = jj_gen;
        if (CodeSpanLookahead()) {
          CodeSpan();
        } else if (jj_2_42(2147483647)) {
          Emphasis();
        } else if (jj_2_43(2147483647)) {
          InlineURL();
        } else if (jj_2_44(2147483647)) {
          Image();
        } else {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case LBRACKET:
              buff = new StringBuilder("[");
            jj_consume_token(LBRACKET);
            label_31:
            while (true) {
              switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
              case SPACE:
              case TAB:
              case EOL:
              case ESCAPED_CHAR:
              case CHAR_SEQUENCE:
              case DIGITS:
              case AMPERSAND:
              case BACKSLASH:
              case BACKTICK:
              case BANG:
              case COMMENT_OPEN:
              case COMMENT_CLOSE:
              case COLON:
              case DOUBLE_QUOTE:
              case DOT:
              case EQ:
              case GT:
              case LPAREN:
              case LT:
              case MINUS:
              case PLUS:
              case RPAREN:
              case SHARP:
              case SINGLE_QUOTE:
              case SLASH:
              case STAR:
              case UNDERSCORE:
                ;
                break;
              default:
                jj_la1[90] = jj_gen;
                break label_31;
              }
              LinkText(buff);
            }
            jj_consume_token(RBRACKET);
              Text jjtn001 = new Text(JJTTEXT);
              boolean jjtc001 = true;
              jjtree.openNodeScope(jjtn001);
            try {
              jjtree.closeNodeScope(jjtn001, true);
              jjtc001 = false;
              buff.append("]"); jjtn001.append(buff.toString());
            } finally {
              if (jjtc001) {
                jjtree.closeNodeScope(jjtn001, true);
              }
            }
            break;
          case SPACE:
          case TAB:
          case EOL:
          case ESCAPED_CHAR:
          case CHAR_SEQUENCE:
          case DIGITS:
          case AMPERSAND:
          case BACKSLASH:
          case BACKTICK:
          case BANG:
          case COMMENT_OPEN:
          case COMMENT_CLOSE:
          case COLON:
          case DOUBLE_QUOTE:
          case DOT:
          case EQ:
          case GT:
          case LPAREN:
          case LT:
          case MINUS:
          case PLUS:
          case RPAREN:
          case SHARP:
          case SINGLE_QUOTE:
          case SLASH:
          case STAR:
          case UNDERSCORE:
              buff = new StringBuilder();
            LinkText(buff);
              Text jjtn002 = new Text(JJTTEXT);
              boolean jjtc002 = true;
              jjtree.openNodeScope(jjtn002);
            try {
              jjtree.closeNodeScope(jjtn002, true);
              jjtc002 = false;
              jjtn002.append(buff.toString());
            } finally {
              if (jjtc002) {
                jjtree.closeNodeScope(jjtn002, true);
              }
            }
            break;
          default:
            jj_la1[92] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
      }
      if (jj_2_45(1)) {
        ;
      } else {
        break label_30;
      }
    }
  }

  final public String LinkReference(Link node) throws ParseException {
    String reference = "";
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SPACE:
      jj_consume_token(SPACE);
                node.setWhitespaceAtMiddle();
      break;
    default:
      jj_la1[93] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EOL:
      jj_consume_token(EOL);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SPACE:
      case TAB:
        Whitespace();
        break;
      default:
        jj_la1[94] = jj_gen;
        ;
      }
      break;
    default:
      jj_la1[95] = jj_gen;
      ;
    }
    jj_consume_token(LBRACKET);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SPACE:
    case TAB:
    case CHAR_SEQUENCE:
    case DIGITS:
    case AMPERSAND:
    case BACKSLASH:
    case BACKTICK:
    case BANG:
    case COLON:
    case DOT:
    case EQ:
    case GT:
    case LBRACKET:
    case LPAREN:
    case LT:
    case MINUS:
    case PLUS:
    case RPAREN:
    case SHARP:
    case SINGLE_QUOTE:
    case SLASH:
    case STAR:
    case UNDERSCORE:
      reference = refname();
      break;
    default:
      jj_la1[96] = jj_gen;
      ;
    }
    jj_consume_token(RBRACKET);
      {if (true) return reference;}
    throw new Error("Missing return statement in function");
  }

  final public Resource LinkResource() throws ParseException {
    Resource resource = null;
    jj_consume_token(LPAREN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SPACE:
    case TAB:
      Whitespace();
      break;
    default:
      jj_la1[97] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SPACE:
    case CHAR_SEQUENCE:
    case DIGITS:
    case AMPERSAND:
    case BACKSLASH:
    case BANG:
    case COLON:
    case DOT:
    case EQ:
    case LBRACKET:
    case LPAREN:
    case LT:
    case MINUS:
    case PLUS:
    case RBRACKET:
    case SHARP:
    case SLASH:
    case UNDERSCORE:
      resource = Resource();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SPACE:
      case TAB:
        Whitespace();
        break;
      default:
        jj_la1[98] = jj_gen;
        ;
      }
      break;
    default:
      jj_la1[99] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
      {if (true) return resource;}
    throw new Error("Missing return statement in function");
  }

  final public void LinkText(StringBuilder buff) throws ParseException {
    Token t;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CHAR_SEQUENCE:
      t = jj_consume_token(CHAR_SEQUENCE);
      break;
    case SPACE:
      t = jj_consume_token(SPACE);
      break;
    case DIGITS:
      t = jj_consume_token(DIGITS);
      break;
    case AMPERSAND:
      t = jj_consume_token(AMPERSAND);
      break;
    case BACKSLASH:
      t = jj_consume_token(BACKSLASH);
      break;
    case BACKTICK:
      t = jj_consume_token(BACKTICK);
      break;
    case BANG:
      t = jj_consume_token(BANG);
      break;
    case COLON:
      t = jj_consume_token(COLON);
      break;
    case COMMENT_CLOSE:
      t = jj_consume_token(COMMENT_CLOSE);
      break;
    case COMMENT_OPEN:
      t = jj_consume_token(COMMENT_OPEN);
      break;
    case DOUBLE_QUOTE:
      t = jj_consume_token(DOUBLE_QUOTE);
      break;
    case DOT:
      t = jj_consume_token(DOT);
      break;
    case EOL:
      t = jj_consume_token(EOL);
      break;
    case EQ:
      t = jj_consume_token(EQ);
      break;
    case ESCAPED_CHAR:
      t = jj_consume_token(ESCAPED_CHAR);
      break;
    case GT:
      t = jj_consume_token(GT);
      break;
    case LPAREN:
      t = jj_consume_token(LPAREN);
      break;
    case LT:
      t = jj_consume_token(LT);
      break;
    case MINUS:
      t = jj_consume_token(MINUS);
      break;
    case PLUS:
      t = jj_consume_token(PLUS);
      break;
    case RPAREN:
      t = jj_consume_token(RPAREN);
      break;
    case SHARP:
      t = jj_consume_token(SHARP);
      break;
    case SINGLE_QUOTE:
      t = jj_consume_token(SINGLE_QUOTE);
      break;
    case SLASH:
      t = jj_consume_token(SLASH);
      break;
    case STAR:
      t = jj_consume_token(STAR);
      break;
    case TAB:
      t = jj_consume_token(TAB);
      break;
    case UNDERSCORE:
      t = jj_consume_token(UNDERSCORE);
      break;
    default:
      jj_la1[100] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        buff.append(t.image);
  }

  final public void Image() throws ParseException {
                       /*@bgen(jjtree) Image */
    Image jjtn000 = new Image(JJTIMAGE);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);String text = null;
    String reference;
    Resource resource = null;
    try {
      jj_consume_token(BANG);
      jj_consume_token(LBRACKET);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SPACE:
      case TAB:
      case CHAR_SEQUENCE:
      case DIGITS:
      case AMPERSAND:
      case BACKSLASH:
      case BACKTICK:
      case BANG:
      case COLON:
      case DOT:
      case EQ:
      case GT:
      case LBRACKET:
      case LPAREN:
      case LT:
      case MINUS:
      case PLUS:
      case RPAREN:
      case SHARP:
      case SINGLE_QUOTE:
      case SLASH:
      case STAR:
      case UNDERSCORE:
        text = refname();
        break;
      default:
        jj_la1[101] = jj_gen;
        ;
      }
                            jjtn000.setText(text);
      jj_consume_token(RBRACKET);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SPACE:
      case LBRACKET:
      case LPAREN:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case SPACE:
        case LBRACKET:
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case SPACE:
            jj_consume_token(SPACE);
            break;
          default:
            jj_la1[102] = jj_gen;
            ;
          }
          jj_consume_token(LBRACKET);
          reference = refname();
                                jjtn000.setReference(reference);
          jj_consume_token(RBRACKET);
          break;
        case LPAREN:
          jj_consume_token(LPAREN);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case SPACE:
          case TAB:
            Whitespace();
            break;
          default:
            jj_la1[103] = jj_gen;
            ;
          }
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case SPACE:
          case CHAR_SEQUENCE:
          case DIGITS:
          case AMPERSAND:
          case BACKSLASH:
          case BANG:
          case COLON:
          case DOT:
          case EQ:
          case LBRACKET:
          case LPAREN:
          case LT:
          case MINUS:
          case PLUS:
          case RBRACKET:
          case SHARP:
          case SLASH:
          case UNDERSCORE:
            resource = Resource();
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case SPACE:
            case TAB:
              Whitespace();
              break;
            default:
              jj_la1[104] = jj_gen;
              ;
            }
            break;
          default:
            jj_la1[105] = jj_gen;
            ;
          }
              jjtn000.setResource(resource);
          jj_consume_token(RPAREN);
          break;
        default:
          jj_la1[106] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[107] = jj_gen;
        ;
      }
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
  }

  final public void Tag() throws ParseException {
                   /*@bgen(jjtree) Tag */
    Tag jjtn000 = new Tag(JJTTAG);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);StringBuilder buff = new StringBuilder();
    try {
      jj_consume_token(LT);
      TagName(buff);
                        jjtn000.setName(buff.toString());
      if (jj_2_46(2147483647)) {
        TagAttributeList();
      } else {
        ;
      }
      label_32:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case SPACE:
          ;
          break;
        default:
          jj_la1[108] = jj_gen;
          break label_32;
        }
        jj_consume_token(SPACE);
      }
      if (jj_2_48(2)) {
        jj_consume_token(SLASH);
        jj_consume_token(GT);
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case GT:
          try {
            jj_consume_token(GT);
            if (jj_2_47(2)) {
              TagBody();
            } else {
              ;
            }
            jj_consume_token(LT);
            jj_consume_token(SLASH);
            TagName(buff);
            label_33:
            while (true) {
              switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
              case SPACE:
                ;
                break;
              default:
                jj_la1[109] = jj_gen;
                break label_33;
              }
              jj_consume_token(SPACE);
            }
            jj_consume_token(GT);
          } catch (ParseException e) {

          }
          break;
        default:
          jj_la1[110] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
  }

  final public void TagName(StringBuilder buff) throws ParseException {
    Token t;
    t = jj_consume_token(CHAR_SEQUENCE);
                          buff.append(t.image);
    label_34:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CHAR_SEQUENCE:
      case DIGITS:
        ;
        break;
      default:
        jj_la1[111] = jj_gen;
        break label_34;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DIGITS:
        t = jj_consume_token(DIGITS);
        break;
      case CHAR_SEQUENCE:
        t = jj_consume_token(CHAR_SEQUENCE);
        break;
      default:
        jj_la1[112] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
            buff.append(t.image);
    }
  }

  final public void TagAttributeList() throws ParseException {
                                             /*@bgen(jjtree) TagAttributeList */
  TagAttributeList jjtn000 = new TagAttributeList(JJTTAGATTRIBUTELIST);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      label_35:
      while (true) {
        label_36:
        while (true) {
          jj_consume_token(SPACE);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case SPACE:
            ;
            break;
          default:
            jj_la1[113] = jj_gen;
            break label_36;
          }
        }
        TagAttribute();
        if (jj_2_49(2147483647)) {
          ;
        } else {
          break label_35;
        }
      }
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
  }

  final public void TagBody() throws ParseException {
                           /*@bgen(jjtree) TagBody */
  TagBody jjtn000 = new TagBody(JJTTAGBODY);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      label_37:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LT:
          Tag();
          break;
        case SPACE:
        case TAB:
        case EOL:
        case CHAR_ENTITY_REF:
        case NUMERIC_CHAR_REF:
        case ESCAPED_CHAR:
        case CHAR_SEQUENCE:
        case DIGITS:
        case AMPERSAND:
        case BACKSLASH:
        case BACKTICK:
        case BANG:
        case COMMENT_OPEN:
        case COMMENT_CLOSE:
        case COLON:
        case DOUBLE_QUOTE:
        case DOT:
        case EQ:
        case GT:
        case LBRACKET:
        case LPAREN:
        case MINUS:
        case PLUS:
        case RBRACKET:
        case RPAREN:
        case SHARP:
        case SINGLE_QUOTE:
        case SLASH:
        case STAR:
        case UNDERSCORE:
          TextNode();
          break;
        default:
          jj_la1[114] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        if (jj_2_50(2)) {
          ;
        } else {
          break label_37;
        }
      }
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
  }

  final public void TagAttribute() throws ParseException {
                                     /*@bgen(jjtree) TagAttribute */
    TagAttribute jjtn000 = new TagAttribute(JJTTAGATTRIBUTE);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);StringBuilder buff = new StringBuilder();
    Token t;
    try {
      TagAttributeName(buff);
      jj_consume_token(EQ);
                                 jjtn000.setName(buff.toString()); buff = new StringBuilder();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DOUBLE_QUOTE:
        jj_consume_token(DOUBLE_QUOTE);
        label_38:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case SPACE:
          case TAB:
          case EOL:
          case CHAR_ENTITY_REF:
          case NUMERIC_CHAR_REF:
          case ESCAPED_CHAR:
          case CHAR_SEQUENCE:
          case DIGITS:
          case AMPERSAND:
          case BACKSLASH:
          case BACKTICK:
          case BANG:
          case COLON:
          case DOT:
          case EQ:
          case GT:
          case LPAREN:
          case MINUS:
          case PLUS:
          case RPAREN:
          case SHARP:
          case SINGLE_QUOTE:
          case SLASH:
          case STAR:
          case UNDERSCORE:
            ;
            break;
          default:
            jj_la1[115] = jj_gen;
            break label_38;
          }
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case SPACE:
          case TAB:
          case EOL:
          case CHAR_ENTITY_REF:
          case NUMERIC_CHAR_REF:
          case ESCAPED_CHAR:
          case CHAR_SEQUENCE:
          case DIGITS:
          case AMPERSAND:
          case BACKSLASH:
          case BACKTICK:
          case BANG:
          case COLON:
          case DOT:
          case EQ:
          case GT:
          case LPAREN:
          case MINUS:
          case PLUS:
          case RPAREN:
          case SHARP:
          case SLASH:
          case STAR:
          case UNDERSCORE:
            TagAttributeText(buff);
            break;
          case SINGLE_QUOTE:
            t = jj_consume_token(SINGLE_QUOTE);
                            buff.append(t.image);
            break;
          default:
            jj_la1[116] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        jj_consume_token(DOUBLE_QUOTE);
        break;
      case SINGLE_QUOTE:
        jj_consume_token(SINGLE_QUOTE);
        label_39:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case SPACE:
          case TAB:
          case EOL:
          case CHAR_ENTITY_REF:
          case NUMERIC_CHAR_REF:
          case ESCAPED_CHAR:
          case CHAR_SEQUENCE:
          case DIGITS:
          case AMPERSAND:
          case BACKSLASH:
          case BACKTICK:
          case BANG:
          case COLON:
          case DOUBLE_QUOTE:
          case DOT:
          case EQ:
          case GT:
          case LPAREN:
          case MINUS:
          case PLUS:
          case RPAREN:
          case SHARP:
          case SLASH:
          case STAR:
          case UNDERSCORE:
            ;
            break;
          default:
            jj_la1[117] = jj_gen;
            break label_39;
          }
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case SPACE:
          case TAB:
          case EOL:
          case CHAR_ENTITY_REF:
          case NUMERIC_CHAR_REF:
          case ESCAPED_CHAR:
          case CHAR_SEQUENCE:
          case DIGITS:
          case AMPERSAND:
          case BACKSLASH:
          case BACKTICK:
          case BANG:
          case COLON:
          case DOT:
          case EQ:
          case GT:
          case LPAREN:
          case MINUS:
          case PLUS:
          case RPAREN:
          case SHARP:
          case SLASH:
          case STAR:
          case UNDERSCORE:
            TagAttributeText(buff);
            break;
          case DOUBLE_QUOTE:
            t = jj_consume_token(DOUBLE_QUOTE);
                             buff.append(t.image);
            break;
          default:
            jj_la1[118] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        jj_consume_token(SINGLE_QUOTE);
        break;
      default:
        jj_la1[119] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
        jjtn000.setValue(buff.toString());
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
  }

  final public void TagAttributeName(StringBuilder buff) throws ParseException {
    Token t;
    t = jj_consume_token(CHAR_SEQUENCE);
                          buff.append(t.image);
    label_40:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CHAR_SEQUENCE:
      case DIGITS:
      case MINUS:
      case UNDERSCORE:
        ;
        break;
      default:
        jj_la1[120] = jj_gen;
        break label_40;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DIGITS:
        t = jj_consume_token(DIGITS);
        break;
      case CHAR_SEQUENCE:
        t = jj_consume_token(CHAR_SEQUENCE);
        break;
      case MINUS:
        t = jj_consume_token(MINUS);
        break;
      case UNDERSCORE:
        t = jj_consume_token(UNDERSCORE);
        break;
      default:
        jj_la1[121] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
            buff.append(t.image);
    }
  }

  final public void TagOpen() throws ParseException {
    jj_consume_token(LT);
    jj_consume_token(CHAR_SEQUENCE);
    label_41:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CHAR_SEQUENCE:
      case DIGITS:
        ;
        break;
      default:
        jj_la1[122] = jj_gen;
        break label_41;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DIGITS:
        jj_consume_token(DIGITS);
        break;
      case CHAR_SEQUENCE:
        jj_consume_token(CHAR_SEQUENCE);
        break;
      default:
        jj_la1[123] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    label_42:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SPACE:
        ;
        break;
      default:
        jj_la1[124] = jj_gen;
        break label_42;
      }
      label_43:
      while (true) {
        jj_consume_token(SPACE);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case SPACE:
          ;
          break;
        default:
          jj_la1[125] = jj_gen;
          break label_43;
        }
      }
      TagAttribute();
    }
    label_44:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SPACE:
        ;
        break;
      default:
        jj_la1[126] = jj_gen;
        break label_44;
      }
      jj_consume_token(SPACE);
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SLASH:
      jj_consume_token(SLASH);
      break;
    default:
      jj_la1[127] = jj_gen;
      ;
    }
    jj_consume_token(GT);
  }

  final public void Markup() throws ParseException {
    StringBuilder buff = new StringBuilder();
    int ch = 0;
    jj_consume_token(LT);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CHAR_SEQUENCE:
      TagName(buff);
      if (jj_2_51(2147483647)) {
        TagAttributeList();
                                                                         ch++;
      } else {
        ;
      }
      label_45:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case SPACE:
          ;
          break;
        default:
          jj_la1[128] = jj_gen;
          break label_45;
        }
        jj_consume_token(SPACE);
      }
      if (jj_2_52(2)) {
        jj_consume_token(SLASH);
        jj_consume_token(GT);
                      EmptyTag jjtn001 = new EmptyTag(JJTEMPTYTAG);
                      boolean jjtc001 = true;
                      jjtree.openNodeScope(jjtn001);
        try {
                      jjtree.closeNodeScope(jjtn001,  ch);
                      jjtc001 = false;
                      jjtn001.setName(buff.toString());
        } finally {
                      if (jjtc001) {
                        jjtree.closeNodeScope(jjtn001,  ch);
                      }
        }
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case GT:
          jj_consume_token(GT);
                  StartTag jjtn002 = new StartTag(JJTSTARTTAG);
                  boolean jjtc002 = true;
                  jjtree.openNodeScope(jjtn002);
          try {
                  jjtree.closeNodeScope(jjtn002,  ch);
                  jjtc002 = false;
                  jjtn002.setName(buff.toString());
          } finally {
                  if (jjtc002) {
                    jjtree.closeNodeScope(jjtn002,  ch);
                  }
          }
          break;
        default:
          jj_la1[129] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
    case SLASH:
      jj_consume_token(SLASH);
      TagName(buff);
      label_46:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case SPACE:
          ;
          break;
        default:
          jj_la1[130] = jj_gen;
          break label_46;
        }
        jj_consume_token(SPACE);
      }
      jj_consume_token(GT);
                                               EndTag jjtn003 = new EndTag(JJTENDTAG);
                                               boolean jjtc003 = true;
                                               jjtree.openNodeScope(jjtn003);
      try {
                                               jjtree.closeNodeScope(jjtn003, true);
                                               jjtc003 = false;
                                               jjtn003.setName(buff.toString());
      } finally {
                                               if (jjtc003) {
                                                 jjtree.closeNodeScope(jjtn003, true);
                                               }
      }
      break;
    default:
      jj_la1[131] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public String refname() throws ParseException {
    Token t;
    StringBuilder buff = new StringBuilder();
    label_47:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CHAR_SEQUENCE:
        t = jj_consume_token(CHAR_SEQUENCE);
        break;
      case SPACE:
        t = jj_consume_token(SPACE);
        break;
      case DIGITS:
        t = jj_consume_token(DIGITS);
        break;
      case AMPERSAND:
        t = jj_consume_token(AMPERSAND);
        break;
      case BACKSLASH:
        t = jj_consume_token(BACKSLASH);
        break;
      case BACKTICK:
        t = jj_consume_token(BACKTICK);
        break;
      case BANG:
        t = jj_consume_token(BANG);
        break;
      case COLON:
        t = jj_consume_token(COLON);
        break;
      case DOT:
        t = jj_consume_token(DOT);
        break;
      case EQ:
        t = jj_consume_token(EQ);
        break;
      case GT:
        t = jj_consume_token(GT);
        break;
      case LBRACKET:
        t = jj_consume_token(LBRACKET);
        break;
      case LPAREN:
        t = jj_consume_token(LPAREN);
        break;
      case LT:
        t = jj_consume_token(LT);
        break;
      case MINUS:
        t = jj_consume_token(MINUS);
        break;
      case PLUS:
        t = jj_consume_token(PLUS);
        break;
      case RPAREN:
        t = jj_consume_token(RPAREN);
        break;
      case SHARP:
        t = jj_consume_token(SHARP);
        break;
      case SINGLE_QUOTE:
        t = jj_consume_token(SINGLE_QUOTE);
        break;
      case SLASH:
        t = jj_consume_token(SLASH);
        break;
      case STAR:
        t = jj_consume_token(STAR);
        break;
      case TAB:
        t = jj_consume_token(TAB);
        break;
      case UNDERSCORE:
        t = jj_consume_token(UNDERSCORE);
        break;
      default:
        jj_la1[132] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
            buff.append(t.image);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SPACE:
      case TAB:
      case CHAR_SEQUENCE:
      case DIGITS:
      case AMPERSAND:
      case BACKSLASH:
      case BACKTICK:
      case BANG:
      case COLON:
      case DOT:
      case EQ:
      case GT:
      case LBRACKET:
      case LPAREN:
      case LT:
      case MINUS:
      case PLUS:
      case RPAREN:
      case SHARP:
      case SINGLE_QUOTE:
      case SLASH:
      case STAR:
      case UNDERSCORE:
        ;
        break;
      default:
        jj_la1[133] = jj_gen;
        break label_47;
      }
    }
      {if (true) return buff.toString();}
    throw new Error("Missing return statement in function");
  }

  final public Resource Resource() throws ParseException {
    StringBuilder buff = new StringBuilder();
    String hint = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LT:
      jj_consume_token(LT);
      url(buff);
      jj_consume_token(GT);
      break;
    case SPACE:
    case CHAR_SEQUENCE:
    case DIGITS:
    case AMPERSAND:
    case BACKSLASH:
    case BANG:
    case COLON:
    case DOT:
    case EQ:
    case LBRACKET:
    case LPAREN:
    case MINUS:
    case PLUS:
    case RBRACKET:
    case SHARP:
    case SLASH:
    case UNDERSCORE:
      url(buff);
      break;
    default:
      jj_la1[134] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SPACE:
    case TAB:
      Whitespace();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DOUBLE_QUOTE:
      case SINGLE_QUOTE:
        hint = Title();
        break;
      default:
        jj_la1[135] = jj_gen;
        ;
      }
      break;
    default:
      jj_la1[136] = jj_gen;
      ;
    }
      {if (true) return new Resource(buff.toString(), hint);}
    throw new Error("Missing return statement in function");
  }

  final public void url(StringBuilder buff) throws ParseException {
    label_48:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPAREN:
        jj_consume_token(LPAREN);
                   buff.append("(");
        url(buff);
        jj_consume_token(RPAREN);
                                                            buff.append(")");
        break;
      case SPACE:
      case CHAR_SEQUENCE:
      case DIGITS:
      case AMPERSAND:
      case BACKSLASH:
      case BANG:
      case COLON:
      case DOT:
      case EQ:
      case LBRACKET:
      case MINUS:
      case PLUS:
      case RBRACKET:
      case SHARP:
      case SLASH:
      case UNDERSCORE:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case SPACE:
          jj_consume_token(SPACE);
                      buff.append(" ");
          break;
        default:
          jj_la1[137] = jj_gen;
          ;
        }
        UrlText(buff);
        break;
      default:
        jj_la1[138] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      if (jj_2_53(2147483647)) {
        ;
      } else {
        break label_48;
      }
    }
  }

  final public void UrlText(StringBuilder buff) throws ParseException {
    Token t;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CHAR_SEQUENCE:
      t = jj_consume_token(CHAR_SEQUENCE);
      break;
    case DIGITS:
      t = jj_consume_token(DIGITS);
      break;
    case AMPERSAND:
      t = jj_consume_token(AMPERSAND);
      break;
    case BACKSLASH:
      t = jj_consume_token(BACKSLASH);
      break;
    case BANG:
      t = jj_consume_token(BANG);
      break;
    case COLON:
      t = jj_consume_token(COLON);
      break;
    case DOT:
      t = jj_consume_token(DOT);
      break;
    case EQ:
      t = jj_consume_token(EQ);
      break;
    case LBRACKET:
      t = jj_consume_token(LBRACKET);
      break;
    case MINUS:
      t = jj_consume_token(MINUS);
      break;
    case PLUS:
      t = jj_consume_token(PLUS);
      break;
    case RBRACKET:
      t = jj_consume_token(RBRACKET);
      break;
    case SHARP:
      t = jj_consume_token(SHARP);
      break;
    case SLASH:
      t = jj_consume_token(SLASH);
      break;
    case UNDERSCORE:
      t = jj_consume_token(UNDERSCORE);
      break;
    default:
      jj_la1[139] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
            buff.append(t.image);
  }

  final public String Title() throws ParseException {
    StringBuilder buff = new StringBuilder();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DOUBLE_QUOTE:
      jj_consume_token(DOUBLE_QUOTE);
      label_49:
      while (true) {
        label_50:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case SPACE:
          case TAB:
          case CHAR_SEQUENCE:
          case DIGITS:
          case AMPERSAND:
          case BACKSLASH:
          case BACKTICK:
          case BANG:
          case COLON:
          case DOT:
          case EQ:
          case GT:
          case LBRACKET:
          case LPAREN:
          case LT:
          case MINUS:
          case PLUS:
          case RBRACKET:
          case RPAREN:
          case SHARP:
          case SINGLE_QUOTE:
          case SLASH:
          case STAR:
          case UNDERSCORE:
            ;
            break;
          default:
            jj_la1[140] = jj_gen;
            break label_50;
          }
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case SPACE:
          case TAB:
          case CHAR_SEQUENCE:
          case DIGITS:
          case AMPERSAND:
          case BACKSLASH:
          case BACKTICK:
          case BANG:
          case COLON:
          case DOT:
          case EQ:
          case GT:
          case LBRACKET:
          case LPAREN:
          case LT:
          case MINUS:
          case PLUS:
          case RBRACKET:
          case RPAREN:
          case SHARP:
          case SLASH:
          case STAR:
          case UNDERSCORE:
            TitleText(buff);
            break;
          case SINGLE_QUOTE:
            jj_consume_token(SINGLE_QUOTE);
                                                     buff.append("'");
            break;
          default:
            jj_la1[141] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        jj_consume_token(DOUBLE_QUOTE);
                       buff.append('"');
        if (jj_2_54(2147483647)) {
          ;
        } else {
          break label_49;
        }
      }
      break;
    case SINGLE_QUOTE:
      jj_consume_token(SINGLE_QUOTE);
      label_51:
      while (true) {
        label_52:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case SPACE:
          case TAB:
          case CHAR_SEQUENCE:
          case DIGITS:
          case AMPERSAND:
          case BACKSLASH:
          case BACKTICK:
          case BANG:
          case COLON:
          case DOUBLE_QUOTE:
          case DOT:
          case EQ:
          case GT:
          case LBRACKET:
          case LPAREN:
          case LT:
          case MINUS:
          case PLUS:
          case RBRACKET:
          case RPAREN:
          case SHARP:
          case SLASH:
          case STAR:
          case UNDERSCORE:
            ;
            break;
          default:
            jj_la1[142] = jj_gen;
            break label_52;
          }
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case SPACE:
          case TAB:
          case CHAR_SEQUENCE:
          case DIGITS:
          case AMPERSAND:
          case BACKSLASH:
          case BACKTICK:
          case BANG:
          case COLON:
          case DOT:
          case EQ:
          case GT:
          case LBRACKET:
          case LPAREN:
          case LT:
          case MINUS:
          case PLUS:
          case RBRACKET:
          case RPAREN:
          case SHARP:
          case SLASH:
          case STAR:
          case UNDERSCORE:
            TitleText(buff);
            break;
          case DOUBLE_QUOTE:
            jj_consume_token(DOUBLE_QUOTE);
                                                     buff.append('"');
            break;
          default:
            jj_la1[143] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        jj_consume_token(SINGLE_QUOTE);
                      buff.append("'");
        if (jj_2_55(2147483647)) {
          ;
        } else {
          break label_51;
        }
      }
      break;
    default:
      jj_la1[144] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        buff.deleteCharAt(buff.length() - 1);
        {if (true) return buff.toString();}
    throw new Error("Missing return statement in function");
  }

  final public void TitleText(StringBuilder buff) throws ParseException {
    Token t;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CHAR_SEQUENCE:
      t = jj_consume_token(CHAR_SEQUENCE);
      break;
    case SPACE:
      t = jj_consume_token(SPACE);
      break;
    case DIGITS:
      t = jj_consume_token(DIGITS);
      break;
    case AMPERSAND:
      t = jj_consume_token(AMPERSAND);
      break;
    case BACKSLASH:
      t = jj_consume_token(BACKSLASH);
      break;
    case BACKTICK:
      t = jj_consume_token(BACKTICK);
      break;
    case BANG:
      t = jj_consume_token(BANG);
      break;
    case COLON:
      t = jj_consume_token(COLON);
      break;
    case DOT:
      t = jj_consume_token(DOT);
      break;
    case EQ:
      t = jj_consume_token(EQ);
      break;
    case GT:
      t = jj_consume_token(GT);
      break;
    case LBRACKET:
      t = jj_consume_token(LBRACKET);
      break;
    case LPAREN:
      t = jj_consume_token(LPAREN);
      break;
    case LT:
      t = jj_consume_token(LT);
      break;
    case MINUS:
      t = jj_consume_token(MINUS);
      break;
    case PLUS:
      t = jj_consume_token(PLUS);
      break;
    case RBRACKET:
      t = jj_consume_token(RBRACKET);
      break;
    case RPAREN:
      t = jj_consume_token(RPAREN);
      break;
    case SHARP:
      t = jj_consume_token(SHARP);
      break;
    case SLASH:
      t = jj_consume_token(SLASH);
      break;
    case STAR:
      t = jj_consume_token(STAR);
      break;
    case TAB:
      t = jj_consume_token(TAB);
      break;
    case UNDERSCORE:
      t = jj_consume_token(UNDERSCORE);
      break;
    default:
      jj_la1[145] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        buff.append(t.image);
  }

  final public String Anything() throws ParseException {
    Token t;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CHAR_SEQUENCE:
      t = jj_consume_token(CHAR_SEQUENCE);
      break;
    case SPACE:
      t = jj_consume_token(SPACE);
      break;
    case DIGITS:
      t = jj_consume_token(DIGITS);
      break;
    case AMPERSAND:
      t = jj_consume_token(AMPERSAND);
      break;
    case BACKSLASH:
      t = jj_consume_token(BACKSLASH);
      break;
    case BACKTICK:
      t = jj_consume_token(BACKTICK);
      break;
    case BANG:
      t = jj_consume_token(BANG);
      break;
    case COLON:
      t = jj_consume_token(COLON);
      break;
    case COMMENT_CLOSE:
      t = jj_consume_token(COMMENT_CLOSE);
      break;
    case COMMENT_OPEN:
      t = jj_consume_token(COMMENT_OPEN);
      break;
    case DOUBLE_QUOTE:
      t = jj_consume_token(DOUBLE_QUOTE);
      break;
    case DOT:
      t = jj_consume_token(DOT);
      break;
    case EQ:
      t = jj_consume_token(EQ);
      break;
    case ESCAPED_CHAR:
      t = jj_consume_token(ESCAPED_CHAR);
      break;
    case GT:
      t = jj_consume_token(GT);
      break;
    case LBRACKET:
      t = jj_consume_token(LBRACKET);
      break;
    case LPAREN:
      t = jj_consume_token(LPAREN);
      break;
    case LT:
      t = jj_consume_token(LT);
      break;
    case MINUS:
      t = jj_consume_token(MINUS);
      break;
    case PLUS:
      t = jj_consume_token(PLUS);
      break;
    case RBRACKET:
      t = jj_consume_token(RBRACKET);
      break;
    case RPAREN:
      t = jj_consume_token(RPAREN);
      break;
    case SHARP:
      t = jj_consume_token(SHARP);
      break;
    case SINGLE_QUOTE:
      t = jj_consume_token(SINGLE_QUOTE);
      break;
    case SLASH:
      t = jj_consume_token(SLASH);
      break;
    case STAR:
      t = jj_consume_token(STAR);
      break;
    case TAB:
      t = jj_consume_token(TAB);
      break;
    case UNDERSCORE:
      t = jj_consume_token(UNDERSCORE);
      break;
    default:
      jj_la1[146] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return val(t);}
    throw new Error("Missing return statement in function");
  }

  final public void EmphasisText() throws ParseException {
                             /*@bgen(jjtree) Text */
    Text jjtn000 = new Text(JJTTEXT);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);Token t;
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CHAR_SEQUENCE:
        t = jj_consume_token(CHAR_SEQUENCE);
        break;
      case DIGITS:
        t = jj_consume_token(DIGITS);
        break;
      case AMPERSAND:
        t = jj_consume_token(AMPERSAND);
        break;
      case BACKSLASH:
        t = jj_consume_token(BACKSLASH);
        break;
      case BACKTICK:
        t = jj_consume_token(BACKTICK);
        break;
      case BANG:
        t = jj_consume_token(BANG);
        break;
      case COLON:
        t = jj_consume_token(COLON);
        break;
      case COMMENT_CLOSE:
        t = jj_consume_token(COMMENT_CLOSE);
        break;
      case COMMENT_OPEN:
        t = jj_consume_token(COMMENT_OPEN);
        break;
      case DOUBLE_QUOTE:
        t = jj_consume_token(DOUBLE_QUOTE);
        break;
      case DOT:
        t = jj_consume_token(DOT);
        break;
      case EQ:
        t = jj_consume_token(EQ);
        break;
      case ESCAPED_CHAR:
        t = jj_consume_token(ESCAPED_CHAR);
        break;
      case GT:
        t = jj_consume_token(GT);
        break;
      case LBRACKET:
        t = jj_consume_token(LBRACKET);
        break;
      case LPAREN:
        t = jj_consume_token(LPAREN);
        break;
      case LT:
        t = jj_consume_token(LT);
        break;
      case MINUS:
        t = jj_consume_token(MINUS);
        break;
      case PLUS:
        t = jj_consume_token(PLUS);
        break;
      case RBRACKET:
        t = jj_consume_token(RBRACKET);
        break;
      case RPAREN:
        t = jj_consume_token(RPAREN);
        break;
      case SHARP:
        t = jj_consume_token(SHARP);
        break;
      case SINGLE_QUOTE:
        t = jj_consume_token(SINGLE_QUOTE);
        break;
      case SLASH:
        t = jj_consume_token(SLASH);
        break;
      case TAB:
        t = jj_consume_token(TAB);
        break;
      default:
        jj_la1[147] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
        jjtree.closeNodeScope(jjtn000, true);
        jjtc000 = false;
        jjtn000.append(t.image);
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
  }

  final public void TagAttributeText(StringBuilder buff) throws ParseException {
    Token t;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CHAR_SEQUENCE:
      t = jj_consume_token(CHAR_SEQUENCE);
      break;
    case SPACE:
      t = jj_consume_token(SPACE);
      break;
    case DIGITS:
      t = jj_consume_token(DIGITS);
      break;
    case AMPERSAND:
      t = jj_consume_token(AMPERSAND);
      break;
    case BACKSLASH:
      t = jj_consume_token(BACKSLASH);
      break;
    case BACKTICK:
      t = jj_consume_token(BACKTICK);
      break;
    case BANG:
      t = jj_consume_token(BANG);
      break;
    case CHAR_ENTITY_REF:
      t = jj_consume_token(CHAR_ENTITY_REF);
      break;
    case COLON:
      t = jj_consume_token(COLON);
      break;
    case DOT:
      t = jj_consume_token(DOT);
      break;
    case EOL:
      t = jj_consume_token(EOL);
      break;
    case EQ:
      t = jj_consume_token(EQ);
      break;
    case ESCAPED_CHAR:
      t = jj_consume_token(ESCAPED_CHAR);
      break;
    case GT:
      t = jj_consume_token(GT);
      break;
    case LPAREN:
      t = jj_consume_token(LPAREN);
      break;
    case MINUS:
      t = jj_consume_token(MINUS);
      break;
    case NUMERIC_CHAR_REF:
      t = jj_consume_token(NUMERIC_CHAR_REF);
      break;
    case PLUS:
      t = jj_consume_token(PLUS);
      break;
    case RPAREN:
      t = jj_consume_token(RPAREN);
      break;
    case SHARP:
      t = jj_consume_token(SHARP);
      break;
    case SLASH:
      t = jj_consume_token(SLASH);
      break;
    case STAR:
      t = jj_consume_token(STAR);
      break;
    case TAB:
      t = jj_consume_token(TAB);
      break;
    case UNDERSCORE:
      t = jj_consume_token(UNDERSCORE);
      break;
    default:
      jj_la1[148] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        buff.append(t.image);
  }

  final public void TextNode() throws ParseException {
                         /*@bgen(jjtree) Text */
    Text jjtn000 = new Text(JJTTEXT);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);Token t;
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CHAR_SEQUENCE:
        t = jj_consume_token(CHAR_SEQUENCE);
        break;
      case SPACE:
        t = jj_consume_token(SPACE);
        break;
      case DIGITS:
        t = jj_consume_token(DIGITS);
        break;
      case AMPERSAND:
        t = jj_consume_token(AMPERSAND);
        break;
      case BACKSLASH:
        t = jj_consume_token(BACKSLASH);
        break;
      case BACKTICK:
        t = jj_consume_token(BACKTICK);
        break;
      case BANG:
        t = jj_consume_token(BANG);
        break;
      case CHAR_ENTITY_REF:
        t = jj_consume_token(CHAR_ENTITY_REF);
        break;
      case COLON:
        t = jj_consume_token(COLON);
        break;
      case COMMENT_CLOSE:
        t = jj_consume_token(COMMENT_CLOSE);
        break;
      case COMMENT_OPEN:
        t = jj_consume_token(COMMENT_OPEN);
        break;
      case DOUBLE_QUOTE:
        t = jj_consume_token(DOUBLE_QUOTE);
        break;
      case DOT:
        t = jj_consume_token(DOT);
        break;
      case EQ:
        t = jj_consume_token(EQ);
        break;
      case EOL:
        t = jj_consume_token(EOL);
        break;
      case ESCAPED_CHAR:
        t = jj_consume_token(ESCAPED_CHAR);
        break;
      case GT:
        t = jj_consume_token(GT);
        break;
      case LBRACKET:
        t = jj_consume_token(LBRACKET);
        break;
      case LPAREN:
        t = jj_consume_token(LPAREN);
        break;
      case MINUS:
        t = jj_consume_token(MINUS);
        break;
      case NUMERIC_CHAR_REF:
        t = jj_consume_token(NUMERIC_CHAR_REF);
        break;
      case PLUS:
        t = jj_consume_token(PLUS);
        break;
      case RBRACKET:
        t = jj_consume_token(RBRACKET);
        break;
      case RPAREN:
        t = jj_consume_token(RPAREN);
        break;
      case SHARP:
        t = jj_consume_token(SHARP);
        break;
      case SINGLE_QUOTE:
        t = jj_consume_token(SINGLE_QUOTE);
        break;
      case SLASH:
        t = jj_consume_token(SLASH);
        break;
      case STAR:
        t = jj_consume_token(STAR);
        break;
      case TAB:
        t = jj_consume_token(TAB);
        break;
      case UNDERSCORE:
        t = jj_consume_token(UNDERSCORE);
        break;
      default:
        jj_la1[149] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
        jjtree.closeNodeScope(jjtn000, true);
        jjtc000 = false;
        jjtn000.append(t.image);
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
  }

  private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_2_2(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_2(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  private boolean jj_2_3(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_3(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  private boolean jj_2_4(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_4(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  private boolean jj_2_5(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_5(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  private boolean jj_2_6(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_6(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  private boolean jj_2_7(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_7(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  private boolean jj_2_8(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_8(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(7, xla); }
  }

  private boolean jj_2_9(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_9(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(8, xla); }
  }

  private boolean jj_2_10(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_10(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(9, xla); }
  }

  private boolean jj_2_11(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_11(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(10, xla); }
  }

  private boolean jj_2_12(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_12(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(11, xla); }
  }

  private boolean jj_2_13(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_13(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(12, xla); }
  }

  private boolean jj_2_14(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_14(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(13, xla); }
  }

  private boolean jj_2_15(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_15(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(14, xla); }
  }

  private boolean jj_2_16(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_16(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(15, xla); }
  }

  private boolean jj_2_17(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_17(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(16, xla); }
  }

  private boolean jj_2_18(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_18(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(17, xla); }
  }

  private boolean jj_2_19(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_19(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(18, xla); }
  }

  private boolean jj_2_20(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_20(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(19, xla); }
  }

  private boolean jj_2_21(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_21(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(20, xla); }
  }

  private boolean jj_2_22(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_22(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(21, xla); }
  }

  private boolean jj_2_23(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_23(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(22, xla); }
  }

  private boolean jj_2_24(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_24(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(23, xla); }
  }

  private boolean jj_2_25(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_25(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(24, xla); }
  }

  private boolean jj_2_26(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_26(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(25, xla); }
  }

  private boolean jj_2_27(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_27(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(26, xla); }
  }

  private boolean jj_2_28(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_28(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(27, xla); }
  }

  private boolean jj_2_29(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_29(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(28, xla); }
  }

  private boolean jj_2_30(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_30(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(29, xla); }
  }

  private boolean jj_2_31(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_31(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(30, xla); }
  }

  private boolean jj_2_32(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_32(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(31, xla); }
  }

  private boolean jj_2_33(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_33(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(32, xla); }
  }

  private boolean jj_2_34(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_34(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(33, xla); }
  }

  private boolean jj_2_35(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_35(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(34, xla); }
  }

  private boolean jj_2_36(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_36(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(35, xla); }
  }

  private boolean jj_2_37(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_37(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(36, xla); }
  }

  private boolean jj_2_38(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_38(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(37, xla); }
  }

  private boolean jj_2_39(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_39(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(38, xla); }
  }

  private boolean jj_2_40(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_40(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(39, xla); }
  }

  private boolean jj_2_41(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_41(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(40, xla); }
  }

  private boolean jj_2_42(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_42(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(41, xla); }
  }

  private boolean jj_2_43(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_43(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(42, xla); }
  }

  private boolean jj_2_44(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_44(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(43, xla); }
  }

  private boolean jj_2_45(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_45(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(44, xla); }
  }

  private boolean jj_2_46(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_46(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(45, xla); }
  }

  private boolean jj_2_47(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_47(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(46, xla); }
  }

  private boolean jj_2_48(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_48(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(47, xla); }
  }

  private boolean jj_2_49(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_49(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(48, xla); }
  }

  private boolean jj_2_50(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_50(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(49, xla); }
  }

  private boolean jj_2_51(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_51(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(50, xla); }
  }

  private boolean jj_2_52(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_52(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(51, xla); }
  }

  private boolean jj_2_53(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_53(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(52, xla); }
  }

  private boolean jj_2_54(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_54(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(53, xla); }
  }

  private boolean jj_2_55(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_55(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(54, xla); }
  }

  private boolean jj_3R_259() {
    if (jj_3R_162()) return true;
    return false;
  }

  private boolean jj_3_36() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(1)) {
    jj_scanpos = xsp;
    if (jj_scan_token(2)) return true;
    }
    if (jj_3R_83()) return true;
    return false;
  }

  private boolean jj_3R_87() {
    if (jj_scan_token(BACKTICK)) return true;
    return false;
  }

  private boolean jj_3R_86() {
    if (jj_scan_token(EOL)) return true;
    return false;
  }

  private boolean jj_3R_83() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(7)) {
    jj_scanpos = xsp;
    if (jj_scan_token(1)) {
    jj_scanpos = xsp;
    if (jj_scan_token(8)) {
    jj_scanpos = xsp;
    if (jj_scan_token(9)) {
    jj_scanpos = xsp;
    if (jj_scan_token(10)) {
    jj_scanpos = xsp;
    if (jj_scan_token(12)) {
    jj_scanpos = xsp;
    if (jj_scan_token(4)) {
    jj_scanpos = xsp;
    if (jj_scan_token(15)) {
    jj_scanpos = xsp;
    if (jj_scan_token(14)) {
    jj_scanpos = xsp;
    if (jj_scan_token(13)) {
    jj_scanpos = xsp;
    if (jj_scan_token(17)) {
    jj_scanpos = xsp;
    if (jj_scan_token(16)) {
    jj_scanpos = xsp;
    if (jj_scan_token(18)) {
    jj_scanpos = xsp;
    if (jj_scan_token(6)) {
    jj_scanpos = xsp;
    if (jj_scan_token(19)) {
    jj_scanpos = xsp;
    if (jj_scan_token(20)) {
    jj_scanpos = xsp;
    if (jj_scan_token(21)) {
    jj_scanpos = xsp;
    if (jj_scan_token(22)) {
    jj_scanpos = xsp;
    if (jj_scan_token(23)) {
    jj_scanpos = xsp;
    if (jj_scan_token(5)) {
    jj_scanpos = xsp;
    if (jj_scan_token(24)) {
    jj_scanpos = xsp;
    if (jj_scan_token(25)) {
    jj_scanpos = xsp;
    if (jj_scan_token(26)) {
    jj_scanpos = xsp;
    if (jj_scan_token(27)) {
    jj_scanpos = xsp;
    if (jj_scan_token(28)) {
    jj_scanpos = xsp;
    if (jj_scan_token(29)) {
    jj_scanpos = xsp;
    if (jj_scan_token(30)) {
    jj_scanpos = xsp;
    if (jj_scan_token(2)) {
    jj_scanpos = xsp;
    if (jj_scan_token(31)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_85() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(1)) {
    jj_scanpos = xsp;
    if (jj_scan_token(2)) return true;
    }
    return false;
  }

  private boolean jj_3R_260() {
    if (jj_3R_162()) return true;
    return false;
  }

  private boolean jj_3R_84() {
    if (jj_3R_83()) return true;
    return false;
  }

  private boolean jj_3_37() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_84()) {
    jj_scanpos = xsp;
    if (jj_3R_85()) {
    jj_scanpos = xsp;
    if (jj_3R_86()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = BacktickInsideCodeSpanLookahead();
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_87()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_206() {
    if (jj_scan_token(BACKTICK)) return true;
    return false;
  }

  private boolean jj_3R_150() {
    Token xsp;
    if (jj_3R_206()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_206()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_259()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(3)) jj_scanpos = xsp;
    if (jj_3_37()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_37()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_260()) jj_scanpos = xsp;
    if (jj_scan_token(11)) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(11)) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_149() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(5)) {
    jj_scanpos = xsp;
    if (jj_scan_token(4)) return true;
    }
    return false;
  }

  private boolean jj_3_35() {
    if (jj_3R_82()) return true;
    return false;
  }

  private boolean jj_3_34() {
    if (jj_3R_81()) return true;
    if (jj_scan_token(EOL)) return true;
    return false;
  }

  private boolean jj_3_33() {
    if (jj_3R_80()) return true;
    return false;
  }

  private boolean jj_3_32() {
    if (jj_3R_79()) return true;
    return false;
  }

  private boolean jj_3R_220() {
    if (jj_3R_145()) return true;
    return false;
  }

  private boolean jj_3_31() {
    if (jj_3R_78()) return true;
    return false;
  }

  private boolean jj_3_30() {
    if (jj_3R_77()) return true;
    return false;
  }

  private boolean jj_3R_81() {
    if (jj_scan_token(SPACE)) return true;
    if (jj_scan_token(SPACE)) return true;
    return false;
  }

  private boolean jj_3R_178() {
    if (jj_3R_220()) return true;
    return false;
  }

  private boolean jj_3R_177() {
    if (jj_3R_82()) return true;
    return false;
  }

  private boolean jj_3R_176() {
    if (jj_3R_81()) return true;
    return false;
  }

  private boolean jj_3R_175() {
    if (jj_3R_80()) return true;
    return false;
  }

  private boolean jj_3R_174() {
    if (jj_3R_79()) return true;
    return false;
  }

  private boolean jj_3R_173() {
    if (jj_3R_78()) return true;
    return false;
  }

  private boolean jj_3R_172() {
    if (jj_3R_77()) return true;
    return false;
  }

  private boolean jj_3R_171() {
    if (jj_3R_150()) return true;
    return false;
  }

  private boolean jj_3R_170() {
    if (jj_3R_149()) return true;
    return false;
  }

  private boolean jj_3R_133() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_170()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = CodeSpanLookahead();
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_171()) {
    jj_scanpos = xsp;
    if (jj_3R_172()) {
    jj_scanpos = xsp;
    if (jj_3R_173()) {
    jj_scanpos = xsp;
    if (jj_3R_174()) {
    jj_scanpos = xsp;
    if (jj_3R_175()) {
    jj_scanpos = xsp;
    if (jj_3R_176()) {
    jj_scanpos = xsp;
    if (jj_3R_177()) {
    jj_scanpos = xsp;
    if (jj_3R_178()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_71() {
    Token xsp;
    if (jj_3R_133()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_133()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_219() {
    if (jj_scan_token(DIGITS)) return true;
    if (jj_scan_token(DOT)) return true;
    return false;
  }

  private boolean jj_3R_62() {
    if (jj_3R_71()) return true;
    return false;
  }

  private boolean jj_3R_169() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(24)) {
    jj_scanpos = xsp;
    if (jj_scan_token(23)) {
    jj_scanpos = xsp;
    if (jj_scan_token(30)) {
    jj_scanpos = xsp;
    if (jj_3R_219()) return true;
    }
    }
    }
    xsp = jj_scanpos;
    if (jj_scan_token(1)) {
    jj_scanpos = xsp;
    if (jj_scan_token(2)) return true;
    }
    return false;
  }

  private boolean jj_3_28() {
    if (jj_3R_63()) return true;
    return false;
  }

  private boolean jj_3_29() {
    if (jj_3R_62()) return true;
    return false;
  }

  private boolean jj_3R_126() {
    if (jj_3R_169()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_29()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_127() {
    if (jj_scan_token(EOL)) return true;
    return false;
  }

  private boolean jj_3R_125() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(1)) {
    jj_scanpos = xsp;
    if (jj_scan_token(2)) {
    jj_scanpos = xsp;
    if (jj_scan_token(19)) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_61() {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_125()) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_126()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_127()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_114() {
    if (jj_3R_162()) return true;
    return false;
  }

  private boolean jj_3R_112() {
    if (jj_3R_162()) return true;
    return false;
  }

  private boolean jj_3R_110() {
    if (jj_3R_130()) return true;
    return false;
  }

  private boolean jj_3R_54() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_110()) jj_scanpos = xsp;
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_3R_111()) return true;
    if (jj_scan_token(RBRACKET)) return true;
    xsp = jj_scanpos;
    if (jj_scan_token(1)) jj_scanpos = xsp;
    if (jj_scan_token(COLON)) return true;
    xsp = jj_scanpos;
    if (jj_3R_112()) jj_scanpos = xsp;
    if (jj_3R_113()) return true;
    xsp = jj_scanpos;
    if (jj_3R_114()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_156() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(7)) {
    jj_scanpos = xsp;
    if (jj_scan_token(1)) {
    jj_scanpos = xsp;
    if (jj_scan_token(8)) {
    jj_scanpos = xsp;
    if (jj_scan_token(9)) {
    jj_scanpos = xsp;
    if (jj_scan_token(10)) {
    jj_scanpos = xsp;
    if (jj_scan_token(11)) {
    jj_scanpos = xsp;
    if (jj_scan_token(12)) {
    jj_scanpos = xsp;
    if (jj_scan_token(4)) {
    jj_scanpos = xsp;
    if (jj_scan_token(15)) {
    jj_scanpos = xsp;
    if (jj_scan_token(14)) {
    jj_scanpos = xsp;
    if (jj_scan_token(13)) {
    jj_scanpos = xsp;
    if (jj_scan_token(16)) {
    jj_scanpos = xsp;
    if (jj_scan_token(17)) {
    jj_scanpos = xsp;
    if (jj_scan_token(18)) {
    jj_scanpos = xsp;
    if (jj_scan_token(3)) {
    jj_scanpos = xsp;
    if (jj_scan_token(6)) {
    jj_scanpos = xsp;
    if (jj_scan_token(19)) {
    jj_scanpos = xsp;
    if (jj_scan_token(20)) {
    jj_scanpos = xsp;
    if (jj_scan_token(21)) {
    jj_scanpos = xsp;
    if (jj_scan_token(23)) {
    jj_scanpos = xsp;
    if (jj_scan_token(5)) {
    jj_scanpos = xsp;
    if (jj_scan_token(24)) {
    jj_scanpos = xsp;
    if (jj_scan_token(25)) {
    jj_scanpos = xsp;
    if (jj_scan_token(26)) {
    jj_scanpos = xsp;
    if (jj_scan_token(27)) {
    jj_scanpos = xsp;
    if (jj_scan_token(28)) {
    jj_scanpos = xsp;
    if (jj_scan_token(29)) {
    jj_scanpos = xsp;
    if (jj_scan_token(30)) {
    jj_scanpos = xsp;
    if (jj_scan_token(2)) {
    jj_scanpos = xsp;
    if (jj_scan_token(31)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_23() {
    if (jj_3R_55()) return true;
    return false;
  }

  private boolean jj_3R_263() {
    if (jj_scan_token(SHARP)) return true;
    return false;
  }

  private boolean jj_3R_74() {
    if (jj_scan_token(SPACE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(1)) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_73() {
    if (jj_scan_token(SPACE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(1)) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_72() {
    if (jj_scan_token(SPACE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(1)) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_135() {
    if (jj_3R_162()) return true;
    return false;
  }

  private boolean jj_3R_76() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_135()) jj_scanpos = xsp;
    if (jj_scan_token(EOL)) return true;
    return false;
  }

  private boolean jj_3_27() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_76()) {
    jj_scanpos = xsp;
    if (jj_scan_token(0)) return true;
    }
    return false;
  }

  private boolean jj_3R_250() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(7)) {
    jj_scanpos = xsp;
    if (jj_scan_token(1)) {
    jj_scanpos = xsp;
    if (jj_scan_token(8)) {
    jj_scanpos = xsp;
    if (jj_scan_token(9)) {
    jj_scanpos = xsp;
    if (jj_scan_token(10)) {
    jj_scanpos = xsp;
    if (jj_scan_token(11)) {
    jj_scanpos = xsp;
    if (jj_scan_token(12)) {
    jj_scanpos = xsp;
    if (jj_scan_token(4)) {
    jj_scanpos = xsp;
    if (jj_scan_token(15)) {
    jj_scanpos = xsp;
    if (jj_scan_token(17)) {
    jj_scanpos = xsp;
    if (jj_scan_token(3)) {
    jj_scanpos = xsp;
    if (jj_scan_token(18)) {
    jj_scanpos = xsp;
    if (jj_scan_token(6)) {
    jj_scanpos = xsp;
    if (jj_scan_token(19)) {
    jj_scanpos = xsp;
    if (jj_scan_token(21)) {
    jj_scanpos = xsp;
    if (jj_scan_token(23)) {
    jj_scanpos = xsp;
    if (jj_scan_token(5)) {
    jj_scanpos = xsp;
    if (jj_scan_token(24)) {
    jj_scanpos = xsp;
    if (jj_scan_token(26)) {
    jj_scanpos = xsp;
    if (jj_scan_token(27)) {
    jj_scanpos = xsp;
    if (jj_scan_token(29)) {
    jj_scanpos = xsp;
    if (jj_scan_token(30)) {
    jj_scanpos = xsp;
    if (jj_scan_token(2)) {
    jj_scanpos = xsp;
    if (jj_scan_token(31)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_26() {
    if (jj_3R_56()) return true;
    return false;
  }

  private boolean jj_3_22() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_74()) jj_scanpos = xsp;
    if (jj_scan_token(UNDERSCORE)) return true;
    return false;
  }

  private boolean jj_3_20() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_73()) jj_scanpos = xsp;
    if (jj_scan_token(STAR)) return true;
    return false;
  }

  private boolean jj_3R_129() {
    if (jj_scan_token(SPACE)) return true;
    if (jj_scan_token(SPACE)) return true;
    if (jj_scan_token(SPACE)) return true;
    if (jj_scan_token(SPACE)) return true;
    return false;
  }

  private boolean jj_3R_64() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_129()) {
    jj_scanpos = xsp;
    if (jj_scan_token(2)) return true;
    }
    return false;
  }

  private boolean jj_3R_258() {
    if (jj_scan_token(SHARP)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_263()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_18() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_72()) jj_scanpos = xsp;
    if (jj_scan_token(MINUS)) return true;
    return false;
  }

  private boolean jj_3R_215() {
    if (jj_3R_64()) return true;
    return false;
  }

  private boolean jj_3_25() {
    if (jj_3R_56()) return true;
    return false;
  }

  private boolean jj_3R_134() {
    if (jj_3R_162()) return true;
    return false;
  }

  private boolean jj_3R_75() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_134()) jj_scanpos = xsp;
    if (jj_scan_token(EOL)) return true;
    return false;
  }

  private boolean jj_3_24() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_75()) {
    jj_scanpos = xsp;
    if (jj_scan_token(0)) return true;
    }
    return false;
  }

  private boolean jj_3R_166() {
    if (jj_3R_215()) return true;
    return false;
  }

  private boolean jj_3R_56() {
    if (jj_scan_token(GT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(1)) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_254() {
    if (jj_scan_token(SHARP)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_258()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_226() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(7)) {
    jj_scanpos = xsp;
    if (jj_scan_token(8)) {
    jj_scanpos = xsp;
    if (jj_scan_token(9)) {
    jj_scanpos = xsp;
    if (jj_scan_token(10)) {
    jj_scanpos = xsp;
    if (jj_scan_token(11)) {
    jj_scanpos = xsp;
    if (jj_scan_token(12)) {
    jj_scanpos = xsp;
    if (jj_scan_token(15)) {
    jj_scanpos = xsp;
    if (jj_scan_token(14)) {
    jj_scanpos = xsp;
    if (jj_scan_token(13)) {
    jj_scanpos = xsp;
    if (jj_scan_token(16)) {
    jj_scanpos = xsp;
    if (jj_scan_token(17)) {
    jj_scanpos = xsp;
    if (jj_scan_token(18)) {
    jj_scanpos = xsp;
    if (jj_scan_token(6)) {
    jj_scanpos = xsp;
    if (jj_scan_token(19)) {
    jj_scanpos = xsp;
    if (jj_scan_token(20)) {
    jj_scanpos = xsp;
    if (jj_scan_token(21)) {
    jj_scanpos = xsp;
    if (jj_scan_token(22)) {
    jj_scanpos = xsp;
    if (jj_scan_token(23)) {
    jj_scanpos = xsp;
    if (jj_scan_token(24)) {
    jj_scanpos = xsp;
    if (jj_scan_token(25)) {
    jj_scanpos = xsp;
    if (jj_scan_token(26)) {
    jj_scanpos = xsp;
    if (jj_scan_token(27)) {
    jj_scanpos = xsp;
    if (jj_scan_token(28)) {
    jj_scanpos = xsp;
    if (jj_scan_token(29)) {
    jj_scanpos = xsp;
    if (jj_scan_token(2)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_21() {
    if (jj_scan_token(SPACE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(1)) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_19() {
    if (jj_scan_token(SPACE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(1)) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_131() {
    if (jj_3R_56()) return true;
    return false;
  }

  private boolean jj_3_17() {
    if (jj_scan_token(SPACE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(1)) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_119() {
    if (jj_scan_token(UNDERSCORE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_21()) jj_scanpos = xsp;
    if (jj_scan_token(UNDERSCORE)) return true;
    if (jj_3_22()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_22()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_118() {
    if (jj_scan_token(STAR)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_19()) jj_scanpos = xsp;
    if (jj_scan_token(STAR)) return true;
    if (jj_3_20()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_20()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_120() {
    if (jj_3R_162()) return true;
    return false;
  }

  private boolean jj_3R_247() {
    if (jj_scan_token(SHARP)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_254()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_117() {
    if (jj_scan_token(MINUS)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_17()) jj_scanpos = xsp;
    if (jj_scan_token(MINUS)) return true;
    if (jj_3_18()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_18()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_57() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_117()) {
    jj_scanpos = xsp;
    if (jj_3R_118()) {
    jj_scanpos = xsp;
    if (jj_3R_119()) return true;
    }
    }
    xsp = jj_scanpos;
    if (jj_3R_120()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_218() {
    Token xsp;
    if (jj_scan_token(23)) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(23)) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_217() {
    Token xsp;
    if (jj_scan_token(18)) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(18)) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_168() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_217()) {
    jj_scanpos = xsp;
    if (jj_3R_218()) return true;
    }
    return false;
  }

  private boolean jj_3R_216() {
    if (jj_scan_token(SHARP)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_247()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_145() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(7)) {
    jj_scanpos = xsp;
    if (jj_scan_token(1)) {
    jj_scanpos = xsp;
    if (jj_scan_token(8)) {
    jj_scanpos = xsp;
    if (jj_scan_token(9)) {
    jj_scanpos = xsp;
    if (jj_scan_token(10)) {
    jj_scanpos = xsp;
    if (jj_scan_token(11)) {
    jj_scanpos = xsp;
    if (jj_scan_token(12)) {
    jj_scanpos = xsp;
    if (jj_scan_token(15)) {
    jj_scanpos = xsp;
    if (jj_scan_token(14)) {
    jj_scanpos = xsp;
    if (jj_scan_token(13)) {
    jj_scanpos = xsp;
    if (jj_scan_token(16)) {
    jj_scanpos = xsp;
    if (jj_scan_token(17)) {
    jj_scanpos = xsp;
    if (jj_scan_token(18)) {
    jj_scanpos = xsp;
    if (jj_scan_token(6)) {
    jj_scanpos = xsp;
    if (jj_scan_token(19)) {
    jj_scanpos = xsp;
    if (jj_scan_token(20)) {
    jj_scanpos = xsp;
    if (jj_scan_token(21)) {
    jj_scanpos = xsp;
    if (jj_scan_token(22)) {
    jj_scanpos = xsp;
    if (jj_scan_token(23)) {
    jj_scanpos = xsp;
    if (jj_scan_token(24)) {
    jj_scanpos = xsp;
    if (jj_scan_token(25)) {
    jj_scanpos = xsp;
    if (jj_scan_token(26)) {
    jj_scanpos = xsp;
    if (jj_scan_token(27)) {
    jj_scanpos = xsp;
    if (jj_scan_token(28)) {
    jj_scanpos = xsp;
    if (jj_scan_token(29)) {
    jj_scanpos = xsp;
    if (jj_scan_token(30)) {
    jj_scanpos = xsp;
    if (jj_scan_token(2)) {
    jj_scanpos = xsp;
    if (jj_scan_token(31)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_167() {
    if (jj_scan_token(SHARP)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_216()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_16() {
    if (jj_3R_71()) return true;
    if (jj_scan_token(EOL)) return true;
    if (jj_3R_168()) return true;
    return false;
  }

  private boolean jj_3R_122() {
    if (jj_3R_162()) return true;
    return false;
  }

  private boolean jj_3R_267() {
    if (jj_scan_token(DOUBLE_QUOTE)) return true;
    return false;
  }

  private boolean jj_3R_121() {
    if (jj_3R_167()) return true;
    if (jj_3R_71()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(27)) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_58() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_121()) {
    jj_scanpos = xsp;
    if (jj_3_16()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_122()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_212() {
    if (jj_scan_token(SPACE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(1)) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_108() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_160()) {
    jj_scanpos = xsp;
    if (jj_scan_token(16)) return true;
    }
    return false;
  }

  private boolean jj_3R_160() {
    if (jj_3R_211()) return true;
    return false;
  }

  private boolean jj_3R_265() {
    if (jj_scan_token(SINGLE_QUOTE)) return true;
    return false;
  }

  private boolean jj_3_55() {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_108()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(SINGLE_QUOTE)) return true;
    return false;
  }

  private boolean jj_3R_128() {
    if (jj_3R_162()) return true;
    return false;
  }

  private boolean jj_3_10() {
    if (jj_3R_60()) return true;
    return false;
  }

  private boolean jj_3_9() {
    if (jj_3R_59()) return true;
    return false;
  }

  private boolean jj_3R_63() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_128()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(3)) {
    jj_scanpos = xsp;
    if (jj_scan_token(0)) return true;
    }
    return false;
  }

  private boolean jj_3_8() {
    if (jj_3R_58()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(3)) {
    jj_scanpos = xsp;
    if (jj_scan_token(0)) return true;
    }
    return false;
  }

  private boolean jj_3_7() {
    if (jj_3R_57()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(3)) {
    jj_scanpos = xsp;
    if (jj_scan_token(0)) return true;
    }
    return false;
  }

  private boolean jj_3R_130() {
    if (jj_scan_token(SPACE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_212()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_266() {
    if (jj_3R_211()) return true;
    return false;
  }

  private boolean jj_3R_262() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_266()) {
    jj_scanpos = xsp;
    if (jj_3R_267()) return true;
    }
    return false;
  }

  private boolean jj_3_6() {
    if (jj_3R_56()) return true;
    return false;
  }

  private boolean jj_3R_107() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_159()) {
    jj_scanpos = xsp;
    if (jj_scan_token(28)) return true;
    }
    return false;
  }

  private boolean jj_3R_159() {
    if (jj_3R_211()) return true;
    return false;
  }

  private boolean jj_3R_211() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(7)) {
    jj_scanpos = xsp;
    if (jj_scan_token(1)) {
    jj_scanpos = xsp;
    if (jj_scan_token(8)) {
    jj_scanpos = xsp;
    if (jj_scan_token(9)) {
    jj_scanpos = xsp;
    if (jj_scan_token(10)) {
    jj_scanpos = xsp;
    if (jj_scan_token(11)) {
    jj_scanpos = xsp;
    if (jj_scan_token(12)) {
    jj_scanpos = xsp;
    if (jj_scan_token(15)) {
    jj_scanpos = xsp;
    if (jj_scan_token(17)) {
    jj_scanpos = xsp;
    if (jj_scan_token(18)) {
    jj_scanpos = xsp;
    if (jj_scan_token(19)) {
    jj_scanpos = xsp;
    if (jj_scan_token(20)) {
    jj_scanpos = xsp;
    if (jj_scan_token(21)) {
    jj_scanpos = xsp;
    if (jj_scan_token(22)) {
    jj_scanpos = xsp;
    if (jj_scan_token(23)) {
    jj_scanpos = xsp;
    if (jj_scan_token(24)) {
    jj_scanpos = xsp;
    if (jj_scan_token(25)) {
    jj_scanpos = xsp;
    if (jj_scan_token(26)) {
    jj_scanpos = xsp;
    if (jj_scan_token(27)) {
    jj_scanpos = xsp;
    if (jj_scan_token(29)) {
    jj_scanpos = xsp;
    if (jj_scan_token(30)) {
    jj_scanpos = xsp;
    if (jj_scan_token(2)) {
    jj_scanpos = xsp;
    if (jj_scan_token(31)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_213() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(1)) {
    jj_scanpos = xsp;
    if (jj_scan_token(2)) return true;
    }
    return false;
  }

  private boolean jj_3_54() {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_107()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(DOUBLE_QUOTE)) return true;
    return false;
  }

  private boolean jj_3R_257() {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_262()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(SINGLE_QUOTE)) return true;
    return false;
  }

  private boolean jj_3_12() {
    if (jj_3R_62()) return true;
    return false;
  }

  private boolean jj_3R_162() {
    Token xsp;
    if (jj_3R_213()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_213()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_11() {
    if (jj_3R_61()) return true;
    return false;
  }

  private boolean jj_3R_70() {
    if (jj_3R_132()) return true;
    return false;
  }

  private boolean jj_3R_69() {
    if (jj_3R_59()) return true;
    return false;
  }

  private boolean jj_3R_132() {
    if (jj_3R_155()) return true;
    return false;
  }

  private boolean jj_3R_68() {
    if (jj_3R_58()) return true;
    return false;
  }

  private boolean jj_3R_67() {
    if (jj_3R_57()) return true;
    return false;
  }

  private boolean jj_3R_264() {
    if (jj_3R_211()) return true;
    return false;
  }

  private boolean jj_3R_261() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_264()) {
    jj_scanpos = xsp;
    if (jj_3R_265()) return true;
    }
    return false;
  }

  private boolean jj_3_14() {
    if (jj_3R_64()) return true;
    return false;
  }

  private boolean jj_3R_66() {
    if (jj_3R_131()) return true;
    return false;
  }

  private boolean jj_3R_256() {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_261()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(DOUBLE_QUOTE)) return true;
    return false;
  }

  private boolean jj_3R_253() {
    if (jj_scan_token(SINGLE_QUOTE)) return true;
    Token xsp;
    if (jj_3R_257()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_257()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_13() {
    if (jj_3R_63()) return true;
    return false;
  }

  private boolean jj_3R_65() {
    if (jj_3R_130()) return true;
    return false;
  }

  private boolean jj_3_4() {
    if (jj_3R_54()) return true;
    return false;
  }

  private boolean jj_3R_106() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(1)) jj_scanpos = xsp;
    if (jj_3R_158()) return true;
    return false;
  }

  private boolean jj_3R_116() {
    if (jj_3R_166()) return true;
    return false;
  }

  private boolean jj_3_2() {
    if (jj_scan_token(EOL)) return true;
    if (jj_3R_53()) return true;
    return false;
  }

  private boolean jj_3_15() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_65()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_66()) {
    jj_scanpos = xsp;
    if (jj_3R_67()) {
    jj_scanpos = xsp;
    if (jj_3R_68()) {
    jj_scanpos = xsp;
    if (jj_3R_69()) {
    jj_scanpos = xsp;
    if (jj_3R_70()) {
    jj_scanpos = xsp;
    if (jj_3_11()) {
    jj_scanpos = xsp;
    if (jj_3_12()) return true;
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_252() {
    if (jj_scan_token(DOUBLE_QUOTE)) return true;
    Token xsp;
    if (jj_3R_256()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_256()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_115() {
    if (jj_3R_162()) return true;
    return false;
  }

  private boolean jj_3R_55() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_115()) {
    jj_scanpos = xsp;
    if (jj_3R_116()) {
    jj_scanpos = xsp;
    if (jj_3_15()) return true;
    }
    }
    return false;
  }

  private boolean jj_3_5() {
    if (jj_3R_55()) return true;
    return false;
  }

  private boolean jj_3R_246() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_252()) {
    jj_scanpos = xsp;
    if (jj_3R_253()) return true;
    }
    return false;
  }

  private boolean jj_3R_109() {
    if (jj_3R_54()) return true;
    return false;
  }

  private boolean jj_3R_53() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_109()) {
    jj_scanpos = xsp;
    if (jj_3_5()) return true;
    }
    return false;
  }

  private boolean jj_3_3() {
    if (jj_3R_53()) return true;
    return false;
  }

  private boolean jj_3_1() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(3)) {
    jj_scanpos = xsp;
    if (jj_3_3()) return true;
    }
    return false;
  }

  private boolean jj_3R_105() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_157()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3_53() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_105()) {
    jj_scanpos = xsp;
    if (jj_3R_106()) return true;
    }
    return false;
  }

  private boolean jj_3R_251() {
    if (jj_scan_token(SPACE)) return true;
    return false;
  }

  private boolean jj_3R_158() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(7)) {
    jj_scanpos = xsp;
    if (jj_scan_token(8)) {
    jj_scanpos = xsp;
    if (jj_scan_token(9)) {
    jj_scanpos = xsp;
    if (jj_scan_token(10)) {
    jj_scanpos = xsp;
    if (jj_scan_token(12)) {
    jj_scanpos = xsp;
    if (jj_scan_token(15)) {
    jj_scanpos = xsp;
    if (jj_scan_token(17)) {
    jj_scanpos = xsp;
    if (jj_scan_token(18)) {
    jj_scanpos = xsp;
    if (jj_scan_token(20)) {
    jj_scanpos = xsp;
    if (jj_scan_token(23)) {
    jj_scanpos = xsp;
    if (jj_scan_token(24)) {
    jj_scanpos = xsp;
    if (jj_scan_token(25)) {
    jj_scanpos = xsp;
    if (jj_scan_token(27)) {
    jj_scanpos = xsp;
    if (jj_scan_token(29)) {
    jj_scanpos = xsp;
    if (jj_scan_token(31)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_245() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_251()) jj_scanpos = xsp;
    if (jj_3R_158()) return true;
    return false;
  }

  private boolean jj_3R_244() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_157()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_210() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_244()) {
    jj_scanpos = xsp;
    if (jj_3R_245()) return true;
    }
    return false;
  }

  private boolean jj_3R_157() {
    Token xsp;
    if (jj_3R_210()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_210()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_214() {
    if (jj_3R_246()) return true;
    return false;
  }

  private boolean jj_3R_165() {
    if (jj_3R_162()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_214()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_164() {
    if (jj_3R_157()) return true;
    return false;
  }

  private boolean jj_3R_163() {
    if (jj_scan_token(LT)) return true;
    if (jj_3R_157()) return true;
    if (jj_scan_token(GT)) return true;
    return false;
  }

  private boolean jj_3R_113() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_163()) {
    jj_scanpos = xsp;
    if (jj_3R_164()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_165()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_124() {
    Token xsp;
    if (jj_scan_token(1)) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(1)) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_101()) return true;
    return false;
  }

  private boolean jj_3R_161() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(7)) {
    jj_scanpos = xsp;
    if (jj_scan_token(1)) {
    jj_scanpos = xsp;
    if (jj_scan_token(8)) {
    jj_scanpos = xsp;
    if (jj_scan_token(9)) {
    jj_scanpos = xsp;
    if (jj_scan_token(10)) {
    jj_scanpos = xsp;
    if (jj_scan_token(11)) {
    jj_scanpos = xsp;
    if (jj_scan_token(12)) {
    jj_scanpos = xsp;
    if (jj_scan_token(15)) {
    jj_scanpos = xsp;
    if (jj_scan_token(17)) {
    jj_scanpos = xsp;
    if (jj_scan_token(18)) {
    jj_scanpos = xsp;
    if (jj_scan_token(19)) {
    jj_scanpos = xsp;
    if (jj_scan_token(20)) {
    jj_scanpos = xsp;
    if (jj_scan_token(21)) {
    jj_scanpos = xsp;
    if (jj_scan_token(22)) {
    jj_scanpos = xsp;
    if (jj_scan_token(23)) {
    jj_scanpos = xsp;
    if (jj_scan_token(24)) {
    jj_scanpos = xsp;
    if (jj_scan_token(26)) {
    jj_scanpos = xsp;
    if (jj_scan_token(27)) {
    jj_scanpos = xsp;
    if (jj_scan_token(28)) {
    jj_scanpos = xsp;
    if (jj_scan_token(29)) {
    jj_scanpos = xsp;
    if (jj_scan_token(30)) {
    jj_scanpos = xsp;
    if (jj_scan_token(2)) {
    jj_scanpos = xsp;
    if (jj_scan_token(31)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_51() {
    Token xsp;
    if (jj_scan_token(1)) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(1)) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_101()) return true;
    return false;
  }

  private boolean jj_3R_111() {
    Token xsp;
    if (jj_3R_161()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_161()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_144() {
    if (jj_scan_token(SLASH)) return true;
    if (jj_3R_196()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(1)) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(GT)) return true;
    return false;
  }

  private boolean jj_3R_198() {
    if (jj_scan_token(GT)) return true;
    return false;
  }

  private boolean jj_3R_123() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(8)) {
    jj_scanpos = xsp;
    if (jj_scan_token(7)) return true;
    }
    return false;
  }

  private boolean jj_3_52() {
    if (jj_scan_token(SLASH)) return true;
    if (jj_scan_token(GT)) return true;
    return false;
  }

  private boolean jj_3R_197() {
    if (jj_3R_237()) return true;
    return false;
  }

  private boolean jj_3R_143() {
    if (jj_3R_196()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_197()) jj_scanpos = xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(1)) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3_52()) {
    jj_scanpos = xsp;
    if (jj_3R_198()) return true;
    }
    return false;
  }

  private boolean jj_3R_82() {
    if (jj_scan_token(LT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_143()) {
    jj_scanpos = xsp;
    if (jj_3R_144()) return true;
    }
    return false;
  }

  private boolean jj_3R_60() {
    if (jj_scan_token(LT)) return true;
    if (jj_scan_token(CHAR_SEQUENCE)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_123()) { jj_scanpos = xsp; break; }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_124()) { jj_scanpos = xsp; break; }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(1)) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_scan_token(29)) jj_scanpos = xsp;
    if (jj_scan_token(GT)) return true;
    return false;
  }

  private boolean jj_3R_207() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(8)) {
    jj_scanpos = xsp;
    if (jj_scan_token(7)) {
    jj_scanpos = xsp;
    if (jj_scan_token(23)) {
    jj_scanpos = xsp;
    if (jj_scan_token(31)) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_243() {
    if (jj_scan_token(DOUBLE_QUOTE)) return true;
    return false;
  }

  private boolean jj_3R_152() {
    if (jj_scan_token(CHAR_SEQUENCE)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_207()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_242() {
    if (jj_3R_250()) return true;
    return false;
  }

  private boolean jj_3R_209() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_242()) {
    jj_scanpos = xsp;
    if (jj_3R_243()) return true;
    }
    return false;
  }

  private boolean jj_3R_241() {
    if (jj_scan_token(SINGLE_QUOTE)) return true;
    return false;
  }

  private boolean jj_3R_104() {
    if (jj_3R_156()) return true;
    return false;
  }

  private boolean jj_3R_240() {
    if (jj_3R_250()) return true;
    return false;
  }

  private boolean jj_3R_154() {
    if (jj_scan_token(SINGLE_QUOTE)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_209()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(SINGLE_QUOTE)) return true;
    return false;
  }

  private boolean jj_3R_208() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_240()) {
    jj_scanpos = xsp;
    if (jj_3R_241()) return true;
    }
    return false;
  }

  private boolean jj_3R_103() {
    if (jj_3R_155()) return true;
    return false;
  }

  private boolean jj_3R_153() {
    if (jj_scan_token(DOUBLE_QUOTE)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_208()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(DOUBLE_QUOTE)) return true;
    return false;
  }

  private boolean jj_3_49() {
    Token xsp;
    if (jj_scan_token(1)) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(1)) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_101()) return true;
    return false;
  }

  private boolean jj_3R_101() {
    if (jj_3R_152()) return true;
    if (jj_scan_token(EQ)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_153()) {
    jj_scanpos = xsp;
    if (jj_3R_154()) return true;
    }
    return false;
  }

  private boolean jj_3_50() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_103()) {
    jj_scanpos = xsp;
    if (jj_3R_104()) return true;
    }
    return false;
  }

  private boolean jj_3R_102() {
    Token xsp;
    if (jj_3_50()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_50()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_249() {
    Token xsp;
    if (jj_scan_token(1)) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(1)) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_101()) return true;
    return false;
  }

  private boolean jj_3R_237() {
    Token xsp;
    if (jj_3R_249()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_249()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_236() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(8)) {
    jj_scanpos = xsp;
    if (jj_scan_token(7)) return true;
    }
    return false;
  }

  private boolean jj_3R_248() {
    if (jj_3R_162()) return true;
    return false;
  }

  private boolean jj_3R_196() {
    if (jj_scan_token(CHAR_SEQUENCE)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_236()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_47() {
    if (jj_3R_102()) return true;
    return false;
  }

  private boolean jj_3_46() {
    Token xsp;
    if (jj_scan_token(1)) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(1)) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_101()) return true;
    return false;
  }

  private boolean jj_3_48() {
    if (jj_scan_token(SLASH)) return true;
    if (jj_scan_token(GT)) return true;
    return false;
  }

  private boolean jj_3R_155() {
    if (jj_scan_token(LT)) return true;
    if (jj_3R_196()) return true;
    return false;
  }

  private boolean jj_3R_223() {
    if (jj_3R_162()) return true;
    return false;
  }

  private boolean jj_3R_224() {
    if (jj_3R_113()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_248()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_183() {
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_223()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_224()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_138() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_182()) {
    jj_scanpos = xsp;
    if (jj_3R_183()) return true;
    }
    return false;
  }

  private boolean jj_3R_182() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(1)) jj_scanpos = xsp;
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_3R_111()) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_137() {
    if (jj_3R_111()) return true;
    return false;
  }

  private boolean jj_3R_78() {
    if (jj_scan_token(BANG)) return true;
    if (jj_scan_token(LBRACKET)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_137()) jj_scanpos = xsp;
    if (jj_scan_token(RBRACKET)) return true;
    xsp = jj_scanpos;
    if (jj_3R_138()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_239() {
    if (jj_3R_162()) return true;
    return false;
  }

  private boolean jj_3R_151() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(7)) {
    jj_scanpos = xsp;
    if (jj_scan_token(1)) {
    jj_scanpos = xsp;
    if (jj_scan_token(8)) {
    jj_scanpos = xsp;
    if (jj_scan_token(9)) {
    jj_scanpos = xsp;
    if (jj_scan_token(10)) {
    jj_scanpos = xsp;
    if (jj_scan_token(11)) {
    jj_scanpos = xsp;
    if (jj_scan_token(12)) {
    jj_scanpos = xsp;
    if (jj_scan_token(15)) {
    jj_scanpos = xsp;
    if (jj_scan_token(14)) {
    jj_scanpos = xsp;
    if (jj_scan_token(13)) {
    jj_scanpos = xsp;
    if (jj_scan_token(16)) {
    jj_scanpos = xsp;
    if (jj_scan_token(17)) {
    jj_scanpos = xsp;
    if (jj_scan_token(3)) {
    jj_scanpos = xsp;
    if (jj_scan_token(18)) {
    jj_scanpos = xsp;
    if (jj_scan_token(6)) {
    jj_scanpos = xsp;
    if (jj_scan_token(19)) {
    jj_scanpos = xsp;
    if (jj_scan_token(21)) {
    jj_scanpos = xsp;
    if (jj_scan_token(22)) {
    jj_scanpos = xsp;
    if (jj_scan_token(23)) {
    jj_scanpos = xsp;
    if (jj_scan_token(24)) {
    jj_scanpos = xsp;
    if (jj_scan_token(26)) {
    jj_scanpos = xsp;
    if (jj_scan_token(27)) {
    jj_scanpos = xsp;
    if (jj_scan_token(28)) {
    jj_scanpos = xsp;
    if (jj_scan_token(29)) {
    jj_scanpos = xsp;
    if (jj_scan_token(30)) {
    jj_scanpos = xsp;
    if (jj_scan_token(2)) {
    jj_scanpos = xsp;
    if (jj_scan_token(31)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_203() {
    if (jj_3R_113()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_239()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_202() {
    if (jj_3R_162()) return true;
    return false;
  }

  private boolean jj_3R_147() {
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_202()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_203()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_238() {
    if (jj_3R_162()) return true;
    return false;
  }

  private boolean jj_3R_201() {
    if (jj_3R_111()) return true;
    return false;
  }

  private boolean jj_3R_200() {
    if (jj_scan_token(EOL)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_238()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_255() {
    if (jj_3R_151()) return true;
    return false;
  }

  private boolean jj_3_44() {
    if (jj_3R_78()) return true;
    return false;
  }

  private boolean jj_3R_199() {
    if (jj_scan_token(SPACE)) return true;
    return false;
  }

  private boolean jj_3_43() {
    if (jj_3R_79()) return true;
    return false;
  }

  private boolean jj_3_42() {
    if (jj_3R_80()) return true;
    return false;
  }

  private boolean jj_3R_146() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_199()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_200()) jj_scanpos = xsp;
    if (jj_scan_token(LBRACKET)) return true;
    xsp = jj_scanpos;
    if (jj_3R_201()) jj_scanpos = xsp;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_100() {
    if (jj_3R_151()) return true;
    return false;
  }

  private boolean jj_3R_99() {
    if (jj_scan_token(LBRACKET)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_255()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_98() {
    if (jj_3R_78()) return true;
    return false;
  }

  private boolean jj_3R_97() {
    if (jj_3R_79()) return true;
    return false;
  }

  private boolean jj_3R_96() {
    if (jj_3R_80()) return true;
    return false;
  }

  private boolean jj_3R_95() {
    if (jj_3R_150()) return true;
    return false;
  }

  private boolean jj_3R_91() {
    if (jj_3R_147()) return true;
    return false;
  }

  private boolean jj_3R_94() {
    if (jj_3R_149()) return true;
    return false;
  }

  private boolean jj_3_45() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_94()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = CodeSpanLookahead();
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_95()) {
    jj_scanpos = xsp;
    if (jj_3R_96()) {
    jj_scanpos = xsp;
    if (jj_3R_97()) {
    jj_scanpos = xsp;
    if (jj_3R_98()) {
    jj_scanpos = xsp;
    if (jj_3R_99()) {
    jj_scanpos = xsp;
    if (jj_3R_100()) return true;
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_93() {
    Token xsp;
    if (jj_3_45()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_45()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_205() {
    if (jj_3R_151()) return true;
    return false;
  }

  private boolean jj_3R_148() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_204()) {
    jj_scanpos = xsp;
    if (jj_3R_205()) return true;
    }
    return false;
  }

  private boolean jj_3R_204() {
    if (jj_3R_149()) return true;
    return false;
  }

  private boolean jj_3R_92() {
    Token xsp;
    if (jj_3R_148()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_148()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_181() {
    if (jj_3R_146()) return true;
    return false;
  }

  private boolean jj_3R_90() {
    if (jj_3R_146()) return true;
    return false;
  }

  private boolean jj_3_39() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_90()) {
    jj_scanpos = xsp;
    if (jj_3R_91()) return true;
    }
    return false;
  }

  private boolean jj_3R_180() {
    if (jj_3R_147()) return true;
    return false;
  }

  private boolean jj_3_41() {
    if (jj_3R_93()) return true;
    if (jj_scan_token(RBRACKET)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_180()) {
    jj_scanpos = xsp;
    if (jj_3R_181()) return true;
    }
    return false;
  }

  private boolean jj_3R_222() {
    if (jj_3R_146()) return true;
    return false;
  }

  private boolean jj_3_40() {
    if (jj_3R_92()) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_221() {
    if (jj_3R_147()) return true;
    return false;
  }

  private boolean jj_3R_179() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_221()) {
    jj_scanpos = xsp;
    if (jj_3R_222()) return true;
    }
    return false;
  }

  private boolean jj_3R_136() {
    if (jj_3R_92()) return true;
    if (jj_scan_token(RBRACKET)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_179()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_77() {
    if (jj_scan_token(LBRACKET)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_136()) {
    jj_scanpos = xsp;
    if (jj_3_41()) return true;
    }
    return false;
  }

  private boolean jj_3R_140() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(7)) {
    jj_scanpos = xsp;
    if (jj_scan_token(8)) {
    jj_scanpos = xsp;
    if (jj_scan_token(9)) {
    jj_scanpos = xsp;
    if (jj_scan_token(10)) {
    jj_scanpos = xsp;
    if (jj_scan_token(15)) {
    jj_scanpos = xsp;
    if (jj_scan_token(17)) {
    jj_scanpos = xsp;
    if (jj_scan_token(18)) {
    jj_scanpos = xsp;
    if (jj_scan_token(20)) {
    jj_scanpos = xsp;
    if (jj_scan_token(21)) {
    jj_scanpos = xsp;
    if (jj_scan_token(23)) {
    jj_scanpos = xsp;
    if (jj_scan_token(25)) {
    jj_scanpos = xsp;
    if (jj_scan_token(26)) {
    jj_scanpos = xsp;
    if (jj_scan_token(27)) {
    jj_scanpos = xsp;
    if (jj_scan_token(29)) {
    jj_scanpos = xsp;
    if (jj_scan_token(31)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_235() {
    if (jj_scan_token(UNDERSCORE)) return true;
    return false;
  }

  private boolean jj_3R_139() {
    if (jj_scan_token(SLASH)) return true;
    return false;
  }

  private boolean jj_3R_225() {
    if (jj_scan_token(UNDERSCORE)) return true;
    return false;
  }

  private boolean jj_3R_79() {
    if (jj_scan_token(LT)) return true;
    if (jj_scan_token(CHAR_SEQUENCE)) return true;
    if (jj_scan_token(COLON)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_139()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(CHAR_SEQUENCE)) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_140()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(GT)) return true;
    return false;
  }

  private boolean jj_3R_193() {
    if (jj_scan_token(UNDERSCORE)) return true;
    return false;
  }

  private boolean jj_3R_231() {
    if (jj_scan_token(STAR)) return true;
    return false;
  }

  private boolean jj_3R_230() {
    if (jj_scan_token(STAR)) return true;
    return false;
  }

  private boolean jj_3R_89() {
    if (jj_scan_token(EOL)) return true;
    return false;
  }

  private boolean jj_3R_88() {
    if (jj_3R_145()) return true;
    return false;
  }

  private boolean jj_3R_187() {
    if (jj_scan_token(STAR)) return true;
    return false;
  }

  private boolean jj_3_38() {
    Token xsp;
    xsp = jj_scanpos;
    jj_lookingAhead = true;
    jj_semLA = getToken(1).none(EOL,COMMENT_CLOSE);
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_88()) {
    jj_scanpos = xsp;
    if (jj_3R_89()) return true;
    }
    return false;
  }

  private boolean jj_3R_234() {
    if (jj_3R_226()) return true;
    return false;
  }

  private boolean jj_3R_59() {
    if (jj_scan_token(COMMENT_OPEN)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_38()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(COMMENT_CLOSE)) return true;
    return false;
  }

  private boolean jj_3R_192() {
    if (jj_3R_226()) return true;
    return false;
  }

  private boolean jj_3R_195() {
    if (jj_scan_token(STAR)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(30)) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_229() {
    if (jj_3R_226()) return true;
    return false;
  }

  private boolean jj_3R_189() {
    if (jj_scan_token(UNDERSCORE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(31)) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_233() {
    if (jj_3R_149()) return true;
    return false;
  }

  private boolean jj_3R_190() {
    if (jj_scan_token(STAR)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_231()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_232() {
    if (jj_scan_token(SPACE)) return true;
    return false;
  }

  private boolean jj_3R_184() {
    if (jj_scan_token(UNDERSCORE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_225()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_186() {
    if (jj_3R_226()) return true;
    return false;
  }

  private boolean jj_3R_194() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_232()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_233()) {
    jj_scanpos = xsp;
    if (jj_3R_234()) {
    jj_scanpos = xsp;
    if (jj_3R_235()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_191() {
    if (jj_3R_149()) return true;
    return false;
  }

  private boolean jj_3R_228() {
    if (jj_3R_149()) return true;
    return false;
  }

  private boolean jj_3R_227() {
    if (jj_scan_token(SPACE)) return true;
    return false;
  }

  private boolean jj_3R_142() {
    if (jj_scan_token(STAR)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_190()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_191()) {
    jj_scanpos = xsp;
    if (jj_3R_192()) {
    jj_scanpos = xsp;
    if (jj_3R_193()) return true;
    }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_194()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(STAR)) return true;
    xsp = jj_scanpos;
    if (jj_3R_195()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_188() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_227()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_228()) {
    jj_scanpos = xsp;
    if (jj_3R_229()) {
    jj_scanpos = xsp;
    if (jj_3R_230()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_185() {
    if (jj_3R_149()) return true;
    return false;
  }

  private boolean jj_3R_141() {
    if (jj_scan_token(UNDERSCORE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_184()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_185()) {
    jj_scanpos = xsp;
    if (jj_3R_186()) {
    jj_scanpos = xsp;
    if (jj_3R_187()) return true;
    }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_188()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(UNDERSCORE)) return true;
    xsp = jj_scanpos;
    if (jj_3R_189()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_80() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_141()) {
    jj_scanpos = xsp;
    if (jj_3R_142()) return true;
    }
    return false;
  }

  /** Generated Token Manager. */
  public ParserTokenManager token_source;
  SimpleCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  /** Whether we are looking ahead. */
  private boolean jj_lookingAhead = false;
  private boolean jj_semLA;
  private int jj_gen;
  final private int[] jj_la1 = new int[150];
  static private int[] jj_la1_0;
  static {
      jj_la1_init_0();
   }
   private static void jj_la1_init_0() {
      jj_la1_0 = new int[] {0x8,0x2,0x6,0x6,0x6,0x2,0x2,0x6,0x9,0x8000000,0x8000000,0x6,0x8000000,0x8000000,0x8000000,0x8000000,0x8000000,0x40000,0x800000,0x840000,0x2,0x2,0x2,0x2,0x2,0x2,0x2,0x2,0x2,0xc0800000,0x6,0x80006,0x2,0x6,0x6,0x6,0xfffffff6,0xfffffff2,0xfffffff6,0x2,0x2,0x6,0x6,0x80006,0x80006,0x80006,0x80006,0x41800100,0x6,0x41800100,0x6,0x80006,0x80006,0x30,0xffffffc6,0x30,0x800,0x6,0x8,0x6,0xfffff7f6,0x8,0x6,0x800,0xfffff7f6,0x80000000,0x80000000,0x7ffffff4,0x7ffffff6,0x2,0x7ffffff4,0x80000000,0x80000000,0x40000000,0x40000000,0xbffffff4,0xbffffff6,0x2,0xbffffff4,0x40000000,0x40000000,0xc0000000,0x8,0x20000000,0xaeb68780,0xaeb68780,0x30000a,0x30000a,0xfdeffffe,0xfdeffffe,0xfdefffce,0x30,0xfdffffce,0x2,0x6,0x8,0xfdfe9f86,0x6,0x6,0xabf69782,0xfdefffce,0xfdfe9f86,0x2,0x6,0x6,0xabf69782,0x300002,0x300002,0x2,0x2,0x80000,0x180,0x180,0x2,0xfffffffe,0xfdae9ffe,0xfdae9ffe,0xedaf9ffe,0xedaf9ffe,0x10010000,0x80800180,0x80800180,0x180,0x180,0x2,0x2,0x2,0x20000000,0x2,0x80000,0x2,0x20000080,0xfdfe9f86,0xfdfe9f86,0xabf69782,0x10010000,0x6,0x2,0xabb69782,0xab969780,0xfffe9f86,0xfffe9f86,0xefff9f86,0xefff9f86,0x10010000,0xeffe9f86,0xffffffc6,0x3fffffc4,0xedae9ffe,0xffbffffe,};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[55];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /** Constructor with InputStream. */
  public Parser(java.io.InputStream stream) {
     this(stream, null);
  }
  /** Constructor with InputStream and supplied encoding */
  public Parser(java.io.InputStream stream, String encoding) {
    try { jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source = new ParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 150; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream) {
     ReInit(stream, null);
  }
  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream, String encoding) {
    try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jjtree.reset();
    jj_gen = 0;
    for (int i = 0; i < 150; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor. */
  public Parser(java.io.Reader stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new ParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 150; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jjtree.reset();
    jj_gen = 0;
    for (int i = 0; i < 150; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor with generated Token Manager. */
  public Parser(ParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 150; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(ParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jjtree.reset();
    jj_gen = 0;
    for (int i = 0; i < 150; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }


/** Get the next Token. */
  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
    Token t = jj_lookingAhead ? jj_scanpos : token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      jj_entries_loop: for (java.util.Iterator<?> it = jj_expentries.iterator(); it.hasNext();) {
        int[] oldentry = (int[])(it.next());
        if (oldentry.length == jj_expentry.length) {
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              continue jj_entries_loop;
            }
          }
          jj_expentries.add(jj_expentry);
          break jj_entries_loop;
        }
      }
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  /** Generate ParseException. */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[32];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 150; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 32; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

  private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 55; i++) {
    try {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
            case 1: jj_3_2(); break;
            case 2: jj_3_3(); break;
            case 3: jj_3_4(); break;
            case 4: jj_3_5(); break;
            case 5: jj_3_6(); break;
            case 6: jj_3_7(); break;
            case 7: jj_3_8(); break;
            case 8: jj_3_9(); break;
            case 9: jj_3_10(); break;
            case 10: jj_3_11(); break;
            case 11: jj_3_12(); break;
            case 12: jj_3_13(); break;
            case 13: jj_3_14(); break;
            case 14: jj_3_15(); break;
            case 15: jj_3_16(); break;
            case 16: jj_3_17(); break;
            case 17: jj_3_18(); break;
            case 18: jj_3_19(); break;
            case 19: jj_3_20(); break;
            case 20: jj_3_21(); break;
            case 21: jj_3_22(); break;
            case 22: jj_3_23(); break;
            case 23: jj_3_24(); break;
            case 24: jj_3_25(); break;
            case 25: jj_3_26(); break;
            case 26: jj_3_27(); break;
            case 27: jj_3_28(); break;
            case 28: jj_3_29(); break;
            case 29: jj_3_30(); break;
            case 30: jj_3_31(); break;
            case 31: jj_3_32(); break;
            case 32: jj_3_33(); break;
            case 33: jj_3_34(); break;
            case 34: jj_3_35(); break;
            case 35: jj_3_36(); break;
            case 36: jj_3_37(); break;
            case 37: jj_3_38(); break;
            case 38: jj_3_39(); break;
            case 39: jj_3_40(); break;
            case 40: jj_3_41(); break;
            case 41: jj_3_42(); break;
            case 42: jj_3_43(); break;
            case 43: jj_3_44(); break;
            case 44: jj_3_45(); break;
            case 45: jj_3_46(); break;
            case 46: jj_3_47(); break;
            case 47: jj_3_48(); break;
            case 48: jj_3_49(); break;
            case 49: jj_3_50(); break;
            case 50: jj_3_51(); break;
            case 51: jj_3_52(); break;
            case 52: jj_3_53(); break;
            case 53: jj_3_54(); break;
            case 54: jj_3_55(); break;
          }
        }
        p = p.next;
      } while (p != null);
      } catch(LookaheadSuccess ls) { }
    }
    jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
