/*
 * Decompiled with CFR 0.152.
 */
package org.tautua.markdownpapers.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class Utils {
    public static final char TAB = '\t';
    public static final char EOL = '\n';
    public static final char SPACE = ' ';
    public static final char QUOTE = '\"';
    public static final char AMPERSAND = '&';
    public static final char LT = '<';
    public static final char GT = '>';
    public static final String EMPTY_STRING = "";
    private static final Map<Character, String> ESCAPED_CHARS = new HashMap<Character, String>();
    private static final Set<String> HTML_EMPTY_TAGS;

    public static String escape(char character) {
        String escaped = ESCAPED_CHARS.get(Character.valueOf(character));
        return escaped == null ? String.valueOf(character) : escaped;
    }

    public static boolean isBlank(String val) {
        return val == null || val.trim().equals(EMPTY_STRING);
    }

    public static boolean isEmptyTag(String tagName) {
        return HTML_EMPTY_TAGS.contains(tagName);
    }

    static {
        ESCAPED_CHARS.put(Character.valueOf('&'), "&amp;");
        ESCAPED_CHARS.put(Character.valueOf('<'), "&lt;");
        ESCAPED_CHARS.put(Character.valueOf('>'), "&gt;");
        ESCAPED_CHARS.put(Character.valueOf('\"'), "&quot;");
        HTML_EMPTY_TAGS = new HashSet<String>();
        HTML_EMPTY_TAGS.add("area");
        HTML_EMPTY_TAGS.add("base");
        HTML_EMPTY_TAGS.add("br");
        HTML_EMPTY_TAGS.add("col");
        HTML_EMPTY_TAGS.add("command");
        HTML_EMPTY_TAGS.add("embed");
        HTML_EMPTY_TAGS.add("hr");
        HTML_EMPTY_TAGS.add("img");
        HTML_EMPTY_TAGS.add("input");
        HTML_EMPTY_TAGS.add("keygen");
        HTML_EMPTY_TAGS.add("link");
        HTML_EMPTY_TAGS.add("meta");
        HTML_EMPTY_TAGS.add("param");
        HTML_EMPTY_TAGS.add("source");
        HTML_EMPTY_TAGS.add("track");
        HTML_EMPTY_TAGS.add("wbr");
    }
}

