/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.api.methods.stickers;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Preconditions;
import java.io.IOException;
import org.telegram.telegrambots.api.methods.BotApiMethod;
import org.telegram.telegrambots.api.objects.replykeyboard.ApiResponse;
import org.telegram.telegrambots.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.exceptions.TelegramApiValidationException;

public class DeleteStickerFromSet
extends BotApiMethod<Boolean> {
    private static final String PATH = "deleteStickerFromSet";
    private static final String STICKER_FIELD = "sticker";
    @JsonProperty(value="sticker")
    private String sticker;

    public DeleteStickerFromSet() {
    }

    public DeleteStickerFromSet(String sticker) {
        this.sticker = (String)Preconditions.checkNotNull((Object)sticker);
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public Boolean deserializeResponse(String answer) throws TelegramApiRequestException {
        try {
            ApiResponse result = (ApiResponse)OBJECT_MAPPER.readValue(answer, (TypeReference)new TypeReference<ApiResponse<Boolean>>(){});
            if (result.getOk().booleanValue()) {
                return (Boolean)result.getResult();
            }
            throw new TelegramApiRequestException("Error deleting sticker from set", result);
        }
        catch (IOException e) {
            throw new TelegramApiRequestException("Unable to deserialize response", e);
        }
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.sticker == null || this.sticker.isEmpty()) {
            throw new TelegramApiValidationException("sticker can't be null", this);
        }
    }

    public String getSticker() {
        return this.sticker;
    }

    public DeleteStickerFromSet setSticker(String sticker) {
        this.sticker = sticker;
        return this;
    }

    public String toString() {
        return "DeleteStickerFromSet{sticker='" + this.sticker + '\'' + '}';
    }
}

