/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.updatingmessages;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Objects;
import org.telegram.telegrambots.meta.api.methods.BotApiMethod;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.ApiResponse;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class DeleteMessage
extends BotApiMethod<Boolean> {
    public static final String PATH = "deleteMessage";
    private static final String CHATID_FIELD = "chat_id";
    private static final String MESSAGEID_FIELD = "message_id";
    @JsonProperty(value="chat_id")
    private String chatId;
    @JsonProperty(value="message_id")
    private Integer messageId;

    public DeleteMessage() {
    }

    public DeleteMessage(String chatId, Integer messageId) {
        this.chatId = (String)Preconditions.checkNotNull((Object)chatId);
        this.messageId = (Integer)Preconditions.checkNotNull((Object)messageId);
    }

    public DeleteMessage(Long chatId, Integer messageId) {
        this.chatId = ((Long)Preconditions.checkNotNull((Object)chatId)).toString();
        this.messageId = (Integer)Preconditions.checkNotNull((Object)messageId);
    }

    public String getChatId() {
        return this.chatId;
    }

    public DeleteMessage setChatId(String chatId) {
        this.chatId = chatId;
        return this;
    }

    public DeleteMessage setChatId(Long chatId) {
        Objects.requireNonNull(chatId);
        this.chatId = chatId.toString();
        return this;
    }

    public Integer getMessageId() {
        return this.messageId;
    }

    public DeleteMessage setMessageId(Integer messageId) {
        this.messageId = messageId;
        return this;
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public Boolean deserializeResponse(String answer) throws TelegramApiRequestException {
        try {
            ApiResponse result = (ApiResponse)OBJECT_MAPPER.readValue(answer, (TypeReference)new TypeReference<ApiResponse<Boolean>>(){});
            if (result.getOk().booleanValue()) {
                return (Boolean)result.getResult();
            }
            throw new TelegramApiRequestException("Error deleting message", result);
        }
        catch (IOException e) {
            throw new TelegramApiRequestException("Unable to deserialize response", e);
        }
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.chatId == null) {
            throw new TelegramApiValidationException("ChatId parameter can't be empty", this);
        }
        if (this.messageId == null) {
            throw new TelegramApiValidationException("MessageId parameter can't be empty", this);
        }
    }

    public String toString() {
        return "DeleteMessage{chatId='" + this.chatId + '\'' + ", messageId=" + this.messageId + '}';
    }
}

