/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects.replykeyboard.buttons;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.interfaces.BotApiObject;
import org.telegram.telegrambots.meta.api.interfaces.Validable;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.buttons.KeyboardButtonPollType;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.buttons.KeyboardButtonRequestChat;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.buttons.KeyboardButtonRequestUser;
import org.telegram.telegrambots.meta.api.objects.webapp.WebAppInfo;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class KeyboardButton
implements Validable,
BotApiObject {
    private static final String TEXT_FIELD = "text";
    private static final String REQUEST_CONTACT_FIELD = "request_contact";
    private static final String REQUEST_LOCATION_FIELD = "request_location";
    private static final String REQUEST_POLL_FIELD = "request_poll";
    private static final String WEBAPP_FIELD = "web_app";
    private static final String REQUESTUSER_FIELD = "request_user";
    private static final String REQUESTCHAT_FIELD = "request_chat";
    @JsonProperty(value="text")
    @NonNull
    private String text;
    @JsonProperty(value="request_contact")
    private Boolean requestContact;
    @JsonProperty(value="request_location")
    private Boolean requestLocation;
    @JsonProperty(value="request_poll")
    private KeyboardButtonPollType requestPoll;
    @JsonProperty(value="web_app")
    private WebAppInfo webApp;
    @JsonProperty(value="request_user")
    private KeyboardButtonRequestUser requestUser;
    @JsonProperty(value="request_chat")
    private KeyboardButtonRequestChat requestChat;

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.text.isEmpty()) {
            throw new TelegramApiValidationException("Text parameter can't be empty", this);
        }
        int requestsProvided = 0;
        requestsProvided += this.requestContact == null ? 0 : 1;
        requestsProvided += this.requestLocation == null ? 0 : 1;
        requestsProvided += this.requestPoll == null ? 0 : 1;
        requestsProvided += this.webApp == null ? 0 : 1;
        requestsProvided += this.requestUser == null ? 0 : 1;
        if ((requestsProvided += this.requestChat == null ? 0 : 1) > 1) {
            throw new TelegramApiValidationException("The optional fields web_app, request_user, request_chat, request_contact, request_location, and request_poll are mutually exclusive", this);
        }
        if (this.webApp != null) {
            this.webApp.validate();
        }
        if (this.requestPoll != null) {
            this.requestPoll.validate();
        }
        if (this.requestUser != null) {
            this.requestUser.validate();
        }
        if (this.requestChat != null) {
            this.requestChat.validate();
        }
    }

    public static KeyboardButtonBuilder builder() {
        return new KeyboardButtonBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KeyboardButton)) {
            return false;
        }
        KeyboardButton other = (KeyboardButton)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$requestContact = this.getRequestContact();
        Boolean other$requestContact = other.getRequestContact();
        if (this$requestContact == null ? other$requestContact != null : !((Object)this$requestContact).equals(other$requestContact)) {
            return false;
        }
        Boolean this$requestLocation = this.getRequestLocation();
        Boolean other$requestLocation = other.getRequestLocation();
        if (this$requestLocation == null ? other$requestLocation != null : !((Object)this$requestLocation).equals(other$requestLocation)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
            return false;
        }
        KeyboardButtonPollType this$requestPoll = this.getRequestPoll();
        KeyboardButtonPollType other$requestPoll = other.getRequestPoll();
        if (this$requestPoll == null ? other$requestPoll != null : !((Object)this$requestPoll).equals(other$requestPoll)) {
            return false;
        }
        WebAppInfo this$webApp = this.getWebApp();
        WebAppInfo other$webApp = other.getWebApp();
        if (this$webApp == null ? other$webApp != null : !((Object)this$webApp).equals(other$webApp)) {
            return false;
        }
        KeyboardButtonRequestUser this$requestUser = this.getRequestUser();
        KeyboardButtonRequestUser other$requestUser = other.getRequestUser();
        if (this$requestUser == null ? other$requestUser != null : !((Object)this$requestUser).equals(other$requestUser)) {
            return false;
        }
        KeyboardButtonRequestChat this$requestChat = this.getRequestChat();
        KeyboardButtonRequestChat other$requestChat = other.getRequestChat();
        return !(this$requestChat == null ? other$requestChat != null : !((Object)this$requestChat).equals(other$requestChat));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KeyboardButton;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $requestContact = this.getRequestContact();
        result = result * 59 + ($requestContact == null ? 43 : ((Object)$requestContact).hashCode());
        Boolean $requestLocation = this.getRequestLocation();
        result = result * 59 + ($requestLocation == null ? 43 : ((Object)$requestLocation).hashCode());
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        KeyboardButtonPollType $requestPoll = this.getRequestPoll();
        result = result * 59 + ($requestPoll == null ? 43 : ((Object)$requestPoll).hashCode());
        WebAppInfo $webApp = this.getWebApp();
        result = result * 59 + ($webApp == null ? 43 : ((Object)$webApp).hashCode());
        KeyboardButtonRequestUser $requestUser = this.getRequestUser();
        result = result * 59 + ($requestUser == null ? 43 : ((Object)$requestUser).hashCode());
        KeyboardButtonRequestChat $requestChat = this.getRequestChat();
        result = result * 59 + ($requestChat == null ? 43 : ((Object)$requestChat).hashCode());
        return result;
    }

    @NonNull
    public String getText() {
        return this.text;
    }

    public Boolean getRequestContact() {
        return this.requestContact;
    }

    public Boolean getRequestLocation() {
        return this.requestLocation;
    }

    public KeyboardButtonPollType getRequestPoll() {
        return this.requestPoll;
    }

    public WebAppInfo getWebApp() {
        return this.webApp;
    }

    public KeyboardButtonRequestUser getRequestUser() {
        return this.requestUser;
    }

    public KeyboardButtonRequestChat getRequestChat() {
        return this.requestChat;
    }

    @JsonProperty(value="text")
    public void setText(@NonNull String text) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        this.text = text;
    }

    @JsonProperty(value="request_contact")
    public void setRequestContact(Boolean requestContact) {
        this.requestContact = requestContact;
    }

    @JsonProperty(value="request_location")
    public void setRequestLocation(Boolean requestLocation) {
        this.requestLocation = requestLocation;
    }

    @JsonProperty(value="request_poll")
    public void setRequestPoll(KeyboardButtonPollType requestPoll) {
        this.requestPoll = requestPoll;
    }

    @JsonProperty(value="web_app")
    public void setWebApp(WebAppInfo webApp) {
        this.webApp = webApp;
    }

    @JsonProperty(value="request_user")
    public void setRequestUser(KeyboardButtonRequestUser requestUser) {
        this.requestUser = requestUser;
    }

    @JsonProperty(value="request_chat")
    public void setRequestChat(KeyboardButtonRequestChat requestChat) {
        this.requestChat = requestChat;
    }

    public String toString() {
        return "KeyboardButton(text=" + this.getText() + ", requestContact=" + this.getRequestContact() + ", requestLocation=" + this.getRequestLocation() + ", requestPoll=" + this.getRequestPoll() + ", webApp=" + this.getWebApp() + ", requestUser=" + this.getRequestUser() + ", requestChat=" + this.getRequestChat() + ")";
    }

    public KeyboardButton() {
    }

    public KeyboardButton(@NonNull String text) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        this.text = text;
    }

    public KeyboardButton(@NonNull String text, Boolean requestContact, Boolean requestLocation, KeyboardButtonPollType requestPoll, WebAppInfo webApp, KeyboardButtonRequestUser requestUser, KeyboardButtonRequestChat requestChat) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        this.text = text;
        this.requestContact = requestContact;
        this.requestLocation = requestLocation;
        this.requestPoll = requestPoll;
        this.webApp = webApp;
        this.requestUser = requestUser;
        this.requestChat = requestChat;
    }

    public static class KeyboardButtonBuilder {
        private String text;
        private Boolean requestContact;
        private Boolean requestLocation;
        private KeyboardButtonPollType requestPoll;
        private WebAppInfo webApp;
        private KeyboardButtonRequestUser requestUser;
        private KeyboardButtonRequestChat requestChat;

        KeyboardButtonBuilder() {
        }

        @JsonProperty(value="text")
        public KeyboardButtonBuilder text(@NonNull String text) {
            if (text == null) {
                throw new NullPointerException("text is marked non-null but is null");
            }
            this.text = text;
            return this;
        }

        @JsonProperty(value="request_contact")
        public KeyboardButtonBuilder requestContact(Boolean requestContact) {
            this.requestContact = requestContact;
            return this;
        }

        @JsonProperty(value="request_location")
        public KeyboardButtonBuilder requestLocation(Boolean requestLocation) {
            this.requestLocation = requestLocation;
            return this;
        }

        @JsonProperty(value="request_poll")
        public KeyboardButtonBuilder requestPoll(KeyboardButtonPollType requestPoll) {
            this.requestPoll = requestPoll;
            return this;
        }

        @JsonProperty(value="web_app")
        public KeyboardButtonBuilder webApp(WebAppInfo webApp) {
            this.webApp = webApp;
            return this;
        }

        @JsonProperty(value="request_user")
        public KeyboardButtonBuilder requestUser(KeyboardButtonRequestUser requestUser) {
            this.requestUser = requestUser;
            return this;
        }

        @JsonProperty(value="request_chat")
        public KeyboardButtonBuilder requestChat(KeyboardButtonRequestChat requestChat) {
            this.requestChat = requestChat;
            return this;
        }

        public KeyboardButton build() {
            return new KeyboardButton(this.text, this.requestContact, this.requestLocation, this.requestPoll, this.webApp, this.requestUser, this.requestChat);
        }

        public String toString() {
            return "KeyboardButton.KeyboardButtonBuilder(text=" + this.text + ", requestContact=" + this.requestContact + ", requestLocation=" + this.requestLocation + ", requestPoll=" + this.requestPoll + ", webApp=" + this.webApp + ", requestUser=" + this.requestUser + ", requestChat=" + this.requestChat + ")";
        }
    }
}

