/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.groupadministration;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.List;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.botapimethods.BotApiMethodBoolean;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class SetChatTitle
extends BotApiMethodBoolean {
    public static final String PATH = "setChatTitle";
    private static final String CHATID_FIELD = "chat_id";
    private static final String TITLE_FIELD = "title";
    @JsonProperty(value="chat_id")
    @NonNull
    private String chatId;
    @JsonProperty(value="title")
    @NonNull
    private String title;
    private long[] otherUserIds;
    private byte[] fileHashes;

    public void setChatId(@NonNull Long chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId.toString();
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.chatId.isEmpty()) {
            throw new TelegramApiValidationException("ChatId can't be empty", this);
        }
        if (this.title.isEmpty()) {
            throw new TelegramApiValidationException("Title can't be empty", this);
        }
    }

    public static SetChatTitleBuilder builder() {
        return new SetChatTitleBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SetChatTitle)) {
            return false;
        }
        SetChatTitle other = (SetChatTitle)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$chatId = this.getChatId();
        String other$chatId = other.getChatId();
        if (this$chatId == null ? other$chatId != null : !this$chatId.equals(other$chatId)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        if (!Arrays.equals(this.getOtherUserIds(), other.getOtherUserIds())) {
            return false;
        }
        return Arrays.equals(this.getFileHashes(), other.getFileHashes());
    }

    protected boolean canEqual(Object other) {
        return other instanceof SetChatTitle;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $chatId = this.getChatId();
        result = result * 59 + ($chatId == null ? 43 : $chatId.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        result = result * 59 + Arrays.hashCode(this.getOtherUserIds());
        result = result * 59 + Arrays.hashCode(this.getFileHashes());
        return result;
    }

    @NonNull
    public String getChatId() {
        return this.chatId;
    }

    @NonNull
    public String getTitle() {
        return this.title;
    }

    public long[] getOtherUserIds() {
        return this.otherUserIds;
    }

    public byte[] getFileHashes() {
        return this.fileHashes;
    }

    @JsonProperty(value="chat_id")
    public void setChatId(@NonNull String chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId;
    }

    @JsonProperty(value="title")
    public void setTitle(@NonNull String title) {
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        this.title = title;
    }

    public void setOtherUserIds(long[] otherUserIds) {
        this.otherUserIds = otherUserIds;
    }

    public void setFileHashes(byte[] fileHashes) {
        this.fileHashes = fileHashes;
    }

    public String toString() {
        return "SetChatTitle(chatId=" + this.getChatId() + ", title=" + this.getTitle() + ", otherUserIds=" + Arrays.toString(this.getOtherUserIds()) + ", fileHashes=" + Arrays.toString(this.getFileHashes()) + ")";
    }

    public SetChatTitle() {
    }

    public SetChatTitle(@NonNull String chatId, @NonNull String title, long[] otherUserIds, byte[] fileHashes) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        this.chatId = chatId;
        this.title = title;
        this.otherUserIds = otherUserIds;
        this.fileHashes = fileHashes;
    }

    public static class SetChatTitleBuilder {
        private String chatId;
        private String title;
        private long[] otherUserIds;
        private byte[] fileHashes;

        public SetChatTitleBuilder chatId(@NonNull Long chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId.toString();
            return this;
        }

        public SetChatTitleBuilder ids(List<Byte> otherUserIds) {
            this.otherUserIds = new long[otherUserIds.size()];
            for (int i = 0; i < otherUserIds.size(); ++i) {
                this.otherUserIds[i] = otherUserIds.get(i).byteValue();
            }
            return this;
        }

        public SetChatTitleBuilder otherUserId(Long otherUserId) {
            long[] newOtherUserIds = new long[this.otherUserIds.length + 1];
            System.arraycopy(this.otherUserIds, 0, newOtherUserIds, 0, this.otherUserIds.length);
            newOtherUserIds[newOtherUserIds.length - 1] = otherUserId;
            this.otherUserIds = newOtherUserIds;
            return this;
        }

        SetChatTitleBuilder() {
        }

        @JsonProperty(value="chat_id")
        public SetChatTitleBuilder chatId(@NonNull String chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId;
            return this;
        }

        @JsonProperty(value="title")
        public SetChatTitleBuilder title(@NonNull String title) {
            if (title == null) {
                throw new NullPointerException("title is marked non-null but is null");
            }
            this.title = title;
            return this;
        }

        public SetChatTitleBuilder otherUserIds(long[] otherUserIds) {
            this.otherUserIds = otherUserIds;
            return this;
        }

        public SetChatTitleBuilder fileHashes(byte[] fileHashes) {
            this.fileHashes = fileHashes;
            return this;
        }

        public SetChatTitle build() {
            return new SetChatTitle(this.chatId, this.title, this.otherUserIds, this.fileHashes);
        }

        public String toString() {
            return "SetChatTitle.SetChatTitleBuilder(chatId=" + this.chatId + ", title=" + this.title + ", otherUserIds=" + Arrays.toString(this.otherUserIds) + ", fileHashes=" + Arrays.toString(this.fileHashes) + ")";
        }
    }
}

