/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.send;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.send.SendMediaBotMethod;
import org.telegram.telegrambots.meta.api.objects.InputFile;
import org.telegram.telegrambots.meta.api.objects.Message;
import org.telegram.telegrambots.meta.api.objects.MessageEntity;
import org.telegram.telegrambots.meta.api.objects.ReplyParameters;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.ReplyKeyboard;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class SendAudio
extends SendMediaBotMethod<Message> {
    public static final String PATH = "sendaudio";
    public static final String DURATION_FIELD = "duration";
    public static final String CHATID_FIELD = "chat_id";
    public static final String MESSAGETHREADID_FIELD = "message_thread_id";
    public static final String AUDIO_FIELD = "audio";
    public static final String REPLYTOMESSAGEID_FIELD = "reply_to_message_id";
    public static final String DISABLENOTIFICATION_FIELD = "disable_notification";
    public static final String REPLYMARKUP_FIELD = "reply_markup";
    public static final String PERFOMER_FIELD = "performer";
    public static final String TITLE_FIELD = "title";
    public static final String CAPTION_FIELD = "caption";
    public static final String PARSEMODE_FIELD = "parse_mode";
    public static final String THUMBNAIL_FIELD = "thumbnail";
    public static final String CAPTION_ENTITIES_FIELD = "caption_entities";
    public static final String ALLOWSENDINGWITHOUTREPLY_FIELD = "allow_sending_without_reply";
    public static final String PROTECTCONTENT_FIELD = "protect_content";
    public static final String REPLY_PARAMETERS_FIELD = "reply_parameters";
    @NonNull
    private String chatId;
    private Integer messageThreadId;
    @NonNull
    private InputFile audio;
    private Integer replyToMessageId;
    private Boolean disableNotification;
    private ReplyKeyboard replyMarkup;
    private String performer;
    private String title;
    private String caption;
    private String parseMode;
    private Integer duration;
    private InputFile thumbnail;
    private List<MessageEntity> captionEntities;
    private Boolean allowSendingWithoutReply;
    private Boolean protectContent;
    private ReplyParameters replyParameters;

    public void setChatId(@NonNull Long chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId.toString();
    }

    public void enableNotification() {
        this.disableNotification = false;
    }

    public void disableNotification() {
        this.disableNotification = true;
    }

    @Override
    public Message deserializeResponse(String answer) throws TelegramApiRequestException {
        return this.deserializeResponse(answer, Message.class);
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.chatId.isEmpty()) {
            throw new TelegramApiValidationException("ChatId parameter can't be empty", this);
        }
        if (this.parseMode != null && this.captionEntities != null && !this.captionEntities.isEmpty()) {
            throw new TelegramApiValidationException("Parse mode can't be enabled if Entities are provided", this);
        }
        this.audio.validate();
        if (this.thumbnail != null) {
            this.thumbnail.validate();
        }
        if (this.replyMarkup != null) {
            this.replyMarkup.validate();
        }
        if (this.replyParameters != null) {
            this.replyParameters.validate();
        }
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public InputFile getFile() {
        return this.audio;
    }

    @Override
    public String getFileField() {
        return AUDIO_FIELD;
    }

    @JsonIgnore
    @Deprecated
    public InputFile getThumb() {
        return this.thumbnail;
    }

    @JsonIgnore
    @Deprecated
    public void setThumb(InputFile thumb) {
        this.thumbnail = thumb;
    }

    public static SendAudioBuilder builder() {
        return new SendAudioBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SendAudio)) {
            return false;
        }
        SendAudio other = (SendAudio)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$messageThreadId = this.getMessageThreadId();
        Integer other$messageThreadId = other.getMessageThreadId();
        if (this$messageThreadId == null ? other$messageThreadId != null : !((Object)this$messageThreadId).equals(other$messageThreadId)) {
            return false;
        }
        Integer this$replyToMessageId = this.getReplyToMessageId();
        Integer other$replyToMessageId = other.getReplyToMessageId();
        if (this$replyToMessageId == null ? other$replyToMessageId != null : !((Object)this$replyToMessageId).equals(other$replyToMessageId)) {
            return false;
        }
        Boolean this$disableNotification = this.getDisableNotification();
        Boolean other$disableNotification = other.getDisableNotification();
        if (this$disableNotification == null ? other$disableNotification != null : !((Object)this$disableNotification).equals(other$disableNotification)) {
            return false;
        }
        Integer this$duration = this.getDuration();
        Integer other$duration = other.getDuration();
        if (this$duration == null ? other$duration != null : !((Object)this$duration).equals(other$duration)) {
            return false;
        }
        Boolean this$allowSendingWithoutReply = this.getAllowSendingWithoutReply();
        Boolean other$allowSendingWithoutReply = other.getAllowSendingWithoutReply();
        if (this$allowSendingWithoutReply == null ? other$allowSendingWithoutReply != null : !((Object)this$allowSendingWithoutReply).equals(other$allowSendingWithoutReply)) {
            return false;
        }
        Boolean this$protectContent = this.getProtectContent();
        Boolean other$protectContent = other.getProtectContent();
        if (this$protectContent == null ? other$protectContent != null : !((Object)this$protectContent).equals(other$protectContent)) {
            return false;
        }
        String this$chatId = this.getChatId();
        String other$chatId = other.getChatId();
        if (this$chatId == null ? other$chatId != null : !this$chatId.equals(other$chatId)) {
            return false;
        }
        InputFile this$audio = this.getAudio();
        InputFile other$audio = other.getAudio();
        if (this$audio == null ? other$audio != null : !((Object)this$audio).equals(other$audio)) {
            return false;
        }
        ReplyKeyboard this$replyMarkup = this.getReplyMarkup();
        ReplyKeyboard other$replyMarkup = other.getReplyMarkup();
        if (this$replyMarkup == null ? other$replyMarkup != null : !this$replyMarkup.equals(other$replyMarkup)) {
            return false;
        }
        String this$performer = this.getPerformer();
        String other$performer = other.getPerformer();
        if (this$performer == null ? other$performer != null : !this$performer.equals(other$performer)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$caption = this.getCaption();
        String other$caption = other.getCaption();
        if (this$caption == null ? other$caption != null : !this$caption.equals(other$caption)) {
            return false;
        }
        String this$parseMode = this.getParseMode();
        String other$parseMode = other.getParseMode();
        if (this$parseMode == null ? other$parseMode != null : !this$parseMode.equals(other$parseMode)) {
            return false;
        }
        InputFile this$thumbnail = this.getThumbnail();
        InputFile other$thumbnail = other.getThumbnail();
        if (this$thumbnail == null ? other$thumbnail != null : !((Object)this$thumbnail).equals(other$thumbnail)) {
            return false;
        }
        List<MessageEntity> this$captionEntities = this.getCaptionEntities();
        List<MessageEntity> other$captionEntities = other.getCaptionEntities();
        if (this$captionEntities == null ? other$captionEntities != null : !((Object)this$captionEntities).equals(other$captionEntities)) {
            return false;
        }
        ReplyParameters this$replyParameters = this.getReplyParameters();
        ReplyParameters other$replyParameters = other.getReplyParameters();
        return !(this$replyParameters == null ? other$replyParameters != null : !((Object)this$replyParameters).equals(other$replyParameters));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SendAudio;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $messageThreadId = this.getMessageThreadId();
        result = result * 59 + ($messageThreadId == null ? 43 : ((Object)$messageThreadId).hashCode());
        Integer $replyToMessageId = this.getReplyToMessageId();
        result = result * 59 + ($replyToMessageId == null ? 43 : ((Object)$replyToMessageId).hashCode());
        Boolean $disableNotification = this.getDisableNotification();
        result = result * 59 + ($disableNotification == null ? 43 : ((Object)$disableNotification).hashCode());
        Integer $duration = this.getDuration();
        result = result * 59 + ($duration == null ? 43 : ((Object)$duration).hashCode());
        Boolean $allowSendingWithoutReply = this.getAllowSendingWithoutReply();
        result = result * 59 + ($allowSendingWithoutReply == null ? 43 : ((Object)$allowSendingWithoutReply).hashCode());
        Boolean $protectContent = this.getProtectContent();
        result = result * 59 + ($protectContent == null ? 43 : ((Object)$protectContent).hashCode());
        String $chatId = this.getChatId();
        result = result * 59 + ($chatId == null ? 43 : $chatId.hashCode());
        InputFile $audio = this.getAudio();
        result = result * 59 + ($audio == null ? 43 : ((Object)$audio).hashCode());
        ReplyKeyboard $replyMarkup = this.getReplyMarkup();
        result = result * 59 + ($replyMarkup == null ? 43 : $replyMarkup.hashCode());
        String $performer = this.getPerformer();
        result = result * 59 + ($performer == null ? 43 : $performer.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $caption = this.getCaption();
        result = result * 59 + ($caption == null ? 43 : $caption.hashCode());
        String $parseMode = this.getParseMode();
        result = result * 59 + ($parseMode == null ? 43 : $parseMode.hashCode());
        InputFile $thumbnail = this.getThumbnail();
        result = result * 59 + ($thumbnail == null ? 43 : ((Object)$thumbnail).hashCode());
        List<MessageEntity> $captionEntities = this.getCaptionEntities();
        result = result * 59 + ($captionEntities == null ? 43 : ((Object)$captionEntities).hashCode());
        ReplyParameters $replyParameters = this.getReplyParameters();
        result = result * 59 + ($replyParameters == null ? 43 : ((Object)$replyParameters).hashCode());
        return result;
    }

    @Override
    @NonNull
    public String getChatId() {
        return this.chatId;
    }

    @Override
    public Integer getMessageThreadId() {
        return this.messageThreadId;
    }

    @NonNull
    public InputFile getAudio() {
        return this.audio;
    }

    @Override
    public Integer getReplyToMessageId() {
        return this.replyToMessageId;
    }

    @Override
    public Boolean getDisableNotification() {
        return this.disableNotification;
    }

    public ReplyKeyboard getReplyMarkup() {
        return this.replyMarkup;
    }

    public String getPerformer() {
        return this.performer;
    }

    public String getTitle() {
        return this.title;
    }

    public String getCaption() {
        return this.caption;
    }

    public String getParseMode() {
        return this.parseMode;
    }

    public Integer getDuration() {
        return this.duration;
    }

    public InputFile getThumbnail() {
        return this.thumbnail;
    }

    public List<MessageEntity> getCaptionEntities() {
        return this.captionEntities;
    }

    @Override
    public Boolean getAllowSendingWithoutReply() {
        return this.allowSendingWithoutReply;
    }

    @Override
    public Boolean getProtectContent() {
        return this.protectContent;
    }

    public ReplyParameters getReplyParameters() {
        return this.replyParameters;
    }

    public void setChatId(@NonNull String chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId;
    }

    public void setMessageThreadId(Integer messageThreadId) {
        this.messageThreadId = messageThreadId;
    }

    public void setAudio(@NonNull InputFile audio) {
        if (audio == null) {
            throw new NullPointerException("audio is marked non-null but is null");
        }
        this.audio = audio;
    }

    public void setReplyToMessageId(Integer replyToMessageId) {
        this.replyToMessageId = replyToMessageId;
    }

    public void setDisableNotification(Boolean disableNotification) {
        this.disableNotification = disableNotification;
    }

    public void setReplyMarkup(ReplyKeyboard replyMarkup) {
        this.replyMarkup = replyMarkup;
    }

    public void setPerformer(String performer) {
        this.performer = performer;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public void setParseMode(String parseMode) {
        this.parseMode = parseMode;
    }

    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    public void setThumbnail(InputFile thumbnail) {
        this.thumbnail = thumbnail;
    }

    public void setCaptionEntities(List<MessageEntity> captionEntities) {
        this.captionEntities = captionEntities;
    }

    public void setAllowSendingWithoutReply(Boolean allowSendingWithoutReply) {
        this.allowSendingWithoutReply = allowSendingWithoutReply;
    }

    public void setProtectContent(Boolean protectContent) {
        this.protectContent = protectContent;
    }

    public void setReplyParameters(ReplyParameters replyParameters) {
        this.replyParameters = replyParameters;
    }

    public String toString() {
        return "SendAudio(chatId=" + this.getChatId() + ", messageThreadId=" + this.getMessageThreadId() + ", audio=" + this.getAudio() + ", replyToMessageId=" + this.getReplyToMessageId() + ", disableNotification=" + this.getDisableNotification() + ", replyMarkup=" + this.getReplyMarkup() + ", performer=" + this.getPerformer() + ", title=" + this.getTitle() + ", caption=" + this.getCaption() + ", parseMode=" + this.getParseMode() + ", duration=" + this.getDuration() + ", thumbnail=" + this.getThumbnail() + ", captionEntities=" + this.getCaptionEntities() + ", allowSendingWithoutReply=" + this.getAllowSendingWithoutReply() + ", protectContent=" + this.getProtectContent() + ", replyParameters=" + this.getReplyParameters() + ")";
    }

    public SendAudio(@NonNull String chatId, @NonNull InputFile audio) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (audio == null) {
            throw new NullPointerException("audio is marked non-null but is null");
        }
        this.chatId = chatId;
        this.audio = audio;
    }

    public SendAudio() {
    }

    public SendAudio(@NonNull String chatId, Integer messageThreadId, @NonNull InputFile audio, Integer replyToMessageId, Boolean disableNotification, ReplyKeyboard replyMarkup, String performer, String title, String caption, String parseMode, Integer duration, InputFile thumbnail, List<MessageEntity> captionEntities, Boolean allowSendingWithoutReply, Boolean protectContent, ReplyParameters replyParameters) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (audio == null) {
            throw new NullPointerException("audio is marked non-null but is null");
        }
        this.chatId = chatId;
        this.messageThreadId = messageThreadId;
        this.audio = audio;
        this.replyToMessageId = replyToMessageId;
        this.disableNotification = disableNotification;
        this.replyMarkup = replyMarkup;
        this.performer = performer;
        this.title = title;
        this.caption = caption;
        this.parseMode = parseMode;
        this.duration = duration;
        this.thumbnail = thumbnail;
        this.captionEntities = captionEntities;
        this.allowSendingWithoutReply = allowSendingWithoutReply;
        this.protectContent = protectContent;
        this.replyParameters = replyParameters;
    }

    public static class SendAudioBuilder {
        private String chatId;
        private Integer messageThreadId;
        private InputFile audio;
        private Integer replyToMessageId;
        private Boolean disableNotification;
        private ReplyKeyboard replyMarkup;
        private String performer;
        private String title;
        private String caption;
        private String parseMode;
        private Integer duration;
        private InputFile thumbnail;
        private ArrayList<MessageEntity> captionEntities;
        private Boolean allowSendingWithoutReply;
        private Boolean protectContent;
        private ReplyParameters replyParameters;

        public SendAudioBuilder chatId(@NonNull Long chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId.toString();
            return this;
        }

        @Deprecated
        public SendAudioBuilder thumb(InputFile thumb) {
            this.thumbnail = thumb;
            return this;
        }

        SendAudioBuilder() {
        }

        public SendAudioBuilder chatId(@NonNull String chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId;
            return this;
        }

        public SendAudioBuilder messageThreadId(Integer messageThreadId) {
            this.messageThreadId = messageThreadId;
            return this;
        }

        public SendAudioBuilder audio(@NonNull InputFile audio) {
            if (audio == null) {
                throw new NullPointerException("audio is marked non-null but is null");
            }
            this.audio = audio;
            return this;
        }

        public SendAudioBuilder replyToMessageId(Integer replyToMessageId) {
            this.replyToMessageId = replyToMessageId;
            return this;
        }

        public SendAudioBuilder disableNotification(Boolean disableNotification) {
            this.disableNotification = disableNotification;
            return this;
        }

        public SendAudioBuilder replyMarkup(ReplyKeyboard replyMarkup) {
            this.replyMarkup = replyMarkup;
            return this;
        }

        public SendAudioBuilder performer(String performer) {
            this.performer = performer;
            return this;
        }

        public SendAudioBuilder title(String title) {
            this.title = title;
            return this;
        }

        public SendAudioBuilder caption(String caption) {
            this.caption = caption;
            return this;
        }

        public SendAudioBuilder parseMode(String parseMode) {
            this.parseMode = parseMode;
            return this;
        }

        public SendAudioBuilder duration(Integer duration) {
            this.duration = duration;
            return this;
        }

        public SendAudioBuilder thumbnail(InputFile thumbnail) {
            this.thumbnail = thumbnail;
            return this;
        }

        public SendAudioBuilder captionEntity(MessageEntity captionEntity) {
            if (this.captionEntities == null) {
                this.captionEntities = new ArrayList();
            }
            this.captionEntities.add(captionEntity);
            return this;
        }

        public SendAudioBuilder captionEntities(Collection<? extends MessageEntity> captionEntities) {
            if (captionEntities == null) {
                throw new NullPointerException("captionEntities cannot be null");
            }
            if (this.captionEntities == null) {
                this.captionEntities = new ArrayList();
            }
            this.captionEntities.addAll(captionEntities);
            return this;
        }

        public SendAudioBuilder clearCaptionEntities() {
            if (this.captionEntities != null) {
                this.captionEntities.clear();
            }
            return this;
        }

        public SendAudioBuilder allowSendingWithoutReply(Boolean allowSendingWithoutReply) {
            this.allowSendingWithoutReply = allowSendingWithoutReply;
            return this;
        }

        public SendAudioBuilder protectContent(Boolean protectContent) {
            this.protectContent = protectContent;
            return this;
        }

        public SendAudioBuilder replyParameters(ReplyParameters replyParameters) {
            this.replyParameters = replyParameters;
            return this;
        }

        public SendAudio build() {
            List<MessageEntity> captionEntities;
            switch (this.captionEntities == null ? 0 : this.captionEntities.size()) {
                case 0: {
                    captionEntities = Collections.emptyList();
                    break;
                }
                case 1: {
                    captionEntities = Collections.singletonList(this.captionEntities.get(0));
                    break;
                }
                default: {
                    captionEntities = Collections.unmodifiableList(new ArrayList<MessageEntity>(this.captionEntities));
                }
            }
            return new SendAudio(this.chatId, this.messageThreadId, this.audio, this.replyToMessageId, this.disableNotification, this.replyMarkup, this.performer, this.title, this.caption, this.parseMode, this.duration, this.thumbnail, captionEntities, this.allowSendingWithoutReply, this.protectContent, this.replyParameters);
        }

        public String toString() {
            return "SendAudio.SendAudioBuilder(chatId=" + this.chatId + ", messageThreadId=" + this.messageThreadId + ", audio=" + this.audio + ", replyToMessageId=" + this.replyToMessageId + ", disableNotification=" + this.disableNotification + ", replyMarkup=" + this.replyMarkup + ", performer=" + this.performer + ", title=" + this.title + ", caption=" + this.caption + ", parseMode=" + this.parseMode + ", duration=" + this.duration + ", thumbnail=" + this.thumbnail + ", captionEntities=" + this.captionEntities + ", allowSendingWithoutReply=" + this.allowSendingWithoutReply + ", protectContent=" + this.protectContent + ", replyParameters=" + this.replyParameters + ")";
        }
    }
}

