/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects.inlinequery.result.cached;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.objects.inlinequery.inputmessagecontent.InputMessageContent;
import org.telegram.telegrambots.meta.api.objects.inlinequery.result.InlineQueryResult;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.InlineKeyboardMarkup;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonDeserialize
public class InlineQueryResultCachedSticker
implements InlineQueryResult {
    private static final String TYPE_FIELD = "type";
    private static final String ID_FIELD = "id";
    private static final String STICKER_FILE_ID_FIELD = "sticker_file_id";
    private static final String INPUTMESSAGECONTENT_FIELD = "input_message_content";
    private static final String REPLY_MARKUP_FIELD = "reply_markup";
    @JsonProperty(value="type")
    private final String type = "sticker";
    @JsonProperty(value="id")
    @NonNull
    private String id;
    @JsonProperty(value="sticker_file_id")
    @NonNull
    private String stickerFileId;
    @JsonProperty(value="input_message_content")
    private InputMessageContent inputMessageContent;
    @JsonProperty(value="reply_markup")
    private InlineKeyboardMarkup replyMarkup;

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.id == null || this.id.isEmpty()) {
            throw new TelegramApiValidationException("ID parameter can't be empty", this);
        }
        if (this.stickerFileId == null || this.stickerFileId.isEmpty()) {
            throw new TelegramApiValidationException("StickerFileId parameter can't be empty", this);
        }
        if (this.inputMessageContent != null) {
            this.inputMessageContent.validate();
        }
        if (this.replyMarkup != null) {
            this.replyMarkup.validate();
        }
    }

    public static InlineQueryResultCachedStickerBuilder builder() {
        return new InlineQueryResultCachedStickerBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InlineQueryResultCachedSticker)) {
            return false;
        }
        InlineQueryResultCachedSticker other = (InlineQueryResultCachedSticker)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$stickerFileId = this.getStickerFileId();
        String other$stickerFileId = other.getStickerFileId();
        if (this$stickerFileId == null ? other$stickerFileId != null : !this$stickerFileId.equals(other$stickerFileId)) {
            return false;
        }
        InputMessageContent this$inputMessageContent = this.getInputMessageContent();
        InputMessageContent other$inputMessageContent = other.getInputMessageContent();
        if (this$inputMessageContent == null ? other$inputMessageContent != null : !this$inputMessageContent.equals(other$inputMessageContent)) {
            return false;
        }
        InlineKeyboardMarkup this$replyMarkup = this.getReplyMarkup();
        InlineKeyboardMarkup other$replyMarkup = other.getReplyMarkup();
        return !(this$replyMarkup == null ? other$replyMarkup != null : !((Object)this$replyMarkup).equals(other$replyMarkup));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InlineQueryResultCachedSticker;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $stickerFileId = this.getStickerFileId();
        result = result * 59 + ($stickerFileId == null ? 43 : $stickerFileId.hashCode());
        InputMessageContent $inputMessageContent = this.getInputMessageContent();
        result = result * 59 + ($inputMessageContent == null ? 43 : $inputMessageContent.hashCode());
        InlineKeyboardMarkup $replyMarkup = this.getReplyMarkup();
        result = result * 59 + ($replyMarkup == null ? 43 : ((Object)$replyMarkup).hashCode());
        return result;
    }

    public String getType() {
        return this.type;
    }

    @NonNull
    public String getId() {
        return this.id;
    }

    @NonNull
    public String getStickerFileId() {
        return this.stickerFileId;
    }

    public InputMessageContent getInputMessageContent() {
        return this.inputMessageContent;
    }

    public InlineKeyboardMarkup getReplyMarkup() {
        return this.replyMarkup;
    }

    @JsonProperty(value="id")
    public void setId(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        this.id = id;
    }

    @JsonProperty(value="sticker_file_id")
    public void setStickerFileId(@NonNull String stickerFileId) {
        if (stickerFileId == null) {
            throw new NullPointerException("stickerFileId is marked non-null but is null");
        }
        this.stickerFileId = stickerFileId;
    }

    @JsonProperty(value="input_message_content")
    public void setInputMessageContent(InputMessageContent inputMessageContent) {
        this.inputMessageContent = inputMessageContent;
    }

    @JsonProperty(value="reply_markup")
    public void setReplyMarkup(InlineKeyboardMarkup replyMarkup) {
        this.replyMarkup = replyMarkup;
    }

    public String toString() {
        return "InlineQueryResultCachedSticker(type=" + this.getType() + ", id=" + this.getId() + ", stickerFileId=" + this.getStickerFileId() + ", inputMessageContent=" + this.getInputMessageContent() + ", replyMarkup=" + this.getReplyMarkup() + ")";
    }

    public InlineQueryResultCachedSticker(@NonNull String id, @NonNull String stickerFileId) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (stickerFileId == null) {
            throw new NullPointerException("stickerFileId is marked non-null but is null");
        }
        this.id = id;
        this.stickerFileId = stickerFileId;
    }

    public InlineQueryResultCachedSticker() {
    }

    public InlineQueryResultCachedSticker(@NonNull String id, @NonNull String stickerFileId, InputMessageContent inputMessageContent, InlineKeyboardMarkup replyMarkup) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (stickerFileId == null) {
            throw new NullPointerException("stickerFileId is marked non-null but is null");
        }
        this.id = id;
        this.stickerFileId = stickerFileId;
        this.inputMessageContent = inputMessageContent;
        this.replyMarkup = replyMarkup;
    }

    public static class InlineQueryResultCachedStickerBuilder {
        private String id;
        private String stickerFileId;
        private InputMessageContent inputMessageContent;
        private InlineKeyboardMarkup replyMarkup;

        InlineQueryResultCachedStickerBuilder() {
        }

        @JsonProperty(value="id")
        public InlineQueryResultCachedStickerBuilder id(@NonNull String id) {
            if (id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            this.id = id;
            return this;
        }

        @JsonProperty(value="sticker_file_id")
        public InlineQueryResultCachedStickerBuilder stickerFileId(@NonNull String stickerFileId) {
            if (stickerFileId == null) {
                throw new NullPointerException("stickerFileId is marked non-null but is null");
            }
            this.stickerFileId = stickerFileId;
            return this;
        }

        @JsonProperty(value="input_message_content")
        public InlineQueryResultCachedStickerBuilder inputMessageContent(InputMessageContent inputMessageContent) {
            this.inputMessageContent = inputMessageContent;
            return this;
        }

        @JsonProperty(value="reply_markup")
        public InlineQueryResultCachedStickerBuilder replyMarkup(InlineKeyboardMarkup replyMarkup) {
            this.replyMarkup = replyMarkup;
            return this;
        }

        public InlineQueryResultCachedSticker build() {
            return new InlineQueryResultCachedSticker(this.id, this.stickerFileId, this.inputMessageContent, this.replyMarkup);
        }

        public String toString() {
            return "InlineQueryResultCachedSticker.InlineQueryResultCachedStickerBuilder(id=" + this.id + ", stickerFileId=" + this.stickerFileId + ", inputMessageContent=" + this.inputMessageContent + ", replyMarkup=" + this.replyMarkup + ")";
        }
    }
}

