/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects.stickers;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.interfaces.BotApiObject;
import org.telegram.telegrambots.meta.api.interfaces.Validable;
import org.telegram.telegrambots.meta.api.objects.InputFile;
import org.telegram.telegrambots.meta.api.objects.stickers.MaskPosition;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class InputSticker
implements BotApiObject,
Validable {
    private static final String STICKER_FIELD = "sticker";
    private static final String EMOJI_LIST_FIELD = "emoji_list";
    private static final String MASK_POSITION_FIELD = "mask_position";
    private static final String KEYWORDS_FIELD = "keywords";
    @JsonProperty(value="sticker")
    @NonNull
    private InputFile sticker;
    @JsonProperty(value="emoji_list")
    @NonNull
    private List<String> emojiList;
    @JsonProperty(value="mask_position")
    private MaskPosition maskPosition;
    @JsonProperty(value="keywords")
    private List<String> keywords;

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.emojiList.isEmpty() || this.emojiList.size() > 20) {
            throw new TelegramApiValidationException("Emoji list must have between 1 and 20 items", this);
        }
        if (this.keywords != null && this.keywords.size() > 20) {
            throw new TelegramApiValidationException("Keywords list must have between 0 and 20 items", this);
        }
        if (this.maskPosition != null) {
            this.maskPosition.validate();
        }
        this.sticker.validate();
    }

    public static InputStickerBuilder builder() {
        return new InputStickerBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InputSticker)) {
            return false;
        }
        InputSticker other = (InputSticker)o;
        if (!other.canEqual(this)) {
            return false;
        }
        InputFile this$sticker = this.getSticker();
        InputFile other$sticker = other.getSticker();
        if (this$sticker == null ? other$sticker != null : !((Object)this$sticker).equals(other$sticker)) {
            return false;
        }
        List<String> this$emojiList = this.getEmojiList();
        List<String> other$emojiList = other.getEmojiList();
        if (this$emojiList == null ? other$emojiList != null : !((Object)this$emojiList).equals(other$emojiList)) {
            return false;
        }
        MaskPosition this$maskPosition = this.getMaskPosition();
        MaskPosition other$maskPosition = other.getMaskPosition();
        if (this$maskPosition == null ? other$maskPosition != null : !((Object)this$maskPosition).equals(other$maskPosition)) {
            return false;
        }
        List<String> this$keywords = this.getKeywords();
        List<String> other$keywords = other.getKeywords();
        return !(this$keywords == null ? other$keywords != null : !((Object)this$keywords).equals(other$keywords));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InputSticker;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        InputFile $sticker = this.getSticker();
        result = result * 59 + ($sticker == null ? 43 : ((Object)$sticker).hashCode());
        List<String> $emojiList = this.getEmojiList();
        result = result * 59 + ($emojiList == null ? 43 : ((Object)$emojiList).hashCode());
        MaskPosition $maskPosition = this.getMaskPosition();
        result = result * 59 + ($maskPosition == null ? 43 : ((Object)$maskPosition).hashCode());
        List<String> $keywords = this.getKeywords();
        result = result * 59 + ($keywords == null ? 43 : ((Object)$keywords).hashCode());
        return result;
    }

    @NonNull
    public InputFile getSticker() {
        return this.sticker;
    }

    @NonNull
    public List<String> getEmojiList() {
        return this.emojiList;
    }

    public MaskPosition getMaskPosition() {
        return this.maskPosition;
    }

    public List<String> getKeywords() {
        return this.keywords;
    }

    @JsonProperty(value="sticker")
    public void setSticker(@NonNull InputFile sticker) {
        if (sticker == null) {
            throw new NullPointerException("sticker is marked non-null but is null");
        }
        this.sticker = sticker;
    }

    @JsonProperty(value="emoji_list")
    public void setEmojiList(@NonNull List<String> emojiList) {
        if (emojiList == null) {
            throw new NullPointerException("emojiList is marked non-null but is null");
        }
        this.emojiList = emojiList;
    }

    @JsonProperty(value="mask_position")
    public void setMaskPosition(MaskPosition maskPosition) {
        this.maskPosition = maskPosition;
    }

    @JsonProperty(value="keywords")
    public void setKeywords(List<String> keywords) {
        this.keywords = keywords;
    }

    public String toString() {
        return "InputSticker(sticker=" + this.getSticker() + ", emojiList=" + this.getEmojiList() + ", maskPosition=" + this.getMaskPosition() + ", keywords=" + this.getKeywords() + ")";
    }

    public InputSticker() {
    }

    public InputSticker(@NonNull InputFile sticker, @NonNull List<String> emojiList, MaskPosition maskPosition, List<String> keywords) {
        if (sticker == null) {
            throw new NullPointerException("sticker is marked non-null but is null");
        }
        if (emojiList == null) {
            throw new NullPointerException("emojiList is marked non-null but is null");
        }
        this.sticker = sticker;
        this.emojiList = emojiList;
        this.maskPosition = maskPosition;
        this.keywords = keywords;
    }

    public static class InputStickerBuilder {
        private InputFile sticker;
        private ArrayList<String> emojiList;
        private MaskPosition maskPosition;
        private ArrayList<String> keywords;

        InputStickerBuilder() {
        }

        @JsonProperty(value="sticker")
        public InputStickerBuilder sticker(@NonNull InputFile sticker) {
            if (sticker == null) {
                throw new NullPointerException("sticker is marked non-null but is null");
            }
            this.sticker = sticker;
            return this;
        }

        public InputStickerBuilder emoji(String emoji) {
            if (this.emojiList == null) {
                this.emojiList = new ArrayList();
            }
            this.emojiList.add(emoji);
            return this;
        }

        @JsonProperty(value="emoji_list")
        public InputStickerBuilder emojiList(Collection<? extends String> emojiList) {
            if (emojiList == null) {
                throw new NullPointerException("emojiList cannot be null");
            }
            if (this.emojiList == null) {
                this.emojiList = new ArrayList();
            }
            this.emojiList.addAll(emojiList);
            return this;
        }

        public InputStickerBuilder clearEmojiList() {
            if (this.emojiList != null) {
                this.emojiList.clear();
            }
            return this;
        }

        @JsonProperty(value="mask_position")
        public InputStickerBuilder maskPosition(MaskPosition maskPosition) {
            this.maskPosition = maskPosition;
            return this;
        }

        public InputStickerBuilder keyword(String keyword) {
            if (this.keywords == null) {
                this.keywords = new ArrayList();
            }
            this.keywords.add(keyword);
            return this;
        }

        @JsonProperty(value="keywords")
        public InputStickerBuilder keywords(Collection<? extends String> keywords) {
            if (keywords == null) {
                throw new NullPointerException("keywords cannot be null");
            }
            if (this.keywords == null) {
                this.keywords = new ArrayList();
            }
            this.keywords.addAll(keywords);
            return this;
        }

        public InputStickerBuilder clearKeywords() {
            if (this.keywords != null) {
                this.keywords.clear();
            }
            return this;
        }

        public InputSticker build() {
            List<String> keywords;
            List<String> emojiList;
            switch (this.emojiList == null ? 0 : this.emojiList.size()) {
                case 0: {
                    emojiList = Collections.emptyList();
                    break;
                }
                case 1: {
                    emojiList = Collections.singletonList(this.emojiList.get(0));
                    break;
                }
                default: {
                    emojiList = Collections.unmodifiableList(new ArrayList<String>(this.emojiList));
                }
            }
            switch (this.keywords == null ? 0 : this.keywords.size()) {
                case 0: {
                    keywords = Collections.emptyList();
                    break;
                }
                case 1: {
                    keywords = Collections.singletonList(this.keywords.get(0));
                    break;
                }
                default: {
                    keywords = Collections.unmodifiableList(new ArrayList<String>(this.keywords));
                }
            }
            return new InputSticker(this.sticker, emojiList, this.maskPosition, keywords);
        }

        public String toString() {
            return "InputSticker.InputStickerBuilder(sticker=" + this.sticker + ", emojiList=" + this.emojiList + ", maskPosition=" + this.maskPosition + ", keywords=" + this.keywords + ")";
        }
    }
}

