/*
 * Decompiled with CFR 0.152.
 */
package org.terasoluna.gfw.common.codelist;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.terasoluna.gfw.common.codelist.AbstractCodeList;
import org.terasoluna.gfw.common.codelist.ReadWriteLockMapWrapper;
import org.terasoluna.gfw.common.codelist.ReloadableCodeList;

public abstract class AbstractReloadableCodeList
extends AbstractCodeList
implements ReloadableCodeList,
InitializingBean {
    private final ReadWriteLockMapWrapper<String, String> cachedMap = new ReadWriteLockMapWrapper(new LinkedHashMap());
    private volatile Map<String, String> exposedMap = null;
    private boolean lazyInit = false;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public final Map<String, String> asMap() {
        if (this.exposedMap == null) {
            this.refresh();
        }
        return this.exposedMap;
    }

    public void setLazyInit(boolean lazyInit) {
        this.lazyInit = lazyInit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void refresh() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("refresh codelist codeListId={}", (Object)this.getCodeListId());
        }
        ReadWriteLockMapWrapper<String, String> readWriteLockMapWrapper = this.cachedMap;
        synchronized (readWriteLockMapWrapper) {
            this.cachedMap.clearAndPutAll(this.retrieveMap());
            this.exposedMap = Collections.unmodifiableMap(this.cachedMap);
        }
    }

    public void afterPropertiesSet() {
        if (!this.lazyInit) {
            this.refresh();
        }
    }

    protected abstract Map<String, String> retrieveMap();
}

