/*
 * Decompiled with CFR 0.152.
 */
package org.terasoluna.gfw.common.codelist;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.terasoluna.gfw.common.codelist.AbstractCodeList;

public class EnumCodeList
extends AbstractCodeList {
    private final Map<String, String> codeListMap;

    public EnumCodeList(Class<? extends Enum<?>> enumClass) {
        Enum[] result;
        Assert.isTrue((boolean)CodeListItem.class.isAssignableFrom(enumClass), (String)("the given enumClass must implement " + CodeListItem.class));
        LinkedHashMap<String, String> codeList = new LinkedHashMap<String, String>();
        Method method = ReflectionUtils.findMethod(enumClass, (String)"values");
        for (Enum e : result = (Enum[])ReflectionUtils.invokeMethod((Method)method, enumClass)) {
            CodeListItem item = (CodeListItem)((Object)e);
            codeList.put(item.getCodeValue(), item.getCodeLabel());
        }
        this.codeListMap = Collections.unmodifiableMap(codeList);
    }

    @Override
    public Map<String, String> asMap() {
        return this.codeListMap;
    }

    public static interface CodeListItem {
        public String getCodeLabel();

        public String getCodeValue();
    }
}

