/*
 * Decompiled with CFR 0.152.
 */
package org.terasoluna.gfw.common.codelist;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.Assert;
import org.terasoluna.gfw.common.codelist.AbstractReloadableCodeList;

public class JdbcCodeList
extends AbstractReloadableCodeList {
    private JdbcTemplate jdbcTemplate;
    private String querySql;
    private String valueColumn;
    private String labelColumn;

    @Override
    protected Map<String, String> retrieveMap() {
        List rows = this.jdbcTemplate.queryForList(this.querySql);
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (Map row : rows) {
            Object key = row.get(this.valueColumn);
            Object value = row.get(this.labelColumn);
            if (key == null || value == null) continue;
            result.put(key.toString(), value.toString());
        }
        return result;
    }

    public void setDataSource(DataSource dataSource) {
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    @Override
    public void afterPropertiesSet() {
        Assert.hasLength((String)this.querySql, (String)"querySql is empty");
        Assert.hasLength((String)this.valueColumn, (String)"valueColumn is empty");
        Assert.hasLength((String)this.labelColumn, (String)"labelColumn is empty");
        Assert.notNull((Object)this.jdbcTemplate, (String)"jdbcTemplate (or dataSource) is empty");
        super.afterPropertiesSet();
    }

    public void setLabelColumn(String labelColumn) {
        this.labelColumn = labelColumn;
    }

    public void setValueColumn(String valueColumn) {
        this.valueColumn = valueColumn;
    }

    public void setQuerySql(String querySql) {
        this.querySql = querySql;
    }
}

