/*
 * Decompiled with CFR 0.152.
 */
package org.terasoluna.gfw.common.codelist;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.terasoluna.gfw.common.codelist.AbstractCodeList;

public class NumberRangeCodeList
extends AbstractCodeList
implements InitializingBean {
    private int from = 0;
    private int to = 0;
    private int interval = 1;
    private String valueFormat = "%s";
    private String labelFormat = "%s";
    private Map<String, String> map;

    @Override
    public Map<String, String> asMap() {
        return this.map;
    }

    public void afterPropertiesSet() {
        Assert.isTrue((this.interval > 0 ? 1 : 0) != 0, (String)"interval should be greater than 0");
        Assert.hasLength((String)this.valueFormat, (String)"valueFormat must not be empty");
        Assert.hasLength((String)this.labelFormat, (String)"labelFormat must not be empty");
        LinkedHashMap<String, String> numbers = new LinkedHashMap<String, String>();
        if (this.from <= this.to) {
            for (int i = this.from; i <= this.to; i += this.interval) {
                this.putInMap(numbers, i);
            }
        } else {
            for (int i = this.from; i >= this.to; i -= this.interval) {
                this.putInMap(numbers, i);
            }
        }
        this.map = Collections.unmodifiableMap(numbers);
    }

    private void putInMap(Map<String, String> numbers, int index) {
        String key = String.format(this.valueFormat, index);
        String value = String.format(this.labelFormat, index);
        numbers.put(key, value);
    }

    public void setFrom(int from) {
        this.from = from;
    }

    public void setTo(int to) {
        this.to = to;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    public void setValueFormat(String valueFormat) {
        this.valueFormat = valueFormat;
    }

    public void setLabelFormat(String labelFormat) {
        this.labelFormat = labelFormat;
    }
}

