/*
 * Decompiled with CFR 0.152.
 */
package org.terasoluna.gfw.common.codelist;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ReadWriteLockMapWrapper<K, V>
implements Map<K, V> {
    private final Map<K, V> map;
    private final ReadWriteLock lock;

    public ReadWriteLockMapWrapper(Map<K, V> map) {
        this.map = map;
        this.lock = new ReentrantReadWriteLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T withReadLock(LockedCallback<T> callback) {
        Lock readLock = this.lock.readLock();
        T result = null;
        try {
            readLock.lock();
            result = callback.apply();
        }
        finally {
            readLock.unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T withWriteLock(LockedCallback<T> callback) {
        Lock writeLock = this.lock.writeLock();
        T result = null;
        try {
            writeLock.lock();
            result = callback.apply();
        }
        finally {
            writeLock.unlock();
        }
        return result;
    }

    @Override
    public int size() {
        return this.withReadLock(new LockedCallback<Integer>(){

            @Override
            public Integer apply() {
                return ReadWriteLockMapWrapper.this.map.size();
            }
        });
    }

    @Override
    public boolean isEmpty() {
        return this.withReadLock(new LockedCallback<Boolean>(){

            @Override
            public Boolean apply() {
                return ReadWriteLockMapWrapper.this.map.isEmpty();
            }
        });
    }

    @Override
    public boolean containsKey(final Object key) {
        return this.withReadLock(new LockedCallback<Boolean>(){

            @Override
            public Boolean apply() {
                return ReadWriteLockMapWrapper.this.map.containsKey(key);
            }
        });
    }

    @Override
    public boolean containsValue(final Object value) {
        return this.withReadLock(new LockedCallback<Boolean>(){

            @Override
            public Boolean apply() {
                return ReadWriteLockMapWrapper.this.map.containsValue(value);
            }
        });
    }

    @Override
    public V get(final Object key) {
        return (V)this.withReadLock(new LockedCallback<V>(){

            @Override
            public V apply() {
                return ReadWriteLockMapWrapper.this.map.get(key);
            }
        });
    }

    @Override
    public V put(final K key, final V value) {
        return (V)this.withWriteLock(new LockedCallback<V>(){

            @Override
            public V apply() {
                return ReadWriteLockMapWrapper.this.map.put(key, value);
            }
        });
    }

    @Override
    public V remove(final Object key) {
        return (V)this.withWriteLock(new LockedCallback<V>(){

            @Override
            public V apply() {
                return ReadWriteLockMapWrapper.this.map.remove(key);
            }
        });
    }

    @Override
    public void putAll(final Map<? extends K, ? extends V> m) {
        this.withWriteLock(new LockedCallback<Void>(){

            @Override
            public Void apply() {
                ReadWriteLockMapWrapper.this.map.putAll(m);
                return null;
            }
        });
    }

    @Override
    public void clear() {
        this.withWriteLock(new LockedCallback<Void>(){

            @Override
            public Void apply() {
                ReadWriteLockMapWrapper.this.map.clear();
                return null;
            }
        });
    }

    public void clearAndPutAll(final Map<? extends K, ? extends V> m) {
        this.withWriteLock(new LockedCallback<Void>(){

            @Override
            public Void apply() {
                ReadWriteLockMapWrapper.this.map.clear();
                ReadWriteLockMapWrapper.this.map.putAll(m);
                return null;
            }
        });
    }

    @Override
    public Set<K> keySet() {
        return (Set)this.withReadLock(new LockedCallback<Set<K>>(){

            @Override
            public Set<K> apply() {
                return ReadWriteLockMapWrapper.this.map.keySet();
            }
        });
    }

    @Override
    public Collection<V> values() {
        return (Collection)this.withReadLock(new LockedCallback<Collection<V>>(){

            @Override
            public Collection<V> apply() {
                return ReadWriteLockMapWrapper.this.map.values();
            }
        });
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return (Set)this.withReadLock(new LockedCallback<Set<Map.Entry<K, V>>>(){

            @Override
            public Set<Map.Entry<K, V>> apply() {
                return ReadWriteLockMapWrapper.this.map.entrySet();
            }
        });
    }

    @Override
    public boolean equals(final Object o) {
        return this.withReadLock(new LockedCallback<Boolean>(){

            @Override
            public Boolean apply() {
                return ReadWriteLockMapWrapper.this.map.equals(o);
            }
        });
    }

    @Override
    public int hashCode() {
        return this.withReadLock(new LockedCallback<Integer>(){

            @Override
            public Integer apply() {
                return ReadWriteLockMapWrapper.this.map.hashCode();
            }
        });
    }

    public static interface LockedCallback<T> {
        public T apply();
    }
}

