/*
 * Decompiled with CFR 0.152.
 */
package org.terasoluna.gfw.common.codelist.i18n;

import com.google.common.base.Supplier;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.terasoluna.gfw.common.codelist.CodeList;
import org.terasoluna.gfw.common.codelist.i18n.AbstractI18nCodeList;

public class SimpleI18nCodeList
extends AbstractI18nCodeList
implements InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(SimpleI18nCodeList.class);
    Table<Locale, String, String> codeListTable;
    private static final Supplier<LinkedHashMap<String, String>> LINKED_HASH_MAP_SUPPLIER = new Supplier<LinkedHashMap<String, String>>(){

        public LinkedHashMap<String, String> get() {
            return Maps.newLinkedHashMap();
        }
    };

    @Override
    public Map<String, String> asMap(Locale locale) {
        Assert.notNull((Object)locale, (String)"locale is null");
        return this.codeListTable.row((Object)locale);
    }

    private void checkTable() {
        if (this.codeListTable != null) {
            logger.warn("Codelist table has already built, but re-build");
        }
    }

    public void setRows(Map<Locale, Map<String, String>> rows) {
        this.checkTable();
        Table<Locale, String, String> table = this.createTable();
        for (Map.Entry<Locale, Map<String, String>> e : rows.entrySet()) {
            Locale locale = e.getKey();
            Map<String, String> row = e.getValue();
            for (Map.Entry<String, String> re : row.entrySet()) {
                String value = re.getKey();
                String label = re.getValue();
                table.put((Object)locale, (Object)value, (Object)label);
            }
        }
        this.codeListTable = Tables.unmodifiableTable(table);
    }

    public void setRowsByCodeList(Map<Locale, CodeList> rows) {
        this.checkTable();
        Table<Locale, String, String> table = this.createTable();
        for (Map.Entry<Locale, CodeList> e : rows.entrySet()) {
            Locale locale = e.getKey();
            Map<String, String> row = e.getValue().asMap();
            for (Map.Entry<String, String> re : row.entrySet()) {
                String value = re.getKey();
                String label = re.getValue();
                table.put((Object)locale, (Object)value, (Object)label);
            }
        }
        this.codeListTable = Tables.unmodifiableTable(table);
    }

    public void setColumns(Map<String, Map<Locale, String>> cols) {
        this.checkTable();
        Table<Locale, String, String> table = this.createTable();
        for (Map.Entry<String, Map<Locale, String>> e : cols.entrySet()) {
            String value = e.getKey();
            Map<Locale, String> col = e.getValue();
            for (Map.Entry<Locale, String> ce : col.entrySet()) {
                Locale locale = ce.getKey();
                String label = ce.getValue();
                table.put((Object)locale, (Object)value, (Object)label);
            }
        }
        this.codeListTable = Tables.unmodifiableTable(table);
    }

    private Table<Locale, String, String> createTable() {
        LinkedHashMap backingMap = Maps.newLinkedHashMap();
        Table table = Tables.newCustomTable((Map)backingMap, LINKED_HASH_MAP_SUPPLIER);
        return table;
    }

    public void afterPropertiesSet() {
        Assert.notNull(this.codeListTable, (String)"codeListTable is not initialized!");
    }
}

