/*
 * Decompiled with CFR 0.152.
 */
package org.terasoluna.gfw.common.codelist.validator;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.ApplicationObjectSupport;
import org.springframework.util.StringUtils;
import org.terasoluna.gfw.common.codelist.CodeList;
import org.terasoluna.gfw.common.codelist.ExistInCodeList;

public abstract class AbstractExistInCodeListValidator<T>
extends ApplicationObjectSupport
implements ConstraintValidator<ExistInCodeList, T> {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private CodeList codeList = null;

    public void initialize(ExistInCodeList codeConstraint) {
        this.codeList = (CodeList)this.getApplicationContext().getBean(codeConstraint.codeListId(), CodeList.class);
    }

    protected abstract String getCode(T var1);

    public boolean isValid(T value, ConstraintValidatorContext constraintContext) {
        String code = this.getCode(value);
        if (!StringUtils.hasLength((String)code)) {
            return true;
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("check if {} exists in {}", (Object)code, (Object)this.codeList.getCodeListId());
        }
        return this.codeList.asMap().containsKey(code);
    }
}

