/*
 * Decompiled with CFR 0.152.
 */
package org.terasoluna.gfw.common.date;

import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;

public final class DateConvertUtils {
    private static final int DEFAULT_YEAR = 1970;

    private DateConvertUtils() {
    }

    public static Timestamp convertToTimestamp(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("date must not be null");
        }
        Timestamp timestamp = new Timestamp(date.getTime());
        return timestamp;
    }

    public static java.sql.Date convertToSqlDate(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("date must not be null");
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        java.sql.Date sqlDate = new java.sql.Date(cal.getTimeInMillis());
        return sqlDate;
    }

    public static Time convertToTime(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("date must not be null");
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(1, 1970);
        cal.set(2, 0);
        cal.set(5, 1);
        Time time = new Time(cal.getTimeInMillis());
        return time;
    }
}

