/*
 * Decompiled with CFR 0.152.
 */
package org.terasoluna.gfw.common.exception;

import org.terasoluna.gfw.common.exception.ExceptionCodeResolver;
import org.terasoluna.gfw.common.exception.ExceptionLevel;
import org.terasoluna.gfw.common.exception.ExceptionLevelResolver;

public class DefaultExceptionLevelResolver
implements ExceptionLevelResolver {
    private ExceptionCodeResolver exceptionCodeResolver;

    public DefaultExceptionLevelResolver() {
    }

    public DefaultExceptionLevelResolver(ExceptionCodeResolver exceptionCodeResolver) {
        this.setExceptionCodeResolver(exceptionCodeResolver);
    }

    public void setExceptionCodeResolver(ExceptionCodeResolver exceptionCodeResolver) {
        this.exceptionCodeResolver = exceptionCodeResolver;
    }

    @Override
    public ExceptionLevel resolveExceptionLevel(Exception ex) {
        String exceptionCode = this.resolveExceptionCode(ex);
        if (exceptionCode == null || exceptionCode.isEmpty()) {
            return ExceptionLevel.ERROR;
        }
        String exceptionCodePrefix = exceptionCode.substring(0, 1);
        if ("e".equalsIgnoreCase(exceptionCodePrefix)) {
            return ExceptionLevel.ERROR;
        }
        if ("w".equalsIgnoreCase(exceptionCodePrefix)) {
            return ExceptionLevel.WARN;
        }
        if ("i".equalsIgnoreCase(exceptionCodePrefix)) {
            return ExceptionLevel.INFO;
        }
        return ExceptionLevel.ERROR;
    }

    protected String resolveExceptionCode(Exception ex) {
        String exceptionCode = null;
        if (this.exceptionCodeResolver != null) {
            exceptionCode = this.exceptionCodeResolver.resolveExceptionCode(ex);
        }
        return exceptionCode;
    }
}

