/*
 * Decompiled with CFR 0.152.
 */
package org.terasoluna.gfw.common.exception;

import java.text.MessageFormat;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.StringUtils;
import org.terasoluna.gfw.common.exception.DefaultExceptionLevelResolver;
import org.terasoluna.gfw.common.exception.ExceptionCodeResolver;
import org.terasoluna.gfw.common.exception.ExceptionLevel;
import org.terasoluna.gfw.common.exception.ExceptionLevelResolver;
import org.terasoluna.gfw.common.exception.SimpleMappingExceptionCodeResolver;

public class ExceptionLogger
implements InitializingBean {
    private static final String MONITORING_LOG_LOGGER_SUFFIX = ".Monitoring";
    private final Logger applicationLogger;
    private final Logger monitoringLogger;
    private final Map<ExceptionLevel, LogLevelWrappingLogger> exceptionLevelLoggers = new ConcurrentHashMap<ExceptionLevel, LogLevelWrappingLogger>();
    private final InfoLogger infoLogger;
    private final WarnLogger warnLogger;
    private final ErrorLogger errorLogger;
    private ExceptionCodeResolver exceptionCodeResolver = new SimpleMappingExceptionCodeResolver();
    private ExceptionLevelResolver exceptionLevelResolver;
    private String PLACEHOLDER_OF_EXCEPTION_CODE = "{0}";
    private String PLACEHOLDER_OF_EXCEPTION_MESSAGE = "{1}";
    private String logMessageFormat = String.format("[%s] %s", this.PLACEHOLDER_OF_EXCEPTION_CODE, this.PLACEHOLDER_OF_EXCEPTION_MESSAGE);
    private String defaultCode = "UNDEFINED-CODE";
    private String defaultMessage = "UNDEFINED-MESSAGE";
    private boolean trimLogMessage = true;

    public ExceptionLogger() {
        this(ExceptionLogger.class.getName());
    }

    public ExceptionLogger(String name) {
        this.applicationLogger = LoggerFactory.getLogger((String)name);
        this.monitoringLogger = LoggerFactory.getLogger((String)(name + MONITORING_LOG_LOGGER_SUFFIX));
        this.infoLogger = new InfoLogger();
        this.warnLogger = new WarnLogger();
        this.errorLogger = new ErrorLogger();
    }

    public void setExceptionCodeResolver(ExceptionCodeResolver exceptionCodeResolver) {
        this.exceptionCodeResolver = exceptionCodeResolver;
    }

    public void setExceptionLevelResolver(ExceptionLevelResolver exceptionLevelResolver) {
        this.exceptionLevelResolver = exceptionLevelResolver;
    }

    public void setLogMessageFormat(String logMessageFormat) {
        this.logMessageFormat = logMessageFormat;
    }

    public void setTrimLogMessage(boolean trimLogMessage) {
        this.trimLogMessage = trimLogMessage;
    }

    public void setDefaultCode(String defaultCode) {
        this.defaultCode = defaultCode;
    }

    public void setDefaultMessage(String defaultMessage) {
        this.defaultMessage = defaultMessage;
    }

    public void afterPropertiesSet() {
        this.validateLogMessageFormat(this.logMessageFormat);
        if (this.exceptionLevelResolver == null) {
            this.exceptionLevelResolver = new DefaultExceptionLevelResolver(this.exceptionCodeResolver);
        }
        this.registerExceptionLevelLoggers(ExceptionLevel.INFO, this.infoLogger);
        this.registerExceptionLevelLoggers(ExceptionLevel.WARN, this.warnLogger);
        this.registerExceptionLevelLoggers(ExceptionLevel.ERROR, this.errorLogger);
    }

    public void log(Exception ex) {
        ExceptionLevel level = this.exceptionLevelResolver.resolveExceptionLevel(ex);
        LogLevelWrappingLogger logger = null;
        if (level != null) {
            logger = this.exceptionLevelLoggers.get((Object)level);
        }
        if (logger == null) {
            logger = this.errorLogger;
        }
        this.log(ex, logger);
    }

    public void info(Exception ex) {
        this.log(ex, this.infoLogger);
    }

    public void warn(Exception ex) {
        this.log(ex, this.warnLogger);
    }

    public void error(Exception ex) {
        this.log(ex, this.errorLogger);
    }

    protected void validateLogMessageFormat(String logMessageFormat) {
        if (logMessageFormat == null || !logMessageFormat.contains(this.PLACEHOLDER_OF_EXCEPTION_CODE) || !logMessageFormat.contains(this.PLACEHOLDER_OF_EXCEPTION_MESSAGE)) {
            String message = "logMessageFormat must have placeholder({0} and {1}). {0} is replaced with exception code. {1} is replaced with exception message. current logMessageFormat is \"" + logMessageFormat + "\".";
            throw new IllegalArgumentException(message);
        }
    }

    protected String resolveExceptionCode(Exception ex) {
        String exceptionCode = null;
        if (this.exceptionCodeResolver != null) {
            exceptionCode = this.exceptionCodeResolver.resolveExceptionCode(ex);
        }
        return exceptionCode;
    }

    protected String makeLogMessage(Exception ex) {
        String exceptionCode = this.resolveExceptionCode(ex);
        return this.formatLogMessage(exceptionCode, ex.getMessage());
    }

    protected String formatLogMessage(String exceptionCode, String exceptionMessage) {
        String bindingExceptionCode = exceptionCode;
        String bindingExceptionMessage = exceptionMessage;
        if (StringUtils.isEmpty((Object)bindingExceptionCode)) {
            bindingExceptionCode = this.defaultCode;
        }
        if (StringUtils.isEmpty((Object)bindingExceptionMessage)) {
            bindingExceptionMessage = this.defaultMessage;
        }
        String message = MessageFormat.format(this.logMessageFormat, bindingExceptionCode, bindingExceptionMessage);
        if (this.trimLogMessage) {
            message = message.trim();
        }
        return message;
    }

    protected void registerExceptionLevelLoggers(ExceptionLevel level, LogLevelWrappingLogger logger) {
        this.exceptionLevelLoggers.put(level, logger);
    }

    protected Logger getApplicationLogger() {
        return this.applicationLogger;
    }

    protected Logger getMonitoringLogger() {
        return this.monitoringLogger;
    }

    private void log(Exception ex, LogLevelWrappingLogger logger) {
        if (!logger.isEnabled()) {
            return;
        }
        String logMessage = this.makeLogMessage(ex);
        logger.log(logMessage, ex);
    }

    private final class ErrorLogger
    implements LogLevelWrappingLogger {
        private ErrorLogger() {
        }

        @Override
        public boolean isEnabled() {
            return ExceptionLogger.this.monitoringLogger.isErrorEnabled() || ExceptionLogger.this.applicationLogger.isErrorEnabled();
        }

        @Override
        public void log(String logMessage, Exception ex) {
            if (ExceptionLogger.this.monitoringLogger.isErrorEnabled()) {
                ExceptionLogger.this.monitoringLogger.error(logMessage);
            }
            if (ExceptionLogger.this.applicationLogger.isErrorEnabled()) {
                ExceptionLogger.this.applicationLogger.error(logMessage, (Throwable)ex);
            }
        }
    }

    private final class WarnLogger
    implements LogLevelWrappingLogger {
        private WarnLogger() {
        }

        @Override
        public boolean isEnabled() {
            return ExceptionLogger.this.monitoringLogger.isWarnEnabled() || ExceptionLogger.this.applicationLogger.isWarnEnabled();
        }

        @Override
        public void log(String logMessage, Exception ex) {
            if (ExceptionLogger.this.monitoringLogger.isWarnEnabled()) {
                ExceptionLogger.this.monitoringLogger.warn(logMessage);
            }
            if (ExceptionLogger.this.applicationLogger.isWarnEnabled()) {
                ExceptionLogger.this.applicationLogger.warn(logMessage, (Throwable)ex);
            }
        }
    }

    private final class InfoLogger
    implements LogLevelWrappingLogger {
        private InfoLogger() {
        }

        @Override
        public boolean isEnabled() {
            return ExceptionLogger.this.monitoringLogger.isInfoEnabled() || ExceptionLogger.this.applicationLogger.isInfoEnabled();
        }

        @Override
        public void log(String logMessage, Exception ex) {
            if (ExceptionLogger.this.monitoringLogger.isInfoEnabled()) {
                ExceptionLogger.this.monitoringLogger.info(logMessage);
            }
            if (ExceptionLogger.this.applicationLogger.isInfoEnabled()) {
                ExceptionLogger.this.applicationLogger.info(logMessage, (Throwable)ex);
            }
        }
    }

    protected static interface LogLevelWrappingLogger {
        public boolean isEnabled();

        public void log(String var1, Exception var2);
    }
}

