/*
 * Decompiled with CFR 0.152.
 */
package org.terasoluna.gfw.common.exception;

import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.beans.factory.InitializingBean;
import org.terasoluna.gfw.common.exception.ExceptionLogger;
import org.terasoluna.gfw.common.exception.ResultMessagesNotificationException;

public class ResultMessagesLoggingInterceptor
implements MethodInterceptor,
InitializingBean {
    private final ThreadLocal<MethodInvocation> startingPoint = new ThreadLocal();
    private ExceptionLogger exceptionLogger = null;

    public void setExceptionLogger(ExceptionLogger exceptionLogger) {
        this.exceptionLogger = exceptionLogger;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable, ResultMessagesNotificationException {
        if (this.startingPoint.get() == null) {
            this.startingPoint.set(invocation);
        }
        try {
            Object object = invocation.proceed();
            return object;
        }
        catch (ResultMessagesNotificationException e) {
            if (this.isStartingPoint(invocation)) {
                this.logResultMessagesNotificationException(e);
            }
            throw e;
        }
        finally {
            if (this.isStartingPoint(invocation)) {
                this.startingPoint.remove();
            }
        }
    }

    public void afterPropertiesSet() throws Exception {
        if (this.exceptionLogger == null) {
            this.exceptionLogger = new ExceptionLogger(this.getClass().getName());
            this.exceptionLogger.afterPropertiesSet();
        }
    }

    protected boolean isStartingPoint(MethodInvocation invocation) {
        return this.startingPoint.get() == invocation;
    }

    protected void logResultMessagesNotificationException(ResultMessagesNotificationException e) {
        this.exceptionLogger.warn(e);
    }

    protected ExceptionLogger getExceptionLogger() {
        return this.exceptionLogger;
    }
}

