/*
 * Decompiled with CFR 0.152.
 */
package org.terasoluna.gfw.common.exception;

import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terasoluna.gfw.common.exception.ExceptionCodeProvider;
import org.terasoluna.gfw.common.exception.ExceptionCodeResolver;

public class SimpleMappingExceptionCodeResolver
implements ExceptionCodeResolver {
    private static final Logger logger = LoggerFactory.getLogger(SimpleMappingExceptionCodeResolver.class);
    private LinkedHashMap<String, String> exceptionMappings;
    private String defaultExceptionCode;

    public void setExceptionMappings(LinkedHashMap<String, String> exceptionMappings) {
        this.exceptionMappings = exceptionMappings;
    }

    public void setDefaultExceptionCode(String defaultExceptionCode) {
        this.defaultExceptionCode = defaultExceptionCode;
    }

    @Override
    public String resolveExceptionCode(Exception ex) {
        String code;
        if (ex == null) {
            logger.warn("target exception is null. return defaultExceptionCode.");
            return this.defaultExceptionCode;
        }
        if (ex instanceof ExceptionCodeProvider && (code = ((ExceptionCodeProvider)((Object)ex)).getCode()) != null) {
            return code;
        }
        if (this.exceptionMappings == null || this.exceptionMappings.isEmpty()) {
            return this.defaultExceptionCode;
        }
        for (Map.Entry<String, String> entry : this.exceptionMappings.entrySet()) {
            String targetException = entry.getKey();
            for (Class<?> exceptionClass = ex.getClass(); exceptionClass != Object.class; exceptionClass = exceptionClass.getSuperclass()) {
                if (!exceptionClass.getName().contains(targetException)) continue;
                return entry.getValue();
            }
        }
        return this.defaultExceptionCode;
    }
}

