/*
 * Decompiled with CFR 0.152.
 */
package org.terasoluna.gfw.common.message;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import org.springframework.util.Assert;

public class ResultMessage
implements Serializable {
    private static final long serialVersionUID = -2020904640866275166L;
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private final String code;
    private final Object[] args;
    private final String text;

    public ResultMessage(String code, Object[] args, String text) {
        this.code = code;
        this.args = args == null ? EMPTY_ARRAY : args;
        this.text = text;
    }

    public static ResultMessage fromCode(String code, Object ... args) {
        Assert.notNull((Object)code, (String)"code must not be null");
        return new ResultMessage(code, args, null);
    }

    public static ResultMessage fromText(String text) {
        Assert.notNull((Object)text, (String)"text must not be null");
        return new ResultMessage(null, EMPTY_ARRAY, text);
    }

    public String getCode() {
        return this.code;
    }

    public Object[] getArgs() {
        return this.args;
    }

    public String getText() {
        return this.text;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.args);
        result = 31 * result + (this.code == null ? 0 : this.code.hashCode());
        result = 31 * result + (this.text == null ? 0 : this.text.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResultMessage other = (ResultMessage)obj;
        if (this.code == null ? other.code != null : !this.code.equals(other.code)) {
            return false;
        }
        if (!Arrays.equals(this.args, other.args)) {
            return false;
        }
        return !(this.text == null ? other.text != null : !this.text.equals(other.text));
    }

    public String toString() {
        return "ResultMessage [code=" + this.code + ", args=" + Arrays.toString(this.args) + ", text=" + this.text + "]";
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }
}

