/*
 * Decompiled with CFR 0.152.
 */
package org.terasoluna.gfw.common.message;

import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.NoSuchMessageException;
import org.springframework.util.Assert;
import org.terasoluna.gfw.common.message.ResultMessage;

public final class ResultMessageUtils {
    private static final Logger logger = LoggerFactory.getLogger(ResultMessageUtils.class);

    private ResultMessageUtils() {
    }

    public static String resolveMessage(ResultMessage message, MessageSource messageSource, Locale locale) throws NoSuchMessageException {
        String msg;
        Assert.notNull((Object)messageSource, (String)"messageSource must not be null!");
        Assert.notNull((Object)message, (String)"message must not be null!");
        Assert.notNull((Object)locale, (String)"locale must not be null!");
        String code = message.getCode();
        if (code != null) {
            try {
                msg = messageSource.getMessage(code, message.getArgs(), locale);
            }
            catch (NoSuchMessageException e) {
                String text = message.getText();
                if (text != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("messege is not found under code '" + code + "' for '" + locale + "'. use '" + text + "' instead", (Throwable)e);
                    }
                    msg = text;
                }
                throw e;
            }
        } else {
            msg = message.getText();
        }
        return msg;
    }

    public static String resolveMessage(ResultMessage message, MessageSource messageSource) {
        return ResultMessageUtils.resolveMessage(message, messageSource, Locale.getDefault());
    }
}

