/*
 * Decompiled with CFR 0.152.
 */
package org.terasoluna.gfw.common.message;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.springframework.util.StringUtils;
import org.terasoluna.gfw.common.message.ResultMessage;
import org.terasoluna.gfw.common.message.ResultMessageType;
import org.terasoluna.gfw.common.message.StandardResultMessageType;

public class ResultMessages
implements Serializable,
Iterable<ResultMessage> {
    private static final long serialVersionUID = -7323120914608188540L;
    private final ResultMessageType type;
    private final List<ResultMessage> list = new ArrayList<ResultMessage>();
    public static final String DEFAULT_MESSAGES_ATTRIBUTE_NAME = StringUtils.uncapitalize((String)ResultMessages.class.getSimpleName());

    public ResultMessages(ResultMessageType type) {
        this(type, null);
    }

    public ResultMessages(ResultMessageType type, ResultMessage ... messages) {
        if (type == null) {
            throw new IllegalArgumentException("type must not be null!");
        }
        this.type = type;
        if (messages != null) {
            this.addAll(messages);
        }
    }

    public ResultMessageType getType() {
        return this.type;
    }

    public List<ResultMessage> getList() {
        return this.list;
    }

    public ResultMessages add(ResultMessage message) {
        if (message == null) {
            throw new IllegalArgumentException("message must not be null");
        }
        this.list.add(message);
        return this;
    }

    public ResultMessages add(String code) {
        if (code == null) {
            throw new IllegalArgumentException("code must not be null");
        }
        this.add(ResultMessage.fromCode(code, new Object[0]));
        return this;
    }

    public ResultMessages add(String code, Object ... args) {
        if (code == null) {
            throw new IllegalArgumentException("code must not be null");
        }
        this.add(ResultMessage.fromCode(code, args));
        return this;
    }

    public ResultMessages addAll(ResultMessage ... messages) {
        if (messages != null) {
            for (ResultMessage message : messages) {
                this.add(message);
            }
        } else {
            throw new IllegalArgumentException("messages must not be null");
        }
        return this;
    }

    public ResultMessages addAll(Collection<ResultMessage> messages) {
        if (messages != null) {
            for (ResultMessage message : messages) {
                this.add(message);
            }
        } else {
            throw new IllegalArgumentException("messages must not be null");
        }
        return this;
    }

    public boolean isNotEmpty() {
        return !this.list.isEmpty();
    }

    public static ResultMessages success() {
        return new ResultMessages(StandardResultMessageType.SUCCESS);
    }

    public static ResultMessages info() {
        return new ResultMessages(StandardResultMessageType.INFO);
    }

    @Deprecated
    public static ResultMessages warn() {
        return new ResultMessages(StandardResultMessageType.WARN);
    }

    public static ResultMessages warning() {
        return new ResultMessages(StandardResultMessageType.WARNING);
    }

    public static ResultMessages error() {
        return new ResultMessages(StandardResultMessageType.ERROR);
    }

    public static ResultMessages danger() {
        return new ResultMessages(StandardResultMessageType.DANGER);
    }

    @Override
    public Iterator<ResultMessage> iterator() {
        return this.list.iterator();
    }

    public String toString() {
        return "ResultMessages [type=" + this.type + ", list=" + this.list + "]";
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }
}

