/*
 * Decompiled with CFR 0.152.
 */
package org.terasoluna.gfw.common.sequencer;

import javax.sql.DataSource;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.Assert;
import org.terasoluna.gfw.common.sequencer.Sequencer;

public class JdbcSequencer<T>
implements Sequencer<T>,
InitializingBean {
    private JdbcTemplate jdbcTemplate;
    private String nextValueQuery;
    private String currentValueQuery;
    private Class<T> sequenceClass;

    @Override
    public T getNext() {
        Object seq = this.jdbcTemplate.queryForObject(this.nextValueQuery, this.sequenceClass);
        return (T)seq;
    }

    @Override
    public T getCurrent() {
        Object seq = this.jdbcTemplate.queryForObject(this.currentValueQuery, this.sequenceClass);
        return (T)seq;
    }

    public void setNextValueQuery(String nextValueQuery) {
        this.nextValueQuery = nextValueQuery;
    }

    public void setCurrentValueQuery(String currentValueQuery) {
        this.currentValueQuery = currentValueQuery;
    }

    public void setSequenceClass(Class<T> sequenceClass) {
        this.sequenceClass = sequenceClass;
    }

    public void setDataSource(DataSource dataSource) {
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public void afterPropertiesSet() throws IllegalArgumentException {
        Assert.notNull((Object)this.jdbcTemplate, (String)"jdbcTemplate must not be null");
        Assert.hasLength((String)this.nextValueQuery, (String)"nextValueQuery must not be empty");
        Assert.hasLength((String)this.currentValueQuery, (String)"currentValueQuery must not be empty");
        Assert.notNull(this.sequenceClass, (String)"sequenceClass must not be null");
    }
}

