/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.media;

import java.io.File;
import java.io.InputStream;
import twitter4j.StatusUpdate;
import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.TwitterFactory;
import twitter4j.auth.Authorization;
import twitter4j.auth.OAuthAuthorization;
import twitter4j.conf.Configuration;
import twitter4j.media.ImageUpload;

class TwitterUpload
implements ImageUpload {
    private Twitter twitter;

    public TwitterUpload(Configuration conf, OAuthAuthorization oauth) {
        this.twitter = new TwitterFactory(conf).getInstance((Authorization)oauth);
    }

    @Override
    public String upload(File image, String message) throws TwitterException {
        return this.twitter.updateStatus(new StatusUpdate(message).media(image)).getText();
    }

    @Override
    public String upload(File image) throws TwitterException {
        return this.twitter.updateStatus(new StatusUpdate("").media(image)).getText();
    }

    @Override
    public String upload(String imageFileName, InputStream imageBody) throws TwitterException {
        return this.twitter.updateStatus(new StatusUpdate("").media(imageFileName, imageBody)).getText();
    }

    @Override
    public String upload(String imageFileName, InputStream imageBody, String message) throws TwitterException {
        return this.twitter.updateStatus(new StatusUpdate(message).media(imageFileName, imageBody)).getText();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TwitterUpload that = (TwitterUpload)o;
        return !(this.twitter != null ? !this.twitter.equals(that.twitter) : that.twitter != null);
    }

    public int hashCode() {
        return this.twitter != null ? this.twitter.hashCode() : 0;
    }

    public String toString() {
        return "TwitterUpload{twitter=" + this.twitter + '}';
    }
}

