/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.IOException;
import java.io.InputStream;
import twitter4j.AbstractStreamImplementation;
import twitter4j.SiteStreamsListener;
import twitter4j.StatusDeletionNotice;
import twitter4j.StatusDeletionNoticeImpl;
import twitter4j.StreamController;
import twitter4j.StreamImplementation;
import twitter4j.StreamListener;
import twitter4j.TwitterException;
import twitter4j.conf.Configuration;
import twitter4j.internal.async.Dispatcher;
import twitter4j.internal.http.HttpResponse;
import twitter4j.internal.json.z_T4JInternalParseUtil;
import twitter4j.internal.org.json.JSONException;
import twitter4j.internal.org.json.JSONObject;

class SiteStreamsImpl
extends AbstractStreamImplementation
implements StreamImplementation,
StreamListener {
    SiteStreamsListener listener;
    private final StreamController cs;
    private static ThreadLocal<Integer> forUser = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 0;
        }
    };

    SiteStreamsImpl(Dispatcher dispatcher, InputStream stream, Configuration conf, StreamController cs) throws IOException {
        super(dispatcher, stream, conf);
        this.cs = cs;
    }

    SiteStreamsImpl(Dispatcher dispatcher, HttpResponse response, Configuration conf, StreamController cs) throws IOException {
        super(dispatcher, response, conf);
        this.cs = cs;
    }

    public void next(StreamListener[] listeners) throws TwitterException {
        try {
            this.listener = (SiteStreamsListener)listeners[0];
            this.handleNextElement();
        }
        catch (TwitterException e) {
            if ("Stream closed.".equals(e.getMessage())) {
                this.cs.setControlURI(null);
            }
            throw e;
        }
    }

    protected String parseLine(String line) {
        if ("".equals(line) || null == line) {
            return line;
        }
        int userIdEnd = line.indexOf(44, 12);
        if (this.cs.getControlURI() == null && line.charAt(2) == 'c' && line.charAt(3) == 'o' && line.charAt(4) == 'n') {
            JSONObject control = null;
            try {
                control = new JSONObject(line);
                this.cs.setControlURI(this.CONF.getSiteStreamBaseURL() + control.getJSONObject("control").getString("control_uri"));
                logger.info("control_uri:" + this.cs.getControlURI());
            }
            catch (JSONException e) {
                logger.warn("received unexpected event:" + line);
            }
            return null;
        }
        if (line.charAt(12) == '\"') {
            forUser.set(Integer.parseInt(line.substring(13, userIdEnd - 1)));
        } else {
            forUser.set(Integer.parseInt(line.substring(12, userIdEnd)));
        }
        return line.substring(userIdEnd + 11, line.length() - 1);
    }

    protected void onStatus(JSONObject json) throws TwitterException {
        this.listener.onStatus(forUser.get().intValue(), this.asStatus(json));
    }

    protected void onDelete(JSONObject json) throws JSONException {
        JSONObject deletionNotice = json.getJSONObject("delete");
        if (deletionNotice.has("status")) {
            this.listener.onDeletionNotice(forUser.get().intValue(), (StatusDeletionNotice)new StatusDeletionNoticeImpl(deletionNotice.getJSONObject("status")));
        } else {
            JSONObject directMessage = deletionNotice.getJSONObject("direct_message");
            this.listener.onDeletionNotice(forUser.get().intValue(), z_T4JInternalParseUtil.getInt((String)"id", (JSONObject)directMessage), z_T4JInternalParseUtil.getLong((String)"user_id", (JSONObject)directMessage));
        }
    }

    protected void onDirectMessage(JSONObject json) throws TwitterException {
        this.listener.onDirectMessage(forUser.get().intValue(), this.asDirectMessage(json));
    }

    protected void onFriends(JSONObject json) throws TwitterException, JSONException {
        this.listener.onFriendList(forUser.get().intValue(), this.asFriendList(json));
    }

    protected void onFavorite(JSONObject source, JSONObject target, JSONObject targetObject) throws TwitterException {
        this.listener.onFavorite(forUser.get().intValue(), this.asUser(source), this.asUser(target), this.asStatus(targetObject));
    }

    protected void onUnfavorite(JSONObject source, JSONObject target, JSONObject targetObject) throws TwitterException {
        this.listener.onUnfavorite(forUser.get().intValue(), this.asUser(source), this.asUser(target), this.asStatus(targetObject));
    }

    protected void onFollow(JSONObject source, JSONObject target) throws TwitterException {
        this.listener.onFollow(forUser.get().intValue(), this.asUser(source), this.asUser(target));
    }

    protected void onUnfollow(JSONObject source, JSONObject target) throws TwitterException {
        this.listener.onUnfollow(forUser.get().intValue(), this.asUser(source), this.asUser(target));
    }

    protected void onUserListMemberAddition(JSONObject addedMember, JSONObject owner, JSONObject userList) throws TwitterException, JSONException {
        this.listener.onUserListMemberAddition(forUser.get().intValue(), this.asUser(addedMember), this.asUser(owner), this.asUserList(userList));
    }

    protected void onUserListMemberDeletion(JSONObject deletedMember, JSONObject owner, JSONObject userList) throws TwitterException, JSONException {
        this.listener.onUserListMemberDeletion(forUser.get().intValue(), this.asUser(deletedMember), this.asUser(owner), this.asUserList(userList));
    }

    protected void onUserListSubscription(JSONObject source, JSONObject owner, JSONObject userList) throws TwitterException, JSONException {
        this.listener.onUserListSubscription(forUser.get().intValue(), this.asUser(source), this.asUser(owner), this.asUserList(userList));
    }

    protected void onUserListUnsubscription(JSONObject source, JSONObject owner, JSONObject userList) throws TwitterException, JSONException {
        this.listener.onUserListUnsubscription(forUser.get().intValue(), this.asUser(source), this.asUser(owner), this.asUserList(userList));
    }

    protected void onUserListCreation(JSONObject source, JSONObject userList) throws TwitterException, JSONException {
        this.listener.onUserListCreation(forUser.get().intValue(), this.asUser(source), this.asUserList(userList));
    }

    protected void onUserListUpdated(JSONObject source, JSONObject userList) throws TwitterException, JSONException {
        this.listener.onUserListUpdate(forUser.get().intValue(), this.asUser(source), this.asUserList(userList));
    }

    protected void onUserListDestroyed(JSONObject source, JSONObject userList) throws TwitterException {
        this.listener.onUserListDeletion(forUser.get().intValue(), this.asUser(source), this.asUserList(userList));
    }

    protected void onUserUpdate(JSONObject source, JSONObject target) throws TwitterException {
        this.listener.onUserProfileUpdate(forUser.get().intValue(), this.asUser(source));
    }

    protected void onBlock(JSONObject source, JSONObject target) throws TwitterException {
        this.listener.onBlock(forUser.get().intValue(), this.asUser(source), this.asUser(target));
    }

    protected void onUnblock(JSONObject source, JSONObject target) throws TwitterException {
        this.listener.onUnblock(forUser.get().intValue(), this.asUser(source), this.asUser(target));
    }

    public void onException(Exception ex) {
        this.listener.onException(ex);
    }
}

