/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.Serializable;
import twitter4j.TwitterFactory;
import twitter4j.TwitterStream;
import twitter4j.TwitterStreamImpl;
import twitter4j.auth.AccessToken;
import twitter4j.auth.Authorization;
import twitter4j.auth.AuthorizationFactory;
import twitter4j.auth.OAuthAuthorization;
import twitter4j.conf.Configuration;
import twitter4j.conf.ConfigurationContext;

public final class TwitterStreamFactory
implements Serializable {
    private static final long serialVersionUID = 8146074704915782233L;
    private final Configuration conf;
    private static final TwitterStream SINGLETON = new TwitterStreamImpl(ConfigurationContext.getInstance(), TwitterFactory.DEFAULT_AUTHORIZATION);

    public TwitterStreamFactory() {
        this(ConfigurationContext.getInstance());
    }

    public TwitterStreamFactory(Configuration conf) {
        this.conf = conf;
    }

    public TwitterStreamFactory(String configTreePath) {
        this(ConfigurationContext.getInstance((String)configTreePath));
    }

    public TwitterStream getInstance() {
        return this.getInstance(AuthorizationFactory.getInstance((Configuration)this.conf));
    }

    public TwitterStream getInstance(AccessToken accessToken) {
        String consumerKey = this.conf.getOAuthConsumerKey();
        String consumerSecret = this.conf.getOAuthConsumerSecret();
        if (null == consumerKey && null == consumerSecret) {
            throw new IllegalStateException("Consumer key and Consumer secret not supplied.");
        }
        OAuthAuthorization oauth = new OAuthAuthorization(this.conf);
        oauth.setOAuthAccessToken(accessToken);
        return this.getInstance(this.conf, (Authorization)oauth);
    }

    public TwitterStream getInstance(Authorization auth) {
        return this.getInstance(this.conf, auth);
    }

    private TwitterStream getInstance(Configuration conf, Authorization auth) {
        return new TwitterStreamImpl(conf, auth);
    }

    public static TwitterStream getSingleton() {
        return SINGLETON;
    }
}

