/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import twitter4j.DirectMessage;
import twitter4j.DirectMessageJSONImpl;
import twitter4j.Dispatcher;
import twitter4j.HttpResponse;
import twitter4j.JSONArray;
import twitter4j.JSONException;
import twitter4j.JSONImplFactory;
import twitter4j.JSONObject;
import twitter4j.JSONObjectType;
import twitter4j.Logger;
import twitter4j.ObjectFactory;
import twitter4j.RawStreamListener;
import twitter4j.Status;
import twitter4j.StatusJSONImpl;
import twitter4j.StatusListener;
import twitter4j.StatusStream;
import twitter4j.StatusStreamImpl;
import twitter4j.StreamListener;
import twitter4j.TwitterException;
import twitter4j.TwitterObjectFactory;
import twitter4j.User;
import twitter4j.UserJSONImpl;
import twitter4j.UserList;
import twitter4j.UserListJSONImpl;
import twitter4j.conf.Configuration;

abstract class StatusStreamBase
implements StatusStream {
    static final Logger logger = Logger.getLogger(StatusStreamImpl.class);
    private boolean streamAlive = true;
    private BufferedReader br;
    private InputStream is;
    private HttpResponse response;
    private final Dispatcher dispatcher;
    final Configuration CONF;
    private ObjectFactory factory;

    StatusStreamBase(Dispatcher dispatcher, InputStream stream, Configuration conf) throws IOException {
        this.is = stream;
        this.br = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
        this.dispatcher = dispatcher;
        this.CONF = conf;
        this.factory = new JSONImplFactory(conf);
    }

    StatusStreamBase(Dispatcher dispatcher, HttpResponse response, Configuration conf) throws IOException {
        this(dispatcher, response.asStream(), conf);
        this.response = response;
    }

    String parseLine(String line) {
        return line;
    }

    void handleNextElement(final StreamListener[] listeners, final RawStreamListener[] rawStreamListeners) throws TwitterException {
        block6: {
            if (!this.streamAlive) {
                throw new IllegalStateException("Stream already closed.");
            }
            try {
                String line = this.br.readLine();
                if (null == line) {
                    throw new IOException("the end of the stream has been reached");
                }
                this.dispatcher.invokeLater((Runnable)new StreamEvent(line){

                    public void run() {
                        try {
                            if (rawStreamListeners.length > 0) {
                                StatusStreamBase.this.onMessage(this.line, rawStreamListeners);
                            }
                            this.line = StatusStreamBase.this.parseLine(this.line);
                            if (this.line != null && this.line.length() > 0 && listeners.length > 0) {
                                if (StatusStreamBase.this.CONF.isJSONStoreEnabled()) {
                                    TwitterObjectFactory.clearThreadLocalMap();
                                }
                                JSONObject json = new JSONObject(this.line);
                                JSONObjectType.Type event = JSONObjectType.determine((JSONObject)json);
                                if (logger.isDebugEnabled()) {
                                    logger.debug("Received:", StatusStreamBase.this.CONF.getHttpClientConfiguration().isPrettyDebugEnabled() ? json.toString(1) : json.toString());
                                }
                                switch (event) {
                                    case SENDER: {
                                        StatusStreamBase.this.onSender(json, listeners);
                                        break;
                                    }
                                    case STATUS: {
                                        StatusStreamBase.this.onStatus(json, listeners);
                                        break;
                                    }
                                    case DIRECT_MESSAGE: {
                                        StatusStreamBase.this.onDirectMessage(json, listeners);
                                        break;
                                    }
                                    case DELETE: {
                                        StatusStreamBase.this.onDelete(json, listeners);
                                        break;
                                    }
                                    case LIMIT: {
                                        StatusStreamBase.this.onLimit(json, listeners);
                                        break;
                                    }
                                    case STALL_WARNING: {
                                        StatusStreamBase.this.onStallWarning(json, listeners);
                                        break;
                                    }
                                    case SCRUB_GEO: {
                                        StatusStreamBase.this.onScrubGeo(json, listeners);
                                        break;
                                    }
                                    case FRIENDS: {
                                        StatusStreamBase.this.onFriends(json, listeners);
                                        break;
                                    }
                                    case FAVORITE: {
                                        StatusStreamBase.this.onFavorite(json.getJSONObject("source"), json.getJSONObject("target"), json.getJSONObject("target_object"), listeners);
                                        break;
                                    }
                                    case UNFAVORITE: {
                                        StatusStreamBase.this.onUnfavorite(json.getJSONObject("source"), json.getJSONObject("target"), json.getJSONObject("target_object"), listeners);
                                        break;
                                    }
                                    case FOLLOW: {
                                        StatusStreamBase.this.onFollow(json.getJSONObject("source"), json.getJSONObject("target"), listeners);
                                        break;
                                    }
                                    case UNFOLLOW: {
                                        StatusStreamBase.this.onUnfollow(json.getJSONObject("source"), json.getJSONObject("target"), listeners);
                                        break;
                                    }
                                    case USER_LIST_MEMBER_ADDED: {
                                        StatusStreamBase.this.onUserListMemberAddition(json.getJSONObject("target"), json.getJSONObject("source"), json.getJSONObject("target_object"), listeners);
                                        break;
                                    }
                                    case USER_LIST_MEMBER_DELETED: {
                                        StatusStreamBase.this.onUserListMemberDeletion(json.getJSONObject("target"), json.getJSONObject("source"), json.getJSONObject("target_object"), listeners);
                                        break;
                                    }
                                    case USER_LIST_SUBSCRIBED: {
                                        StatusStreamBase.this.onUserListSubscription(json.getJSONObject("source"), json.getJSONObject("target"), json.getJSONObject("target_object"), listeners);
                                        break;
                                    }
                                    case USER_LIST_UNSUBSCRIBED: {
                                        StatusStreamBase.this.onUserListUnsubscription(json.getJSONObject("source"), json.getJSONObject("target"), json.getJSONObject("target_object"), listeners);
                                        break;
                                    }
                                    case USER_LIST_CREATED: {
                                        StatusStreamBase.this.onUserListCreation(json.getJSONObject("source"), json.getJSONObject("target_object"), listeners);
                                        break;
                                    }
                                    case USER_LIST_UPDATED: {
                                        StatusStreamBase.this.onUserListUpdated(json.getJSONObject("source"), json.getJSONObject("target_object"), listeners);
                                        break;
                                    }
                                    case USER_LIST_DESTROYED: {
                                        StatusStreamBase.this.onUserListDestroyed(json.getJSONObject("source"), json.getJSONObject("target_object"), listeners);
                                        break;
                                    }
                                    case USER_UPDATE: {
                                        StatusStreamBase.this.onUserUpdate(json.getJSONObject("source"), json.getJSONObject("target"), listeners);
                                        break;
                                    }
                                    case BLOCK: {
                                        StatusStreamBase.this.onBlock(json.getJSONObject("source"), json.getJSONObject("target"), listeners);
                                        break;
                                    }
                                    case UNBLOCK: {
                                        StatusStreamBase.this.onUnblock(json.getJSONObject("source"), json.getJSONObject("target"), listeners);
                                        break;
                                    }
                                    case DISCONNECTION: {
                                        StatusStreamBase.this.onDisconnectionNotice(this.line, listeners);
                                        break;
                                    }
                                    default: {
                                        logger.warn("Received unknown event:", StatusStreamBase.this.CONF.getHttpClientConfiguration().isPrettyDebugEnabled() ? json.toString(1) : json.toString());
                                    }
                                }
                            }
                        }
                        catch (Exception ex) {
                            StatusStreamBase.this.onException(ex, listeners);
                        }
                    }
                });
            }
            catch (IOException ioe) {
                try {
                    this.is.close();
                }
                catch (IOException ignore) {
                    // empty catch block
                }
                boolean isUnexpectedException = this.streamAlive;
                this.streamAlive = false;
                this.onClose();
                if (!isUnexpectedException) break block6;
                throw new TwitterException("Stream closed.", (Throwable)ioe);
            }
        }
    }

    void onMessage(String rawString, RawStreamListener[] listeners) throws TwitterException {
        logger.warn("Unhandled event: onMessage");
    }

    void onSender(JSONObject json, StreamListener[] listeners) throws TwitterException {
        logger.warn("Unhandled event: onSender");
    }

    void onStatus(JSONObject json, StreamListener[] listeners) throws TwitterException {
        logger.warn("Unhandled event: onStatus");
    }

    void onDirectMessage(JSONObject json, StreamListener[] listeners) throws TwitterException, JSONException {
        logger.warn("Unhandled event: onDirectMessage");
    }

    void onDelete(JSONObject json, StreamListener[] listeners) throws TwitterException, JSONException {
        logger.warn("Unhandled event: onDelete");
    }

    void onLimit(JSONObject json, StreamListener[] listeners) throws TwitterException, JSONException {
        logger.warn("Unhandled event: onLimit");
    }

    void onStallWarning(JSONObject json, StreamListener[] listeners) throws TwitterException, JSONException {
        logger.warn("Unhandled event: onStallWarning");
    }

    void onScrubGeo(JSONObject json, StreamListener[] listeners) throws TwitterException, JSONException {
        logger.warn("Unhandled event: onScrubGeo");
    }

    void onFriends(JSONObject json, StreamListener[] listeners) throws TwitterException, JSONException {
        logger.warn("Unhandled event: onFriends");
    }

    void onFavorite(JSONObject source, JSONObject target, JSONObject targetObject, StreamListener[] listeners) throws TwitterException {
        logger.warn("Unhandled event: onFavorite");
    }

    void onUnfavorite(JSONObject source, JSONObject target, JSONObject targetObject, StreamListener[] listeners) throws TwitterException {
        logger.warn("Unhandled event: onUnfavorite");
    }

    void onFollow(JSONObject source, JSONObject target, StreamListener[] listeners) throws TwitterException {
        logger.warn("Unhandled event: onFollow");
    }

    void onUnfollow(JSONObject source, JSONObject target, StreamListener[] listeners) throws TwitterException {
        logger.warn("Unhandled event: onUnfollow");
    }

    void onUserListMemberAddition(JSONObject addedMember, JSONObject owner, JSONObject userList, StreamListener[] listeners) throws TwitterException, JSONException {
        logger.warn("Unhandled event: onUserListMemberAddition");
    }

    void onUserListMemberDeletion(JSONObject deletedMember, JSONObject owner, JSONObject userList, StreamListener[] listeners) throws TwitterException, JSONException {
        logger.warn("Unhandled event: onUserListMemberDeletion");
    }

    void onUserListSubscription(JSONObject source, JSONObject owner, JSONObject userList, StreamListener[] listeners) throws TwitterException, JSONException {
        logger.warn("Unhandled event: onUserListSubscription");
    }

    void onUserListUnsubscription(JSONObject source, JSONObject owner, JSONObject userList, StreamListener[] listeners) throws TwitterException, JSONException {
        logger.warn("Unhandled event: onUserListUnsubscription");
    }

    void onUserListCreation(JSONObject source, JSONObject userList, StreamListener[] listeners) throws TwitterException, JSONException {
        logger.warn("Unhandled event: onUserListCreation");
    }

    void onUserListUpdated(JSONObject source, JSONObject userList, StreamListener[] listeners) throws TwitterException, JSONException {
        logger.warn("Unhandled event: onUserListUpdated");
    }

    void onUserListDestroyed(JSONObject source, JSONObject userList, StreamListener[] listeners) throws TwitterException {
        logger.warn("Unhandled event: onUserListDestroyed");
    }

    void onUserUpdate(JSONObject source, JSONObject target, StreamListener[] listeners) throws TwitterException {
        logger.warn("Unhandled event: onUserUpdate");
    }

    void onBlock(JSONObject source, JSONObject target, StreamListener[] listeners) throws TwitterException {
        logger.warn("Unhandled event: onBlock");
    }

    void onUnblock(JSONObject source, JSONObject target, StreamListener[] listeners) throws TwitterException {
        logger.warn("Unhandled event: onUnblock");
    }

    void onDisconnectionNotice(String line, StreamListener[] listeners) {
        logger.warn("Unhandled event: ", line);
    }

    void onException(Exception e, StreamListener[] listeners) {
        logger.warn("Unhandled event: ", e.getMessage());
    }

    protected abstract void onClose();

    public void close() throws IOException {
        this.streamAlive = false;
        this.is.close();
        this.br.close();
        if (this.response != null) {
            this.response.disconnect();
        }
        this.onClose();
    }

    Status asStatus(JSONObject json) throws TwitterException {
        StatusJSONImpl status = new StatusJSONImpl(json);
        if (this.CONF.isJSONStoreEnabled()) {
            TwitterObjectFactory.registerJSONObject((Object)status, (Object)json);
        }
        return status;
    }

    DirectMessage asDirectMessage(JSONObject json) throws TwitterException {
        try {
            JSONObject dmJSON = json.getJSONObject("direct_message");
            DirectMessageJSONImpl directMessage = new DirectMessageJSONImpl(dmJSON);
            if (this.CONF.isJSONStoreEnabled()) {
                TwitterObjectFactory.registerJSONObject((Object)directMessage, (Object)dmJSON);
            }
            return directMessage;
        }
        catch (JSONException jsone) {
            throw new TwitterException((Exception)((Object)jsone));
        }
    }

    long[] asFriendList(JSONObject json) throws TwitterException {
        try {
            JSONArray friends = json.getJSONArray("friends");
            long[] friendIds = new long[friends.length()];
            for (int i = 0; i < friendIds.length; ++i) {
                friendIds[i] = Long.parseLong(friends.getString(i));
            }
            return friendIds;
        }
        catch (JSONException e) {
            throw new TwitterException((Exception)((Object)e));
        }
    }

    User asUser(JSONObject json) throws TwitterException {
        UserJSONImpl user = new UserJSONImpl(json);
        if (this.CONF.isJSONStoreEnabled()) {
            TwitterObjectFactory.registerJSONObject((Object)user, (Object)json);
        }
        return user;
    }

    UserList asUserList(JSONObject json) throws TwitterException {
        UserListJSONImpl userList = new UserListJSONImpl(json);
        if (this.CONF.isJSONStoreEnabled()) {
            TwitterObjectFactory.registerJSONObject((Object)userList, (Object)json);
        }
        return userList;
    }

    public abstract void next(StatusListener var1) throws TwitterException;

    public abstract void next(StreamListener[] var1, RawStreamListener[] var2) throws TwitterException;

    public void onException(Exception e, StreamListener[] listeners, RawStreamListener[] rawStreamListeners) {
        for (StreamListener streamListener : listeners) {
            streamListener.onException(e);
        }
        for (StreamListener streamListener : rawStreamListeners) {
            streamListener.onException(e);
        }
    }

    abstract class StreamEvent
    implements Runnable {
        String line;

        StreamEvent(String line) {
            this.line = line;
        }
    }
}

