/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.commons.cluster;

import java.util.Properties;
import org.uberfire.commons.cluster.ConnectionMode;

public class ClusterParameters {
    public static final String APPFORMER_JMS_CONNECTION_MODE = "appformer-jms-connection-mode";
    public static final String APPFORMER_PROVIDER_URL = "appformer-jms-url";
    public static final String APPFORMER_INITIAL_CONTEXT_FACTORY = "appformer-initial-context-factory";
    public static final String APPFORMER_JMS_CONNECTION_FACTORY = "appformer-jms-connection-factory";
    public static final String APPFORMER_JMS_USERNAME = "appformer-jms-username";
    public static final String APPFORMER_JMS_PASSWORD = "appformer-jms-password";
    public static final String APPFORMER_JMS_THROTTLE = "appformer-jms-throttle";
    private final Properties initialContextFactory = new Properties();
    private final ConnectionMode connectionMode;
    private final String providerUrl;
    private final String jmsConnectionFactoryJndiName;
    private final String jmsUserName;
    private final String jmsPassword;
    private long jmsThrottle;

    public ClusterParameters() {
        ConnectionMode connectionMode;
        try {
            connectionMode = ConnectionMode.valueOf(System.getProperty(APPFORMER_JMS_CONNECTION_MODE, ConnectionMode.NONE.toString()));
        }
        catch (Throwable ignore) {
            connectionMode = ConnectionMode.NONE;
        }
        this.connectionMode = connectionMode;
        this.initialContextFactory.put("java.naming.factory.initial", System.getProperty(APPFORMER_INITIAL_CONTEXT_FACTORY, "org.wildfly.naming.client.WildFlyInitialContextFactory"));
        this.jmsConnectionFactoryJndiName = System.getProperty(APPFORMER_JMS_CONNECTION_FACTORY, "java:/ConnectionFactory");
        this.providerUrl = System.getProperty(APPFORMER_PROVIDER_URL, "tcp://localhost:61616");
        this.jmsUserName = System.getProperty(APPFORMER_JMS_USERNAME);
        this.jmsPassword = System.getProperty(APPFORMER_JMS_PASSWORD);
        String throttleParameter = System.getProperty(APPFORMER_JMS_THROTTLE, "1000");
        try {
            this.jmsThrottle = Long.valueOf(throttleParameter);
        }
        catch (NumberFormatException e) {
            this.jmsThrottle = -1L;
        }
    }

    public boolean isAppFormerClustered() {
        return this.connectionMode != ConnectionMode.NONE;
    }

    public ConnectionMode getConnectionMode() {
        return this.connectionMode;
    }

    public String getProviderUrl() {
        return this.providerUrl;
    }

    public Properties getInitialContextFactory() {
        return this.initialContextFactory;
    }

    public String getJmsConnectionFactoryJndiName() {
        return this.jmsConnectionFactoryJndiName;
    }

    public String getJmsUserName() {
        return this.jmsUserName;
    }

    public String getJmsPassword() {
        return this.jmsPassword;
    }

    public long getJmsThrottle() {
        return this.jmsThrottle;
    }
}

