/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.security.server.auth;

import org.kie.commons.validation.Preconditions;
import org.uberfire.security.SecurityContext;
import org.uberfire.security.auth.AuthenticationScheme;
import org.uberfire.security.auth.Credential;
import org.uberfire.security.auth.Principal;
import org.uberfire.security.server.HttpSecurityContext;
import org.uberfire.security.server.auth.CookieStorage;

public class RememberMeCookieAuthScheme
implements AuthenticationScheme {
    final CookieStorage cookieStorage;

    public RememberMeCookieAuthScheme(CookieStorage cookieStorage) {
        this.cookieStorage = (CookieStorage)Preconditions.checkNotNull((String)"cookieStorage", (Object)cookieStorage);
    }

    public boolean isAuthenticationRequest(SecurityContext context) {
        HttpSecurityContext httpSecurityContext = (HttpSecurityContext)Preconditions.checkInstanceOf((String)"context", (Object)context, HttpSecurityContext.class);
        return this.cookieStorage.load(httpSecurityContext) != null;
    }

    public void challengeClient(SecurityContext context) {
    }

    public Credential buildCredential(SecurityContext context) {
        HttpSecurityContext httpSecurityContext = (HttpSecurityContext)Preconditions.checkInstanceOf((String)"context", (Object)context, HttpSecurityContext.class);
        Principal principal = this.cookieStorage.load(httpSecurityContext);
        if (principal == null) {
            return null;
        }
        return new RememberMeCredential(Boolean.TRUE.toString(), principal.getName());
    }

    static class RememberMeCredential
    implements Credential {
        private final String userId;
        private final boolean rememberForLater;

        public RememberMeCredential(String rememberForLater, String userId) {
            this.rememberForLater = rememberForLater == null ? false : Boolean.valueOf(rememberForLater);
            this.userId = userId;
        }

        public String getUserId() {
            return this.userId;
        }

        public boolean rememberForLater() {
            return this.rememberForLater;
        }
    }
}

