/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.server;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.mvel2.templates.CompiledTemplate;
import org.mvel2.templates.TemplateCompiler;
import org.mvel2.templates.TemplateRuntime;
import org.uberfire.security.Identity;
import org.uberfire.security.Role;
import org.uberfire.security.Subject;
import org.uberfire.security.server.cdi.SecurityFactory;
import org.uberfire.server.cdi.UberFireGeneralFactory;

public class UberfireServlet
extends HttpServlet {
    CompiledTemplate appTemplate = null;
    CompiledTemplate headerTemplate = null;
    CompiledTemplate footerTemplate = null;
    CompiledTemplate userDataTemplate = null;

    public void init(ServletConfig config) throws ServletException {
        UberFireGeneralFactory.setServletContext(config.getServletContext());
        try {
            String appTemplateRef = this.getConfig(config, "org.uberfire.template.app");
            this.appTemplate = appTemplateRef != null ? TemplateCompiler.compileTemplate((String)this.getFileContent(appTemplateRef)) : TemplateCompiler.compileTemplate((String)this.getResourceContent("app.html.template"));
        }
        catch (Exception ex) {
            String headerRef = this.getConfig(config, "org.uberfire.template.header");
            this.headerTemplate = headerRef != null ? TemplateCompiler.compileTemplate((String)this.getFileContent(headerRef)) : TemplateCompiler.compileTemplate((String)this.getResourceContent("header.html.template"));
            String footerRef = this.getConfig(config, "org.uberfire.template.footer");
            this.footerTemplate = footerRef != null ? TemplateCompiler.compileTemplate((String)this.getFileContent(footerRef)) : TemplateCompiler.compileTemplate((String)this.getResourceContent("footer.html.template"));
            this.userDataTemplate = TemplateCompiler.compileTemplate((String)this.getResourceContent("user_data_on_html.template"));
        }
    }

    private String getFileContent(String fileName) {
        try {
            return this.getTemplateContent(new BufferedInputStream(new FileInputStream(fileName)));
        }
        catch (FileNotFoundException e) {
            throw new IllegalStateException("Template file not found.", e);
        }
    }

    private String getResourceContent(String resourceName) {
        return this.getTemplateContent(new BufferedInputStream(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(resourceName)));
    }

    private String getTemplateContent(BufferedInputStream content) {
        try {
            ByteArrayOutputStream outContent = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)content, (OutputStream)outContent);
            content.close();
            return outContent.toString();
        }
        catch (IOException ex) {
            throw new IllegalStateException("Can't copy content.", ex);
        }
    }

    private String getConfig(ServletConfig config, String key) {
        String keyValue = config.getInitParameter(key);
        if (keyValue != null && keyValue.isEmpty()) {
            return null;
        }
        return keyValue;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html");
        response.setCharacterEncoding("UTF-8");
        PrintWriter writer = response.getWriter();
        Locale locale = request.getLocale();
        if (this.appTemplate != null) {
            this.loadApp(writer, locale);
        } else {
            this.loadHeader(writer);
            this.loadUserInfo(writer);
            this.loadFooter(writer);
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    private void loadApp(PrintWriter writer, Locale locale) {
        Identity subject = SecurityFactory.getIdentity();
        String localeTag = locale.getLanguage() + "_" + locale.getCountry();
        HashMap<String, String> map = new HashMap<String, String>((Subject)subject, localeTag){
            final /* synthetic */ Subject val$subject;
            final /* synthetic */ String val$localeTag;
            {
                this.val$subject = subject;
                this.val$localeTag = string;
                this.put("name", this.val$subject.getName());
                this.put("roles", UberfireServlet.this.collectionAsString(this.val$subject.getRoles()));
                this.put("properties", UberfireServlet.this.mapAsString(this.val$subject.getProperties()));
                this.put("locale", this.val$localeTag);
            }
        };
        String content = TemplateRuntime.execute((CompiledTemplate)this.appTemplate, (Map)map).toString();
        writer.append(content);
    }

    private void loadHeader(PrintWriter writer) {
        String content = (String)TemplateRuntime.execute((CompiledTemplate)this.headerTemplate);
        writer.append(content);
    }

    private void loadFooter(PrintWriter writer) {
        String content = (String)TemplateRuntime.execute((CompiledTemplate)this.footerTemplate);
        writer.append(content);
    }

    private void loadUserInfo(PrintWriter writer) {
        Identity subject = SecurityFactory.getIdentity();
        HashMap<String, String> map = new HashMap<String, String>((Subject)subject){
            final /* synthetic */ Subject val$subject;
            {
                this.val$subject = subject;
                this.put("name", this.val$subject.getName());
                this.put("roles", UberfireServlet.this.collectionAsString(this.val$subject.getRoles()));
                this.put("properties", UberfireServlet.this.mapAsString(this.val$subject.getProperties()));
            }
        };
        String content = TemplateRuntime.execute((CompiledTemplate)this.userDataTemplate, (Map)map).toString();
        writer.append(content);
    }

    private String collectionAsString(Collection<Role> collection) {
        StringBuilder sb = new StringBuilder();
        Iterator<Role> iterator = collection.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            Role next = iterator.next();
            sb.append('\"').append(next.getName()).append('\"');
            if (i + 1 < collection.size()) {
                sb.append(", ");
            }
            ++i;
        }
        return sb.toString();
    }

    private String mapAsString(Map<String, String> map) {
        StringBuilder sb = new StringBuilder();
        Iterator<Map.Entry<String, String>> iterator = map.entrySet().iterator();
        int i = 0;
        while (iterator.hasNext()) {
            Map.Entry<String, String> next = iterator.next();
            sb.append('\"').append(next.getKey()).append('\"').append(":").append('\"').append(next.getValue()).append('\"');
            if (i + 1 < map.size()) {
                sb.append(", ");
            }
            ++i;
        }
        return sb.toString();
    }
}

